/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.imports.ciel;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;
import ro.atreides.contabilitate.gui.EditNirAddEntryInterface;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.units.UnitsLogic;

public class CielInventarDeschidereImporter {
    private Magazie magazie;
    private StockLogic stockLogic;
    private EditNirAddEntryInterface inter;

    public CielInventarDeschidereImporter(StockLogic logic, Magazie m, EditNirAddEntryInterface inter) {
        this.stockLogic = logic;
        this.magazie = m;
        this.inter = inter;
    }

    public void importInventarDeschidere(String inputFile) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
            String line = reader.readLine();
            int lineNumber = 1;
            while (line != null) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                String cod = (String)fields.get(0);
                String cantS = (String)fields.get(3);
                String unitName = (String)fields.get(4);
                String valoareS = (String)fields.get(5);
                String valoareCuTvaS = (String)fields.get(6);
                Unit unit = UnitsLogic.getInstance().getUnitByName(unitName);
                if (unit != null) {
                    if (Validators.correctDouble(valoareS)) {
                        if (Validators.correctDouble(cantS)) {
                            Product product = NomeclaturaLogic.getInstance().getProductByCodBare(cod);
                            if (product != null) {
                                int idStock = this.stockLogic.getStockInterface().getIdStock(product.getId());
                                if (idStock > 0) {
                                    double cant = Utils.parseDouble(cantS);
                                    double pretAcz = Utils.parseDouble(valoareS);
                                    this.inter.addEntry(idStock, product.getName(), unit.getLabel(), cant, pretAcz, -1.0, unit.getId(), this.magazie.getId(), this.magazie.getLabel(), 1);
                                } else {
                                    Logger.logWarning(this, "Linia: " + lineNumber + " Cod bare \"" + cod + "\" neasociat cu un produs finit. Linie ignorata");
                                }
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + " Cod bare \"" + cod + "\" inexistent. Linie ignorata");
                            }
                        } else {
                            Logger.logWarning(this, "Linia: " + lineNumber + " Cantitatea nu este un numar. Linie ignorata");
                        }
                    } else {
                        Logger.logWarning(this, "Linia: " + lineNumber + " Valoarea nu este un numar. Linie ignorata");
                    }
                } else {
                    Logger.logWarning(this, "Linia: " + lineNumber + " Unitatea de masura " + unitName + " nu exista. Linie ignorata");
                }
                line = reader.readLine();
                ++lineNumber;
            }
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }
}

