/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.imports.ciel;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import jxl.read.biff.BiffException;
import ro.atreides.contabilitate.imports.ciel.CielTransferItem;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class CielTransferuriImportFromExcel {
    private ConnectionPool pool = ConnectionPool.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTransferuri(String transferuriFile) {
        try {
            ExcelUtils.readExcel(new File(transferuriFile), new ExcelImportInterface(){
                private int line = 0;
                private int startLine = -1;
                private String magazieSursa = "";
                private String magazieDestinatie = "";
                private String data = "";
                private String currentCod = "";
                private String currentQuantity = "";
                private boolean finished = false;
                private Vector items = new Vector();

                @Override
                public void sheetEnd(String sheetName) {
                }

                @Override
                public void lineEnd() {
                    ++this.line;
                    if (this.startLine > 0 && Validators.correctString(this.currentQuantity)) {
                        CielTransferItem cti = new CielTransferItem();
                        cti.setCod(this.currentCod);
                        cti.setQuantity(this.currentQuantity);
                        this.items.add(cti);
                    }
                    if (this.finished) {
                        if (this.items.size() > 0) {
                            CielTransferuriImportFromExcel.this.adaugaTransfer(this.magazieSursa, this.magazieDestinatie, this.data, this.items, this.line);
                        }
                        this.data = "";
                        this.magazieSursa = "";
                        this.magazieDestinatie = "";
                        this.finished = false;
                        this.startLine = -1;
                        this.items.clear();
                    }
                    this.currentCod = "";
                    this.currentQuantity = "";
                }

                @Override
                public void lineStart() {
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void valueRead(int row, int column, String value) {
                    switch (column) {
                        case 1: {
                            if (Validators.correctString(value)) {
                                if (this.line <= this.startLine + 2) break;
                                this.currentCod = value;
                                break;
                            }
                            if (this.line <= this.startLine + 3) break;
                            this.startLine = -1;
                            this.finished = true;
                            break;
                        }
                        case 2: {
                            if (!Validators.correctString(value) || !value.startsWith("Document")) break;
                            this.startLine = this.line;
                            this.finished = false;
                            break;
                        }
                        case 3: {
                            if (this.line != this.startLine + 1) break;
                            this.data = value;
                            break;
                        }
                        case 7: {
                            if (!Validators.correctString(value) || this.line <= this.startLine + 3) break;
                            this.currentQuantity = value;
                            break;
                        }
                        case 11: {
                            if (this.line == this.startLine) {
                                this.magazieSursa = value;
                            }
                            if (this.line != this.startLine + 1) break;
                            this.magazieDestinatie = value;
                            break;
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adaugaTransfer(String magazieSursa, String magazieDestinatie, String data, Vector items, int lineNumber) {
        Magazie sursa = StockLogic.getInstance().getMagazieByLabel(magazieSursa);
        Magazie destinatie = StockLogic.getInstance().getMagazieByLabel(magazieDestinatie);
        try {
            Date d1 = Formatters.DOTTED_DATE_FORMAT_RO.parse(data);
            Timestamp t = new Timestamp(d1.getTime());
            Vector<StockTransferItem> transferItems = new Vector<StockTransferItem>();
            for (int i = 0; i < items.size(); ++i) {
                CielTransferItem cti = (CielTransferItem)items.elementAt(i);
                StockTransferItem transferItem = new StockTransferItem();
                Product p = NomeclaturaLogic.getInstance().getProductByPartialCodBareNoCommit(cti.getCod());
                if (p != null) {
                    int idStock = StockLogic.getInstance().getStockInterface().getIdStockForProductNoCommit(p.getId());
                    String q1 = cti.getQuantity();
                    q1 = q1.replaceAll("\\?", "");
                    double q = Utils.parseDouble(q1);
                    transferItem.setIdStock(idStock);
                    transferItem.setQuantity(q);
                    transferItems.add(transferItem);
                    continue;
                }
                Logger.logWarning(this, "Line : " + lineNumber + " . Nu am gasit produsul cu codul " + cti.getCod());
            }
            int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistru(RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.key, RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.nume, true);
            StockLogic.getInstance().addTransferNoCommit(sursa.getId(), destinatie.getId(), t, transferItems, 0.0, 0.0, 2, false, nrDoc, AdministrationPanel.loggedUser);
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }
}

