/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.imports.magister;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import jxl.read.biff.BiffException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.imports.GenericFacturaXlsImporter;
import ro.atreides.contabilitate.imports.GenericFacturaXlsImporterInterface;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class MagisterImporter {
    public static void importFacturiPeFurnizori(File facturaXls, final int idSocietateaNoastra) {
        try {
            final StringBuffer errorsAtLine = new StringBuffer();
            final Sectie first = NomeclaturaLogic.getInstance().getAllSectii().get(0);
            final int idSectie = first.getId();
            final Tva tvaNoi = TvaLogic.getInstance().getTvas().get(0);
            String logFile = FileUtils.getTempDir() + File.separator + "magister_import_pe_furnizori.csv";
            final FileWriter magisterFileWriter = new FileWriter(logFile);
            magisterFileWriter.write("Linie|achizitieProdus|vanzareProdus|achizitiNir|vanzareNir|achizitieCumulat|vanzareCumulat\n");
            magisterFileWriter.flush();
            GenericFacturaXlsImporter importer = new GenericFacturaXlsImporter(new GenericFacturaXlsImporterInterface(){
                private String lastCategorie = null;
                private Vector nirItems = new Vector();
                double valoareFaraTvaS;
                double valoareTotalaS;
                double cumulatAchizitie;
                double cumulatVanzare;
                Date nirDate = new Date();
                int currentNir = 1;
                boolean stopAfterFirstNir = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void importLine(String magazia, String categoria, String numeProdus, String um, String codBare, double cantitate, double pretAchizitie, double pretVanzare, int line) {
                    if (this.lastCategorie != null && !categoria.equalsIgnoreCase(this.lastCategorie)) {
                        double cotaTva = this.valoareTotalaS / this.valoareFaraTvaS - 1.0;
                        cotaTva = FloatUtils.roundFloat(cotaTva, 2);
                        Tva tva = TvaLogic.getInstance().getTvaByCota(cotaTva);
                        try {
                            String groups = "1";
                            Client furnizor = ClientLogic.getInstance().getClientByNameNoCommit(this.lastCategorie);
                            while (furnizor == null) {
                                ClientLogic.getInstance().addPersJuridicaNoCommit(this.lastCategorie, "", "", "", 1, "", "", "", "", "", "", "", "", "", "", 0.0, -1, "", 0, 0.0, groups, "", "", "", "", "");
                                furnizor = ClientLogic.getInstance().getClientByNameNoCommit(this.lastCategorie);
                            }
                            this.nirDate = DateUtils.addMinutesToDate(this.nirDate, 1);
                            Timestamp timeDate = new Timestamp(this.nirDate.getTime());
                            if (tva == null) {
                                tva = tvaNoi;
                            }
                            int nrNir = ContaLogic.getInstance().getNextNrNir(idSocietateaNoastra, true);
                            int idNir = ContaLogic.getInstance().addNirNoCommit(nrNir + "", "", timeDate, furnizor.getId(), nrNir, this.nirItems, false, new Vector(), true, idSocietateaNoastra, ContaLogic.TIP_DOCUMENT_NIR.Factura.getTip(), StockLogic.COMANDA_TYPE.EFECTUAT, timeDate);
                            ContaLogic.getInstance().closeNirNoCommit(idNir, 0.0, 0.0, 0.0, this.valoareFaraTvaS, this.valoareTotalaS - this.valoareFaraTvaS, this.valoareTotalaS);
                            ConnectionPool.getInstance().commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                ConnectionPool.getInstance().rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        }
                        finally {
                            ConnectionPool.getInstance().releaseConnection();
                        }
                        this.nirItems.clear();
                        this.valoareFaraTvaS = 0.0;
                        this.valoareTotalaS = 0.0;
                        this.stopAfterFirstNir = true;
                    }
                    this.lastCategorie = categoria;
                    Magazie m = StockLogic.getInstance().getMagazieByLabel(magazia);
                    if (m == null) {
                        Logger.logWarning(this, "Linia " + line + " : Magazia " + magazia + " nu exista.");
                        return;
                    }
                    Unit unit = UnitsLogic.getInstance().getUnitByName(um);
                    int idUnit = -1;
                    idUnit = unit == null ? UnitsLogic.getInstance().addUnit(um) : unit.getId();
                    if (idUnit > 0) {
                        int idStock = ContaLogic.getInstance().importNirProductFromExcel(um, magazia, numeProdus, pretVanzare, codBare, categoria, idUnit, line, idSectie, first, tvaNoi);
                        if (idStock > 0) {
                            double valoareAchizitie = pretAchizitie * cantitate;
                            double valoareVanzare = pretVanzare * cantitate;
                            this.valoareFaraTvaS += valoareAchizitie;
                            this.valoareTotalaS += valoareVanzare;
                            this.cumulatAchizitie += valoareAchizitie;
                            this.cumulatVanzare += valoareVanzare;
                            NirEntryFull toAdd = new NirEntryFull(-1, -1, idStock, numeProdus, um, cantitate, pretAchizitie, -1.0, -1.0, pretVanzare, tvaNoi.getCota(), idUnit, tvaNoi.getCota(), m.getId(), m.getLabel(), 1);
                            toAdd.setNrCrt(this.nirItems.size() + 1);
                            toAdd.compute();
                            this.nirItems.add(toAdd);
                            String s = line + "|" + Utils.getString2Decimals(valoareAchizitie) + "|" + Utils.getString2Decimals(valoareVanzare) + "|" + Utils.getString2Decimals(this.valoareFaraTvaS) + "|" + Utils.getString2Decimals(this.valoareTotalaS) + "|" + Utils.getString2Decimals(this.cumulatAchizitie) + "|" + Utils.getString2Decimals(this.cumulatVanzare);
                            try {
                                magisterFileWriter.write(s + "\n");
                                magisterFileWriter.flush();
                            }
                            catch (IOException e) {
                                Logger.logException(this, (Exception)e);
                            }
                        } else {
                            System.out.println("BIG PROBLEM");
                        }
                    } else {
                        Logger.logWarning(this, "Linia " + line + " este definita incorect si va fi ignorata.");
                        errorsAtLine.append(line + ", ");
                    }
                }
            });
            ExcelUtils.readExcel(facturaXls, importer);
        }
        catch (IOException e) {
            Logger.logException("MagisterImporter", (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException("MagisterImporter", (Exception)((Object)e));
        }
    }
}

