/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.saga;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.export.ContaExportBean;
import ro.atreides.contabilitate.export.ContaGenericExport;
import ro.atreides.contabilitate.export.saga.ExportSaga;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ProductPriceInterface;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class SagaExportLogic
extends LangRoAll {
    private static SagaExportLogic instance;

    public static synchronized SagaExportLogic getInstance() {
        if (instance == null) {
            instance = new SagaExportLogic();
        }
        return instance;
    }

    private SagaExportLogic() {
    }

    public String exportDateSaga(Component parent, ProductPriceInterface productInterface) {
        ContaExportBean exportBean = ContaGenericExport.exportDateConta(parent);
        String saveDir = exportBean.getDestinationPath();
        Date d1 = exportBean.getD1();
        Date d2 = exportBean.getD2();
        boolean ok = true;
        Vector<Stock> produseCuProbleme = this.exportProduseFiniteSaga(saveDir, d1, d2, productInterface);
        if (produseCuProbleme.size() > 0 && !DialogUtils.confirmDialog(parent, "Exista " + produseCuProbleme.size() + " produse cu probleme!! Consultati logul !! Continuam ", LangRoAll.nuPotContinua)) {
            return null;
        }
        ok = this.exportFurnizoriSaga(saveDir, d1, d2);
        if (!ok) {
            return null;
        }
        ok = this.exportClientiSaga(saveDir, d1, d2);
        if (!ok) {
            return null;
        }
        ok = ExportSaga.exportNiruri(saveDir, d1, d2);
        if (!ok) {
            return null;
        }
        ok = this.exportBonuriConsum(saveDir, d1, d2);
        if (!ok) {
            return null;
        }
        return saveDir;
    }

    private boolean exportNoteContabileSaga(String saveDir, Timestamp startDate, Timestamp stopDate) {
        try {
            String noteContabileFile = saveDir + File.separator + "NC_" + Formatters.DATE_FORMAT_RO.format(startDate) + "_" + Formatters.DATE_FORMAT_RO.format(stopDate) + ".dbf";
            Vector noteContabile = new Vector();
            if (Config.getInstance().isOptionActive("exportContaSagaItems", "inVal", false)) {
                Vector ncNiruri = ContaLogic.getInstance().getNoteContabileNiruri(startDate, stopDate);
                noteContabile.addAll(ncNiruri);
            }
            if (Config.getInstance().isOptionActive("exportContaSagaItems", "regcasa", false)) {
                Vector registruCasa = ContaLogic.getInstance().getNoteContabileRegCasa(startDate, stopDate);
                noteContabile.addAll(registruCasa);
            }
            if (Config.getInstance().isOptionActive("exportContaSagaItems", "vzVal", false)) {
                // empty if block
            }
            ExportSaga.exportNoteContabile(noteContabile, noteContabileFile);
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    private boolean exportFurnizoriSaga(String saveDir, Date startDate, Date stopDate) {
        try {
            String furnizoriFile = saveDir + File.separator + "Furnizori_" + Formatters.DATE_FORMAT_RO.format(startDate) + "_" + Formatters.DATE_FORMAT_RO.format(stopDate) + ".dbf";
            Vector<Client> allFurnizori = ClientLogic.getInstance().getPartnersInGroup(1, 1);
            ExportSaga.exportFurnizori(allFurnizori, furnizoriFile);
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    private boolean exportClientiSaga(String saveDir, Date startDate, Date stopDate) {
        try {
            String furnizoriFile = saveDir + File.separator + "Clienti_" + Formatters.DATE_FORMAT_RO.format(startDate) + "_" + Formatters.DATE_FORMAT_RO.format(stopDate) + ".dbf";
            Vector<Client> allClienti = ClientLogic.getInstance().getPartnersInGroup(2, 1);
            ExportSaga.exportClienti(allClienti, furnizoriFile);
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    private boolean exportBonuriConsum(String saveDir, Date startDate, Date stopDate) {
        try {
            String furnizoriFile = saveDir + File.separator + "BC_" + Formatters.DATE_FORMAT_RO.format(startDate) + "_" + Formatters.DATE_FORMAT_RO.format(stopDate) + ".dbf";
            ExportSaga.exportBonuriConsum(furnizoriFile, startDate, stopDate);
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    private Vector<Stock> exportProduseFiniteSaga(String saveDir, Date startDate, Date stopDate, ProductPriceInterface productInterface) {
        try {
            String articoleFile = saveDir + File.separator + "Articole_" + Formatters.DATE_FORMAT_RO.format(startDate) + "_" + Formatters.DATE_FORMAT_RO.format(stopDate) + ".dbf";
            Vector stocks = StockLogic.getInstance().getPowerSearchStocks();
            Vector<Stock> materiiPrimeFaraCotaTva = ExportSaga.exportProduseFinite(stocks, articoleFile, productInterface);
            return materiiPrimeFaraCotaTva;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    public static enum RegistreConstants {
        NOTA_PREDARE("export_winmentor_note_predare", "Nota Predare"),
        BON_CONSUM("export_winmentor_bon_consum", "Bon Consum"),
        MONETAR("export_winmentor_monetar", "Monetar");

        String key;
        String nume;

        private RegistreConstants(String key, String nume) {
            this.key = key;
            this.nume = nume;
        }

        public String getKey() {
            return this.key;
        }

        public String getNume() {
            return this.nume;
        }
    }
}

