/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.mortbay.jetty.Server;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.CashRegisterInterface;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLicenseVerifier;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrPrevalidareType;
import ro.atreides.ecr.EcrPrintingThread;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.ExtraCommandsBean;
import ro.atreides.ecr.GenericXmlHandler;
import ro.atreides.ecr.GenericXmlHandlerInterface;
import ro.atreides.ecr.NonFiscalReceiptPrintingThread;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.tricky.NonPrintedBonInterface;
import ro.atreides.utils.web.WebServerInterface;

public abstract class AbstractCashRegister
implements CashRegisterInterface {
    protected Properties conf;
    protected EcrPrintingThread pt;
    public int onlineDecimalPlaces;
    public static int ecrMinGrp;
    public static int ecrMaxGrp;
    public int webServerPort;
    public String ecrExeFile;
    public String onlineItemsFile;
    public String onlineErrFile;
    public String onlineLogFile;
    public String onlineDirectory;
    public String systemPrefix;
    public String expectedReply;
    public String fileNameTemplate;
    public String nonfiscalReceiptLocation;
    public boolean bonNumbering;
    protected boolean licenseRequired;
    protected WebServerInterface webserver;
    protected NonPrintedBonInterface inter;
    protected boolean forceF = false;
    protected boolean multipleTipPlataSupported = true;
    protected Hashtable<String, String> paymentTypes;
    protected boolean overridePaymentCodes;

    public boolean isPrevalidareBonuriEnabled() {
        boolean prevalidareEnabled = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.prevalidareBonEnabled);
        if (!prevalidareEnabled) {
            return false;
        }
        EcrPrevalidareType prevalidare_type = null;
        String prevalidareS = this.conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.PREVALIDARE_TYPE.toString());
        return !Validators.correctString(prevalidareS) || (prevalidare_type = EcrPrevalidareType.valueOf(prevalidareS)) == null || prevalidare_type != EcrPrevalidareType.FARA_PREVALIDARE;
    }

    @Override
    public boolean isForceF() {
        return this.forceF;
    }

    @Override
    public void setForceF(boolean forceF) {
        this.forceF = forceF;
    }

    public void setLicenseRequired(boolean licenseRequired) {
        this.licenseRequired = licenseRequired;
    }

    @Override
    public void setInter(NonPrintedBonInterface inter) {
        this.inter = inter;
    }

    public void buildConfiguration(Properties conf) throws RuntimeException {
        this.conf = conf;
        this.overridePaymentCodes = Boolean.parseBoolean(conf.getProperty("overridePaymentCodes", "false"));
        this.ecrExeFile = conf.getProperty("ecrExeFile");
        this.onlineItemsFile = conf.getProperty("ecrItemsFile");
        this.onlineErrFile = conf.getProperty("ecrErrFile");
        this.onlineLogFile = conf.getProperty("ecrLogFile");
        this.onlineDirectory = conf.getProperty("ecrDirectory");
        this.systemPrefix = conf.getProperty("ecrSystemPrefix");
        this.onlineDecimalPlaces = Integer.parseInt(conf.getProperty("ecrDecimalPlaces", "2"));
        ecrMinGrp = Integer.parseInt(conf.getProperty("ecrMinGrp", "1"));
        ecrMaxGrp = Integer.parseInt(conf.getProperty("ecrMaxGrp", "1"));
        this.bonNumbering = Boolean.parseBoolean(conf.getProperty("bonNumbering", "false"));
        this.expectedReply = conf.getProperty("expectedReply");
        this.webServerPort = Integer.parseInt(conf.getProperty("webServerPort", "8080"));
        this.fileNameTemplate = conf.getProperty("fileNameTemplate");
        this.nonfiscalReceiptLocation = conf.getProperty("nonfiscalReceiptLocation");
        this.paymentTypes = new Hashtable();
        String paymentTypesString = conf.getProperty("paymentTypes", "Cash");
        Vector types = Utils.splitString(paymentTypesString, ',');
        for (int i = 0; i < types.size(); ++i) {
            String type = (String)types.elementAt(i);
            String value = conf.getProperty("paymentType_" + type, "");
            type = type.toUpperCase();
            this.paymentTypes.put(type, value);
        }
        Logger.logInfo(this, "table = " + this.paymentTypes);
    }

    public boolean start() {
        String command = "";
        if (Validators.correctString(this.ecrExeFile)) {
            command = this.systemPrefix + " " + this.ecrExeFile;
        }
        this.pt = new EcrPrintingThread(this.onlineDirectory, command, this.onlineItemsFile, this.onlineLogFile, this.onlineErrFile, this.bonNumbering, this.expectedReply, this.fileNameTemplate);
        this.pt.setName("EcrPrintingThread");
        this.pt.start();
        if (this.nonfiscalReceiptLocation != null) {
            new NonFiscalReceiptPrintingThread(this.nonfiscalReceiptLocation, this);
        }
        return true;
    }

    public void printNonFiscalBon(String inputFile) {
    }

    public static String getDepartament(EcrSale newsaleentry) {
        return newsaleentry.getDepartament();
    }

    public static String getGrupa(EcrSale newsaleentry) {
        return "" + AbstractCashRegister.getRightNumber(newsaleentry.getGrupa(), ecrMinGrp, ecrMaxGrp);
    }

    public static int getRightNumber(int actualNumber, int min, int max) {
        int result = actualNumber % max + 1;
        if (result < min) {
            result = min;
        }
        return result;
    }

    public void finishInitialize() {
    }

    public WebServerInterface getWebserver() {
        return this.webserver;
    }

    public void setWebserver(WebServerInterface webserver) {
        this.webserver = webserver;
        try {
            System.out.println("starting Web server");
            if (webserver != null) {
                Server s = (Server)webserver.prepareWebServer(this.webServerPort);
                s.addWebApplication("/ecrPrint", "./webapps/ecrPrint/");
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
    }

    @Override
    public void printX() {
    }

    @Override
    public void printZ() {
    }

    @Override
    public void introduNumerar(double suma) {
    }

    @Override
    public boolean numerarInputReady() {
        return false;
    }

    @Override
    public void processBonFiscal(String items, String idBon, int idOrder, EcrType ecrType, String serieFiscala, BonValidatorResponseInterface responseInterface) {
        this.pt.addToQueue(items);
    }

    public void stopECR() {
    }

    public void startECR() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXml(String fileName) {
        block13: {
            try {
                GenericXmlHandler handler = new GenericXmlHandler(this.getXmlHandlerInterface());
                Utils.importXml((DefaultHandler)handler, fileName);
                Vector<ExtraCommandsBean> extraCommands = handler.getExtraCommands();
                if (extraCommands != null && extraCommands.size() > 0) {
                    for (ExtraCommandsBean extraCommand : extraCommands) {
                        switch (extraCommand.getOperation()) {
                            case addCash: {
                                this.introduNumerar(extraCommand.getValue());
                                break;
                            }
                            case removeCash: {
                                this.introduNumerar(-extraCommand.getValue().doubleValue());
                                break;
                            }
                            case xReport: {
                                this.printX();
                                break;
                            }
                            case zReport: {
                                this.printZ();
                            }
                        }
                    }
                    break block13;
                }
                Vector<EcrSale> sales = handler.getSales();
                Vector<EcrPlata> plati = handler.getPlati();
                Vector<String> comments = handler.getComments();
                double total = handler.getTotalSales();
                String idBon = handler.getIdBon();
                int idOrder = handler.getIdOrder();
                Collections.sort(plati, new Comparator<EcrPlata>(){

                    @Override
                    public int compare(EcrPlata o1, EcrPlata o2) {
                        if (o1.isDefault()) {
                            return 1;
                        }
                        return -1;
                    }
                });
                this.printBonFiscal(sales, total, plati, null, comments, idBon, idOrder);
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (SAXException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    protected GenericXmlHandlerInterface getXmlHandlerInterface() {
        return new GenericXmlHandlerInterface(){

            @Override
            public String getEcrPaymentCode(String paymentName) {
                return AbstractCashRegister.this.paymentTypes.get(paymentName);
            }
        };
    }

    @Override
    public int getNoOfBonsToPrint() {
        return 0;
    }

    @Override
    public void deleteNonPrintedBons() {
    }

    public void setMultipleTipPlataSupported(boolean multipleTipPlataSupported) {
        this.multipleTipPlataSupported = multipleTipPlataSupported;
    }

    @Override
    public boolean multiplePaymentTypesSupported() {
        return this.multipleTipPlataSupported;
    }

    @Override
    public void deleteBonByIdentifier(String identifier) {
    }

    public boolean ecrConnectedAtStartup() {
        return true;
    }

    @Override
    public String getForcedEcrMapping(String tipPlata2) {
        if (this.overridePaymentCodes) {
            return this.paymentTypes.get(tipPlata2.toUpperCase());
        }
        return null;
    }

    public void clearFeedbackFile() {
    }

    public String getFeedbackByIdentifier(String identifier) {
        return "";
    }

    public void addListener(EcrFeedbackInterface listener) {
    }

    public void addLicenseCode(String licenseCode) {
    }

    public void setEcrSerialNumberReadInterface(EcrSerialNumberReadInterface ecrSerialNumberReadInterface) {
    }

    public void copieBon() {
    }
}

