/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

public class BinaryUtils {
    public static final String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static String toHexString(byte b) {
        return BinaryUtils.firstHexDigitAsString(b) + BinaryUtils.secondHexDigitAsString(b);
    }

    public static String toHexString(byte[] in) {
        return BinaryUtils.toHexString(in, 0, in.length);
    }

    public static String toHexString(byte[] in, int offset, int length) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuilder out = new StringBuilder(length * 2);
        out.append("{ ");
        for (int i = offset; i < length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            out.append(" ");
        }
        out.append("}");
        return out.toString();
    }

    public static String toBinaryString(byte b) {
        return Integer.toBinaryString(b & 0xFF);
    }

    public static String toBinaryString(byte[] array) {
        return BinaryUtils.toBinaryString(array, false);
    }

    public static String toBinaryStringDetailed(byte[] array) {
        return BinaryUtils.toBinaryString(array, true);
    }

    private static String toBinaryString(byte[] array, boolean detailed) {
        StringBuilder buffer = new StringBuilder("{ ");
        if (array != null) {
            for (byte b : array) {
                if (detailed) {
                    buffer.append("0x").append(BinaryUtils.firstHexDigitAsString(b)).append(BinaryUtils.secondHexDigitAsString(b)).append(":");
                }
                String s = BinaryUtils.toBinaryString(b);
                for (int j = 0; j < 8 - s.length(); ++j) {
                    buffer.append("0");
                }
                buffer.append(s).append(" ");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static byte[] toBytes(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static byte[] toBytes(short crc) {
        byte byte1 = (byte)(crc & 0xFF);
        crc = (short)(crc >> 8);
        byte byte0 = (byte)(crc & 0xFF);
        return new byte[]{byte0, byte1};
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static byte firstHexDigitAsByte(byte b) {
        byte ch = (byte)(b & 0xF0);
        ch = (byte)(ch >>> 4);
        ch = (byte)(ch & 0xF);
        return ch;
    }

    public static byte secondHexDigitAsByte(byte b) {
        return (byte)(b & 0xF);
    }

    public static String firstHexDigitAsString(byte b) {
        return pseudo[BinaryUtils.firstHexDigitAsByte(b)];
    }

    public static String secondHexDigitAsString(byte b) {
        return pseudo[BinaryUtils.secondHexDigitAsByte(b)];
    }

    public static byte[] getAsciiBytes(String input) {
        byte[] result = new byte[input.length()];
        BinaryUtils.copyAsciiBytes(input, 0, result, 0, result.length);
        return result;
    }

    public static void copyAsciiBytes(String src, int srcOffset, byte[] dest, int destOffset, int length) {
        if (src == null || dest == null) {
            throw new NullPointerException();
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is < 0");
        }
        length = Math.min(length, src.length() - srcOffset);
        length = Math.min(length, dest.length - destOffset);
        for (int i = 0; i < length; ++i) {
            char c = src.charAt(srcOffset + i);
            dest[destOffset + i] = (byte)c;
        }
    }
}

