/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EcrDialogUtils {
    public static JDialog getDialog(Component parent, Component panel, String title) {
        JDialog dialog = EcrDialogUtils.buildDialog(parent);
        dialog.setTitle(title);
        EcrDialogUtils.initDefaultDialog(dialog, panel, parent);
        return dialog;
    }

    private static JDialog buildDialog(Component parent) {
        JDialog dialog = null;
        if (parent != null) {
            dialog = new JDialog((Frame)((JFrame)parent), true);
        } else {
            Frame frame = null;
            dialog = new JDialog(frame, true);
        }
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        return dialog;
    }

    public static JDialog getDialog(Component panel, String title) {
        return EcrDialogUtils.getDialog(null, panel, title);
    }

    private static void initDefaultDialog(JDialog result, Component panel, Component parent) {
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridy = 0;
        c.gridx = 0;
        result.add(panel, c);
        result.pack();
        result.setLocationRelativeTo(parent);
    }

    public static String choiseDialog(Component parent, String labelText, String title, String[] buttons) {
        JLabel label = new JLabel(labelText);
        return EcrDialogUtils.choiseDialog1(parent, label, title, buttons);
    }

    private static String choiseDialog1(Component parent, Component p, String title, String[] buttons) {
        final String[] result = new String[1];
        JPanel panel = new JPanel(new GridBagLayout());
        final JDialog dialog = EcrDialogUtils.getDialog(parent, panel, title);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(3, 3, 3, 3);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        panel.add(p, c);
        ++c.gridy;
        c.weighty = 0.0;
        CallBack callback = new CallBack(){

            @Override
            public void call(String name) {
                result[0] = name;
                dialog.dispose();
            }
        };
        panel.add((Component)EcrDialogUtils.buildButtonsPanel(buttons, callback), c);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setResizable(false);
        dialog.setVisible(true);
        return result[0];
    }

    private static JPanel buildButtonsPanel(String[] buttons, final CallBack callback) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                callback.call(e.getActionCommand());
            }
        };
        for (int i = 0; i < buttons.length; ++i) {
            JButton button = new JButton(buttons[i]);
            button.addActionListener(listener);
            result.add((Component)button, c);
            ++c.gridx;
        }
        return result;
    }

    private static abstract class CallBack {
        private CallBack() {
        }

        public abstract void call(String var1);
    }
}

