/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import ro.atreides.ecr.EcrDialogUtils;
import ro.atreides.ecr.EcrInterface;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.datecs.nativeImpl.Product;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.GuiUtils;

public class EcrInterfaceImpl
implements EcrInterface {
    private int id;
    private boolean errorNotifications;

    public EcrInterfaceImpl(int id) {
        this.id = id;
    }

    @Override
    public boolean isErrorNotifications() {
        return this.errorNotifications;
    }

    @Override
    public void setErrorNotifications(boolean errorNotifications) {
        this.errorNotifications = errorNotifications;
    }

    @Override
    public int ecrNotPresent() {
        try {
            EcrLogic.getInstance().ecrConnected(false);
        }
        catch (NullPointerException e) {
            Logger.logException(this, (Exception)e);
        }
        if (this.errorNotifications) {
            return this.ecrNotPresent("<html><font color=red size=5>Casa cu id-ul " + this.id + " nu a fost detectata!</font>" + "<br>Verificati:" + "<font color=blue><br>1) Casa este conectata la calculator" + "<br>2) Casa este in modul vanzare" + "<br>3) Scoateti Z (golire)</font></html>");
        }
        return 0;
    }

    @Override
    public int failedPrint(Product p) {
        String s = "<html><font color=red size=4>Produsul </font><font color=blue>" + p + "</font>" + "<font color=red size=4> nu a fost tiparit.</font>" + "<br>Cauze posibile:" + "<br>1) format incorect" + "<br>2) Z nu a fost scos</html>";
        if (this.errorNotifications) {
            String[] buttons = new String[]{"Retipareste produs", "Continua fara acest produs", "Anuleaza intregul bon"};
            String result = EcrDialogUtils.choiseDialog(GuiUtils.currentFrame, s, "Atentie", buttons);
            if (result == null) {
                return 0;
            }
            if (result.equals(buttons[0])) {
                return 0;
            }
            if (result.equals(buttons[1])) {
                return 2;
            }
            if (result.equals(buttons[2])) {
                return 1;
            }
            return 0;
        }
        this.writeErrorsToFile(s);
        return 1;
    }

    private void writeErrorsToFile(String s) {
        try {
            FileUtils.writeTextToFile("errors.txt", s);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public int ecrRemoved() {
        try {
            EcrLogic.getInstance().ecrConnected(false);
        }
        catch (NullPointerException e) {
            Logger.logException(this, (Exception)e);
        }
        String s = "<html><font color=red size=5>Casa este deconectata!</font><br>Verificati:<font color=blue><br>1) Casa este conectata la calculator<br>2) Casa este in modul vanzare<br>3) Scoateti Z (golire)</font></html>";
        if (this.errorNotifications) {
            return this.ecrNotPresent(s);
        }
        return 0;
    }

    private int ecrNotPresent(String comment) {
        try {
            EcrLogic.getInstance().ecrConnected(false);
        }
        catch (NullPointerException e) {
            Logger.logException(this, (Exception)e);
        }
        if (this.errorNotifications) {
            String[] buttons = new String[]{"Incearca din nou"};
            EcrDialogUtils.choiseDialog(GuiUtils.currentFrame, comment, "Atentie", buttons);
            return 0;
        }
        return 0;
    }

    @Override
    public void ecrConnected() {
        try {
            EcrLogic.getInstance().ecrConnected(true);
        }
        catch (NullPointerException e) {
            Logger.logException(this, (Exception)e);
        }
    }
}

