/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Vector;
import ro.atreides.utils.AtrFloat;
import ro.deversoft.licensing.LicensingBean;
import ro.deversoft.licensing.LicensingJsonHandler;
import ro.deversoft.licensing.LicensingJsonHandlerInterface;

public class EcrLicenseVerifier {
    private static EcrLicenseVerifier instance = null;
    public static final String LICENSE_FILE_NAME = "license.json";
    private String serieFiscalaCasa;
    private Vector<FUNCTION> functions = new Vector();
    private APP_TYPE licensedApp = null;
    private boolean expired = false;
    public static final String nonFiscalLicenceOldSchool = "917b203efec1c523103f234b21b83e53bc3bed1";
    private Date expireDate = new Date();

    private EcrLicenseVerifier() {
    }

    public static synchronized EcrLicenseVerifier getInstance() {
        if (instance == null) {
            instance = new EcrLicenseVerifier();
        }
        return instance;
    }

    public String getSerieFiscalaCasa() {
        return this.serieFiscalaCasa;
    }

    public Vector<String> setSerieFiscalaCasaAndLicenseJson(String serieFiscalaCasa) {
        this.serieFiscalaCasa = serieFiscalaCasa;
        return this.loadLicenseFile(LICENSE_FILE_NAME, serieFiscalaCasa);
    }

    public void setSerieFiscalaCasaAndLicenseOldSchool(String serieFiscalaCasa, Vector<String> codes) {
        this.serieFiscalaCasa = serieFiscalaCasa;
        for (String s : codes) {
            if (!this.isLicensedOldSchool(serieFiscalaCasa, s)) continue;
            EcrLicenseVerifier.getInstance().setLicensedApp(APP_TYPE.fiscalWireBasic);
            break;
        }
    }

    public synchronized Vector<String> loadLicenseFile(String jsonLicenseFile, String serieFiscalaCasa) {
        boolean licenseFileExists = false;
        final Vector<String> errors2User = new Vector<String>();
        APP_TYPE newApp = null;
        final AtrFloat error = new AtrFloat();
        final String localComputerName = "ecr_" + serieFiscalaCasa;
        LicensingJsonHandler handler = new LicensingJsonHandler(new LicensingJsonHandlerInterface(){

            @Override
            public String getLocalComputerName() {
                return localComputerName;
            }

            @Override
            public void notifyUserError(String text, String title) {
                error.setValue(1.0);
                errors2User.add(text);
            }

            @Override
            public void notifyUserErrorAndRecord(String text, String title) {
                errors2User.add(text);
                error.setValue(1.0);
            }
        });
        File licenseFile = new File(jsonLicenseFile);
        if (licenseFile.exists()) {
            if (licenseFile.isDirectory()) {
                error.setValue(1.0);
                errors2User.add("Am gasit un director in loc de fisierul " + jsonLicenseFile);
            } else {
                licenseFileExists = true;
                try {
                    handler.load(jsonLicenseFile);
                    for (LicensingBean app : handler.getApplications()) {
                        APP_TYPE appT;
                        String appName = app.getName();
                        newApp = appT = APP_TYPE.valueOf(appName);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String hddIdFromLicenseFile = handler.getHddId();
        if (licenseFileExists && !serieFiscalaCasa.equals(hddIdFromLicenseFile)) {
            error.setValue(1.0);
            errors2User.add("Indentificatorul sistemului (" + serieFiscalaCasa + ") difera de identificatorul din licenta (" + hddIdFromLicenseFile + ")");
        }
        this.expireDate = handler.getExpireDate();
        this.expired = false;
        if (licenseFileExists && this.expireDate.before(new Date())) {
            error.setValue(1.0);
            errors2User.add("Licenta expirata");
            this.expired = true;
        }
        if (error.getValue() > 0.0) {
            newApp = null;
        }
        this.setLicensedApp(newApp);
        return errors2User;
    }

    private synchronized boolean isLicensedOldSchool(String seria, String license) {
        try {
            if (seria == null) {
                return false;
            }
            String hddID = seria + 87;
            if (hddID == null || hddID.length() < 1) {
                return false;
            }
            System.out.println(">>>>>>>>>>>>>>>>>> CALCULATING LICENSE <<<<<<<<<<<<<<<<<<<");
            MessageDigest encryptor = MessageDigest.getInstance("SHA1");
            hddID = hddID + "d1hfu53j4h5jhg4asb5ndhjkdf8hgj2dfhg7k345";
            encryptor.update(hddID.getBytes());
            byte[] key = encryptor.digest();
            StringBuffer hex = new StringBuffer(key.length);
            for (int i = 0; i < key.length; ++i) {
                byte b = key[i];
                hex.append(Integer.toHexString(0xFF & b));
            }
            String s = hex.toString();
            if (s.equalsIgnoreCase(license)) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    public final synchronized void setLicensedApp(APP_TYPE toSet) {
        this.functions.clear();
        if (toSet != null) {
            this.licensedApp = toSet;
            switch (toSet) {
                case fiscalWireUltimate: {
                    this.functions.add(FUNCTION.posIntegrationEnabled);
                }
                case fiscalWirePro: {
                    this.functions.add(FUNCTION.valoareZCurentEnabled);
                    this.functions.add(FUNCTION.verificareCuiEnabled);
                    this.functions.add(FUNCTION.verificareEroriEnabled);
                    this.functions.add(FUNCTION.raport394Enabled);
                    this.functions.add(FUNCTION.databaseEnabled);
                }
                case fiscalWireBasic: {
                    this.functions.add(FUNCTION.bonLimit300Disabled);
                    this.functions.add(FUNCTION.cashbackEnabled);
                    this.functions.add(FUNCTION.correctBonEnabled);
                    this.functions.add(FUNCTION.prevalidareBonEnabled);
                    this.functions.add(FUNCTION.comentariiFinalEnabled);
                    this.functions.add(FUNCTION.incarcaCasaEnabled);
                    this.functions.add(FUNCTION.printCodFiscalEnabled);
                    this.functions.add(FUNCTION.xzReportsEnabled);
                    this.functions.add(FUNCTION.raportareNrBonFiscalEnabled);
                }
            }
        }
    }

    public synchronized boolean isFunctionLicensed(FUNCTION toCheck) {
        return this.functions.contains((Object)toCheck);
    }

    public APP_TYPE getLicensedApp() {
        return this.licensedApp;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public static enum APP_TYPE {
        fiscalWireFree,
        fiscalWireBasic,
        fiscalWirePro,
        fiscalWireUltimate;

    }

    public static enum FUNCTION {
        bonLimit300Disabled,
        comentariiFinalEnabled,
        printCodFiscalEnabled,
        cashbackEnabled,
        incarcaCasaEnabled,
        xzReportsEnabled,
        raportareNrBonFiscalEnabled,
        correctBonEnabled,
        prevalidareBonEnabled,
        valoareZCurentEnabled,
        verificareCuiEnabled,
        verificareEroriEnabled,
        raport394Enabled,
        databaseEnabled,
        posIntegrationEnabled;

    }
}

