/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.EcrFactory;
import ro.atreides.ecr.EcrLicenseVerifier;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.EcrUserFeedbackInterface;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.web.WebServerInterface;
import ro.deversoft.drivers.datecs.gen3.noarch.Validators;

public class EcrLogic {
    private static EcrLogic instance;
    private AbstractCashRegister ecr;
    private boolean ecrConnected;
    private String nextBonCUI;
    private String serieFiscala;
    private EcrType ecrType;
    private BonValidatorResponseInterface responseInterface;
    public static final int fiscalwireFreeBonLimit = 300;
    private int availableBonsForToday = 300;
    private Date ecrDate = null;
    public static final String ECR_NOT_CONNECTED = "CASA DE MARCAT DECONECTATA";
    private EcrUserFeedbackInterface ecrUserFeedbackInterface;
    public static int skipBons;
    private int nrZ = -1;
    private int nrBon = -1;

    public void startDirDaemon(final File readFromDirFinal, final AbstractCashRegister cashRegister, final String charset, final String allowedExtensions) {
        Thread nativeReaderThread = new Thread(){

            @Override
            public void run() {
                final Vector extensions = Utils.splitString(allowedExtensions, ',');
                System.out.println("Starting native reader thread from dir : \"" + readFromDirFinal.getAbsolutePath() + "\" with charset : \"" + charset + "\" extensions : " + allowedExtensions);
                block6: while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        File[] inpFiles = readFromDirFinal.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                String fname = name.toLowerCase();
                                for (String extension : extensions) {
                                    if (!fname.endsWith(extension)) continue;
                                    return true;
                                }
                                return false;
                            }
                        });
                        if (inpFiles == null || inpFiles.length <= 0 || EcrLicenseVerifier.getInstance().getLicensedApp() == null) continue;
                        int i = 0;
                        while (true) {
                            if (i >= inpFiles.length) continue block6;
                            File nativeFile = inpFiles[i];
                            String nativeFilename = nativeFile.getAbsolutePath();
                            try {
                                String content = FileUtils.readFileToString(nativeFilename, Validators.correctString(charset) ? charset : null);
                                String name = nativeFile.getName();
                                int extensionStart = name.lastIndexOf(".");
                                name = name.substring(0, extensionStart);
                                cashRegister.processBonFiscal(content, name, -1, EcrLogic.this.ecrType, EcrLogic.this.serieFiscala, EcrLogic.this.responseInterface);
                                String newFile = nativeFilename + "_" + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(new Date()) + ".done";
                                nativeFile.renameTo(new File(newFile));
                            }
                            catch (IOException e) {
                                Logger.logException("EcrMain", (Exception)e);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        Logger.logException(this, e);
                        continue;
                    }
                    break;
                }
            }
        };
        nativeReaderThread.setName("Native reader thread");
        nativeReaderThread.start();
    }

    private EcrLogic(String ecrType, boolean licenceRequired, WebServerInterface webserver) {
        this.ecr = EcrFactory.buildEcr(ecrType, licenceRequired, webserver);
        if (this.ecr != null) {
            this.ecr.start();
        }
    }

    public static synchronized EcrLogic getInstance(String[] args, boolean licenseRequired, WebServerInterface webserver) {
        String ecrType = Utils.getCmdlineValue("-ecrType", args, null);
        instance = new EcrLogic(ecrType, licenseRequired, webserver);
        return instance;
    }

    public static synchronized EcrLogic getInstance() {
        return instance;
    }

    public AbstractCashRegister getEcr() {
        return this.ecr;
    }

    public void ecrConnected(boolean connected) {
        this.ecrConnected = connected;
    }

    public boolean isEcrConnected() {
        return this.ecrConnected;
    }

    public void setCurrentBonNumber(int nrZ, int nrBon) {
        this.nrZ = nrZ;
        this.nrBon = nrBon;
    }

    public int getNrBon() {
        return this.nrBon;
    }

    public int getNrZ() {
        return this.nrZ;
    }

    public boolean cashback(double sumaCatreClient1, boolean copie, Map configs) {
        try {
            Vector<EcrPlata> tipPlata2 = new Vector<EcrPlata>();
            Vector<String> comments = new Vector<String>();
            Vector<EcrSale> ecrSales = new Vector<EcrSale>();
            double[] cashbackValues = this.cashbackCompute(sumaCatreClient1, configs);
            double sumaCatreClient = cashbackValues[0];
            double valoareComision = cashbackValues[1];
            double totalComanda = cashbackValues[2];
            String codTvaEliberare = (String)configs.get(ECR_GUI_CONFIGS.ELIBERARE_TVA_COD.toString());
            double cotaTvaEliberare = Double.valueOf((String)configs.get(ECR_GUI_CONFIGS.ELIBERARE_TVA_COTA.toString()));
            int codProdusEliberare = Integer.valueOf((String)configs.get(ECR_GUI_CONFIGS.ELIBERARE_PRODUS_COD.toString()));
            String codDepartamentEliberare = (String)configs.get(ECR_GUI_CONFIGS.ELIBERARE_PRODUS_CODDEPARTAMENT.toString());
            String numeProdusEliberare = (String)configs.get(ECR_GUI_CONFIGS.ELIBERARE_PRODUS_NUME.toString());
            EcrSale sale = new EcrSale(numeProdusEliberare, 1.0, sumaCatreClient, sumaCatreClient, 0.0, codProdusEliberare, codDepartamentEliberare, 1, codTvaEliberare, cotaTvaEliberare);
            ecrSales.add(sale);
            if (Utils.isValueGreaterThanZero(valoareComision)) {
                String codTvaComision = (String)configs.get(ECR_GUI_CONFIGS.COMISION_TVA_COD.toString());
                double cotaTvaComision = Double.valueOf((String)configs.get(ECR_GUI_CONFIGS.COMISION_TVA_COTA.toString()));
                int codProdusComision = Integer.valueOf((String)configs.get(ECR_GUI_CONFIGS.COMISION_PRODUS_COD.toString()));
                String codDepartamentComision = (String)configs.get(ECR_GUI_CONFIGS.COMISION_PRODUS_CODDEPARTAMENT.toString());
                String numeProdusComision = (String)configs.get(ECR_GUI_CONFIGS.COMISION_PRODUS_NUME.toString());
                EcrSale comision = new EcrSale(numeProdusComision, 1.0, valoareComision, valoareComision, 0.0, codProdusComision, codDepartamentComision, 1, codTvaComision, cotaTvaComision);
                ecrSales.add(comision);
            }
            String codCasaCard = (String)configs.get(ECR_GUI_CONFIGS.CARD_CODCASA.toString());
            String numeCard = (String)configs.get(ECR_GUI_CONFIGS.CARD_NUME.toString());
            TipPlata card = new TipPlata(-1, numeCard, codCasaCard, false, -1, -1, false, false, true);
            EcrPlata plata = new EcrPlata();
            plata.setDefault(false);
            plata.setEcrMapping(codCasaCard);
            plata.setSuma(FloatUtils.roundDoubleUp(totalComanda, 2));
            plata.setTipPlata(card.getLabel());
            tipPlata2.add(plata);
            String orderIdentifier = (String)configs.get(ECR_GUI_CONFIGS.ORDER_IDENTIFIER.toString());
            if (orderIdentifier == null) {
                orderIdentifier = "";
            }
            this.ecr.printBonFiscal(ecrSales, totalComanda, tipPlata2, null, comments, orderIdentifier, -1);
            if (copie) {
                this.ecr.copieBon();
            }
            this.ecr.introduNumerar(-sumaCatreClient);
            if (copie) {
                // empty if block
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public double[] cashbackCompute(double sumaCatreClient, Map configs) {
        double[] result = new double[4];
        sumaCatreClient = FloatUtils.roundDoubleUp(sumaCatreClient, 2);
        double comisionProcent = Double.valueOf((String)configs.get(ECR_GUI_CONFIGS.COMISION_PROCENT.toString()));
        double valoareComision = comisionProcent * sumaCatreClient / 100.0;
        valoareComision = FloatUtils.roundDoubleUp(valoareComision, 2);
        double totalComanda = valoareComision + sumaCatreClient;
        result[0] = sumaCatreClient;
        result[1] = valoareComision;
        result[2] = totalComanda;
        result[3] = comisionProcent;
        return result;
    }

    public String getNextBonCUI() {
        return this.nextBonCUI;
    }

    public void setNextBonCUI(String nextBonCUI) {
        this.nextBonCUI = nextBonCUI;
    }

    public void setEcrType(EcrType ecrType) {
        this.ecrType = ecrType;
    }

    public void setSerieFiscala(String serieFiscala) {
        this.serieFiscala = serieFiscala;
    }

    public void setResponseInterface(BonValidatorResponseInterface responseInterface) {
        this.responseInterface = responseInterface;
    }

    public boolean checkBonLimitForTodayAndIncreaseUsage() {
        if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.bonLimit300Disabled)) {
            return true;
        }
        if (this.availableBonsForToday <= 0) {
            this.ecrUserFeedbackInterface.showTextToUser("In ziua calendaristica curenta nu mai puteti tipari bonuri fiscale. Achizitionati cel putin fiscalWireBasic.");
            return false;
        }
        --this.availableBonsForToday;
        this.ecrUserFeedbackInterface.showTextToUser("Mai puteti tipari " + this.availableBonsForToday + " bonuri fiscale in ziua calendaristica curenta.");
        return true;
    }

    public Date getEcrDate() {
        return this.ecrDate;
    }

    public void setDate(Date d) {
        if (this.ecrDate == null) {
            this.ecrDate = d;
            if (!EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.bonLimit300Disabled)) {
                Date now = new Date();
                long diffComputerCasa = Math.abs(now.getTime() - d.getTime());
                long allowedDrift = 10800000L;
                if (!this.serieFiscala.equals("000000") && diffComputerCasa > allowedDrift) {
                    System.out.println("diferenta intre casa si computer mai mare de 3 h, refuz sa pornesc driverul : " + DateUtils.getDiferentaIntreOre(d.getTime(), now.getTime()));
                    Utils.systemExit();
                }
                Date tomorrow00h = DateUtils.getStartOfDay(DateUtils.addDaysToDate(d, 1));
                long diff = tomorrow00h.getTime() - d.getTime();
                long _24hMillis = 57600000L;
                this.availableBonsForToday = (int)(300.0 / (double)_24hMillis * (double)diff);
                this.ecrUserFeedbackInterface.showTextToUser("Repornire driver la ora " + Formatters.TIME_FORMAT.format(now));
                this.ecrUserFeedbackInterface.showTextToUser("Calculez numarul de bonuri disponibile in ziua calendaristica curenta : " + this.availableBonsForToday);
            }
        } else if (!DateUtils.sameDay(d, this.ecrDate)) {
            this.ecrDate = d;
            this.availableBonsForToday = 300;
            System.out.println("Schimbare de data: " + d + " available bons " + this.availableBonsForToday);
            if (!EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.bonLimit300Disabled)) {
                this.ecrUserFeedbackInterface.showTextToUser("Noua zi calendaristica . Resetez numarul de bonuri la : " + this.availableBonsForToday);
            }
        }
    }

    public void setEcrUserFeedbackInterface(EcrUserFeedbackInterface ecrUserFeedbackInterface) {
        this.ecrUserFeedbackInterface = ecrUserFeedbackInterface;
    }

    public EcrType getEcrType() {
        return this.ecrType;
    }

    static {
        skipBons = 0;
    }

    public static enum ECR_GUI_CONFIGS {
        ELIBERARE_TVA_COD,
        ELIBERARE_TVA_COTA,
        ELIBERARE_PRODUS_NUME,
        ELIBERARE_PRODUS_COD,
        ELIBERARE_PRODUS_CODDEPARTAMENT,
        CARD_CODCASA,
        CARD_NUME,
        COMISION_PROCENT,
        ORDER_IDENTIFIER,
        COMISION_TVA_COD,
        COMISION_TVA_COTA,
        COMISION_PRODUS_NUME,
        COMISION_PRODUS_COD,
        COMISION_PRODUS_CODDEPARTAMENT,
        ECR_TYPE,
        ecrSpeed,
        ecrPort,
        ECR_MAX_DPT,
        hashedPassword,
        SERIAL_TYPE,
        NATIVE_DIR,
        NATIVE_CHARSET,
        NATIVE_EXTENSIONS,
        PREVALIDARE_TYPE;

    }
}

