/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import ro.atreides.ecr.EcrJob;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class EcrPrintingThread
extends Thread {
    private String exec;
    private String itemsFile;
    private String log;
    private String err;
    private File dir;
    protected Vector queue = new Vector();
    private FileWriter bonFiscalLog;
    private boolean bonNumbering;
    private int nrBon = 1;
    private String okAnswer;
    private String fileNameTemplate;

    public EcrPrintingThread(String directory, String exec, String itemsFile, String onlineLogFile, String onlineErrFile, boolean bonNumbering, String okAnswer, String fileNameTemplate) {
        this.dir = new File(directory);
        this.exec = exec;
        this.itemsFile = itemsFile;
        this.log = onlineLogFile;
        this.err = onlineErrFile;
        this.bonNumbering = bonNumbering;
        this.okAnswer = okAnswer;
        this.fileNameTemplate = fileNameTemplate;
        try {
            File dir = new File(directory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.bonFiscalLog = new FileWriter(directory + File.separator + "bf.log", true);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void addToQueue(String text) {
        this.queue.add(new EcrJob(text));
    }

    public void addToQueue(EcrJob job) {
        this.queue.add(job);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    try {
                        EcrPrintingThread.sleep(100L);
                    }
                    catch (InterruptedException in) {
                        // empty catch block
                    }
                    EcrJob job = null;
                    if (this.queue.size() == 0) continue;
                    job = (EcrJob)this.queue.remove(0);
                    String result = "";
                    File directory = new File(this.dir.getPath());
                    if (directory.exists()) {
                        if (!directory.isDirectory() && !directory.delete()) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "Stergeti fisierul " + directory.getAbsolutePath() + " si apoi incercati din nou", "Nu pot tipari bonul fiscal");
                        }
                    } else if (!directory.mkdirs()) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu am reusit crearea directorului " + directory.getAbsolutePath() + ". Verificati permisiile si apoi incercati din nou", "Nu pot tipari bonul fiscal");
                    }
                    String outFile = this.itemsFile;
                    if (this.bonNumbering) {
                        if (this.fileNameTemplate != null) {
                            String fileSystemFriendly = Utils.getStringMaxSize(5, this.nrBon + "", Character.valueOf('0'), true);
                            outFile = this.fileNameTemplate.replaceAll("%%nrbon%%", fileSystemFriendly);
                        } else {
                            outFile = this.nrBon + this.itemsFile;
                        }
                    }
                    File itemsFile = new File(directory.getAbsolutePath() + File.separator + outFile);
                    FileWriter writer = new FileWriter(itemsFile);
                    writer.write(job.getText());
                    writer.close();
                    if (Validators.correctString(this.exec)) {
                        String debugLine = "Execut \"" + this.exec + "\" din directorul \"" + this.dir.getAbsolutePath() + "\"";
                        Logger.logDebugVerbose(this, debugLine);
                        try {
                            Process onlineProcess = Runtime.getRuntime().exec(this.exec, null, this.dir);
                            int status = 0;
                            try {
                                status = onlineProcess.waitFor();
                            }
                            catch (InterruptedException e) {
                                Logger.logException(this, (Exception)e);
                            }
                            catch (Throwable th1) {
                                Logger.logError((Object)this, th1);
                            }
                            result = "Return status : " + status;
                            result = status == 0 ? result + " completed" : result + " Failed. See " + this.err + " for details.";
                        }
                        catch (IOException e) {
                            Logger.logException(this, (Exception)e);
                        }
                    }
                    Thread.sleep(4000L);
                    String logContent = "";
                    try {
                        logContent = FileUtils.readFileToString(directory.getAbsolutePath() + File.separator + this.log);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    String errContent = "";
                    try {
                        errContent = FileUtils.readFileToString(directory.getAbsolutePath() + File.separator + this.err);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.bonFiscalLog.write("** " + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date()) + "\n");
                    this.bonFiscalLog.write("..\n" + job.getText() + "\n");
                    this.bonFiscalLog.write("--\n" + logContent + "\n");
                    this.bonFiscalLog.write("==\n" + errContent + "\n");
                    this.bonFiscalLog.flush();
                    Logger.logDebugVerbose(this, "Printed : " + job.getText());
                    Logger.logDebugVerbose(this, "Answer : " + logContent);
                    Logger.logDebugVerbose(this, "Err : " + errContent);
                    ++this.nrBon;
                    if (this.okAnswer == null || logContent.contains(this.okAnswer) || errContent.contains(this.okAnswer)) continue;
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Answer : " + logContent + "\nErr: " + errContent, "Nu pot tipari bonul fiscal");
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                Logger.logError((Object)this, th);
                continue;
            }
            break;
        }
    }
}

