/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.atreides.ecr.EcrPaymentType;
import ro.atreides.ecr.SerialLibraryType;

public enum EcrType {
    Datecs_MP55("datecs.NewMP55", 9, false, false, SerialLibraryType.RxTx_ForceDTR, 9600, EcrPaymentType.MP55_CARD, true, false),
    Datecs_MP500T("datecs.NewMP55", 9, false, false, SerialLibraryType.RxTx_ForceDTR, 9600, EcrPaymentType.MP55_CARD, true, false),
    Datecs_MP5000("datecs.NewMP55", 9, false, false, SerialLibraryType.RxTx_ForceDTR, 9600, EcrPaymentType.MP55_CARD, true, false),
    Datecs_DP50_D("datecs.NewMP55", 4, true, true, SerialLibraryType.PureJava, 9600, EcrPaymentType.MP55B_CARD, true, false),
    Datecs_MP55_L_LD("datecs.NewMP55", 9, true, true, SerialLibraryType.PureJava, 9600, EcrPaymentType.MP55B_CARD, true, false),
    Datecs_MP55_B("datecs.NewMP55", 4, true, true, SerialLibraryType.PureJava, 9600, EcrPaymentType.MP55B_CARD, true, false),
    Datecs_DP25("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true),
    Datecs_DP45("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true),
    Datecs_DP05("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true),
    Datecs_MP55KL("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true);

    private static Map<EcrType, Map<Character, EcrPaymentType>> paymentTypes;
    private String driverClass;
    private int maxDepartments;
    private int preferredSpeed;
    private boolean supportsX;
    private boolean supportsZ;
    private boolean permitTotalIfPaidInFull;
    private boolean allowNegativePrice;
    private SerialLibraryType preferedSerialLibraryTypeWindows;
    private EcrPaymentType tipPlataCardEnum;

    private EcrType(String driverClass, int maxDepartments, boolean supportsX, boolean supportsZ, SerialLibraryType preferedSerialLibraryType, int preferredSpeed, EcrPaymentType tipPlataCardEnum, boolean permitTotalIfPaidInFull, boolean allowNegativePrice) {
        this.driverClass = driverClass;
        this.maxDepartments = maxDepartments;
        this.supportsX = supportsX;
        this.supportsZ = supportsZ;
        this.preferedSerialLibraryTypeWindows = preferedSerialLibraryType;
        this.preferredSpeed = preferredSpeed;
        this.tipPlataCardEnum = tipPlataCardEnum;
        this.permitTotalIfPaidInFull = permitTotalIfPaidInFull;
        this.allowNegativePrice = allowNegativePrice;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public int getMaxDepartments() {
        return this.maxDepartments;
    }

    public boolean isSupportsX() {
        return this.supportsX;
    }

    public boolean isSupportsZ() {
        return this.supportsZ;
    }

    public SerialLibraryType getPreferedSerialLibraryTypeWindows() {
        return this.preferedSerialLibraryTypeWindows;
    }

    public int getPreferredSpeed() {
        return this.preferredSpeed;
    }

    public EcrPaymentType getTipPlataCardEnum() {
        return this.tipPlataCardEnum;
    }

    public Map<Character, EcrPaymentType> getPayments() {
        return paymentTypes.get((Object)this);
    }

    public boolean isPermitTotalIfPaidInFull() {
        return this.permitTotalIfPaidInFull;
    }

    public boolean isAllowNegativePrice() {
        return this.allowNegativePrice;
    }

    static {
        paymentTypes = Collections.synchronizedMap(new LinkedHashMap());
        Hashtable<Character, EcrPaymentType> gen1Types = new Hashtable<Character, EcrPaymentType>();
        gen1Types.put(Character.valueOf(EcrPaymentType.MP55_CASH.getCode()), EcrPaymentType.MP55_CASH);
        gen1Types.put(Character.valueOf(EcrPaymentType.MP55_CARD.getCode()), EcrPaymentType.MP55_CARD);
        gen1Types.put(Character.valueOf(EcrPaymentType.MP55_TICKET.getCode()), EcrPaymentType.MP55_TICKET);
        gen1Types.put(Character.valueOf(EcrPaymentType.MP55_CEC.getCode()), EcrPaymentType.MP55_CEC);
        paymentTypes.put(Datecs_MP55, gen1Types);
        paymentTypes.put(Datecs_MP500T, gen1Types);
        paymentTypes.put(Datecs_MP5000, gen1Types);
        Hashtable<Character, EcrPaymentType> gen2Types = new Hashtable<Character, EcrPaymentType>();
        gen2Types.put(Character.valueOf(EcrPaymentType.MP55B_CASH.getCode()), EcrPaymentType.MP55B_CASH);
        gen2Types.put(Character.valueOf(EcrPaymentType.MP55B_CARD.getCode()), EcrPaymentType.MP55B_CARD);
        gen2Types.put(Character.valueOf(EcrPaymentType.MP55B_TICKET.getCode()), EcrPaymentType.MP55B_TICKET);
        paymentTypes.put(Datecs_DP50_D, gen2Types);
        paymentTypes.put(Datecs_MP55_L_LD, gen2Types);
        paymentTypes.put(Datecs_MP55_B, gen2Types);
        Hashtable<Character, EcrPaymentType> gen3Types = new Hashtable<Character, EcrPaymentType>();
        gen3Types.put(Character.valueOf(EcrPaymentType.DP25_CASH.getCode()), EcrPaymentType.DP25_CASH);
        gen3Types.put(Character.valueOf(EcrPaymentType.DP25_CARD.getCode()), EcrPaymentType.DP25_CARD);
        gen3Types.put(Character.valueOf(EcrPaymentType.DP25_CEC.getCode()), EcrPaymentType.DP25_CEC);
        gen3Types.put(Character.valueOf(EcrPaymentType.DP25_CREDIT.getCode()), EcrPaymentType.DP25_CREDIT);
        gen3Types.put(Character.valueOf(EcrPaymentType.DP25_TICHET.getCode()), EcrPaymentType.DP25_TICHET);
        gen3Types.put(Character.valueOf(EcrPaymentType.DP25_CUPON.getCode()), EcrPaymentType.DP25_CUPON);
        paymentTypes.put(Datecs_DP25, gen3Types);
        paymentTypes.put(Datecs_DP45, gen3Types);
        paymentTypes.put(Datecs_DP05, gen3Types);
        paymentTypes.put(Datecs_MP55KL, gen3Types);
    }
}

