/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.FileInputStream;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;

public class ScalaXmlImporter
extends DefaultHandler {
    private Properties configs;
    public static final String FIELD = "field";
    public static final String FIELD_VALUE = "valueTag";
    public static final String FIELD_TYPE = "typeField";
    public static final String PRODUCT_TAG = "productTag";
    public static final String DENUMIRE_FIELD = "denumireField";
    public static final String PPU_FIELD = "pretField";
    public static final String QTY_FIELD = "qtyField";
    public static final String TVA_FIELD = "tvaField";
    private Vector<EcrSale> sales = new Vector();
    private Vector<EcrPlata> plati = new Vector();
    private Vector<String> comments = new Vector();
    private String currentFieldType;
    private String currentValue;
    private String product;
    private Double qty;
    private Double price;
    private Double tva;
    private StringBuilder currentValueBuilder = null;

    public ScalaXmlImporter(Properties configs) {
        this.configs = configs;
    }

    @Override
    public void startDocument() throws SAXException {
        this.sales.clear();
        this.plati.clear();
        this.comments.clear();
    }

    @Override
    public void startElement(String uri, String qName, String localName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase(this.configs.getProperty(FIELD))) {
            String typeOfField;
            this.currentFieldType = typeOfField = attributes.getValue(this.configs.getProperty(FIELD_TYPE));
        }
        if (qName.equalsIgnoreCase(this.configs.getProperty(FIELD_VALUE))) {
            this.currentValueBuilder = new StringBuilder();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentValueBuilder != null) {
            this.currentValueBuilder.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase(this.configs.getProperty(FIELD_VALUE))) {
            this.currentValue = this.currentValueBuilder.toString().trim();
            this.currentValueBuilder = null;
        }
        if (qName.equalsIgnoreCase(this.configs.getProperty(PRODUCT_TAG))) {
            if (this.product == null) {
                return;
            }
            double cotaTva = (this.tva + this.price) / this.price;
            cotaTva = FloatUtils.roundDouble(cotaTva, 2);
            this.price = this.price + this.tva;
            EcrSale sale = new EcrSale(this.product, this.qty, this.price, this.price, 0.0, 1, "1", 1, "1", cotaTva);
            this.sales.add(sale);
            this.product = null;
            this.price = null;
            this.qty = null;
            this.tva = null;
        } else if (qName.equalsIgnoreCase(this.configs.getProperty(FIELD))) {
            if (this.currentFieldType.equalsIgnoreCase(this.configs.getProperty(DENUMIRE_FIELD))) {
                this.product = this.currentValue;
            }
            if (this.currentFieldType.equalsIgnoreCase(this.configs.getProperty(PPU_FIELD))) {
                this.price = Utils.parseDouble(this.currentValue);
            }
            if (this.currentFieldType.equalsIgnoreCase(this.configs.getProperty(QTY_FIELD))) {
                this.qty = Utils.parseDouble(this.currentValue);
            }
            if (this.currentFieldType.equalsIgnoreCase(this.configs.getProperty(TVA_FIELD))) {
                this.tva = Utils.parseDouble(this.currentValue);
            }
            this.currentFieldType = null;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public static final void main(String[] args) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream("conf/ecr/scala_ecr.properties"));
        ScalaXmlImporter handler = new ScalaXmlImporter(properties);
        Utils.importXml((DefaultHandler)handler, "factura.xml");
        Vector<EcrSale> sales = handler.getSales();
        System.out.println(sales);
    }

    public Vector<String> getComments() {
        return this.comments;
    }

    public Vector<EcrSale> getSales() {
        return this.sales;
    }

    public Vector<EcrPlata> getPlati() {
        return this.plati;
    }
}

