/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.util.Vector;
import ro.atreides.ecr.EcrClosedException;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.SerialDeviceDetector;
import ro.atreides.ecr.SerialDriverInterface;
import ro.atreides.ecr.SerialDriverInterfaceImpl;
import ro.atreides.ecr.SerialIOBuilder;
import ro.atreides.ecr.SerialPortInstance;
import ro.atreides.ecr.SerialReader;
import ro.atreides.ecr.SerialUtils;
import ro.atreides.ecr.SerialWriter;
import ro.atreides.utils.Logger;

public abstract class SerialDriver
implements SerialIOBuilder,
SerialDeviceDetector {
    private static final String DEFAULT_NAME = "Serial Driver Thread";
    private SerialDriverInterface driverInterface;
    private SerialPortInstance portInstance;
    private SerialWriter writer;
    private SerialReader reader;
    private String lastDetectedFile;
    private boolean running = true;
    private boolean started = false;
    protected boolean notifications;
    protected Vector filters = new Vector();

    public SerialDriver(String lastDetectedFile) {
        this.lastDetectedFile = lastDetectedFile == null ? "_last_detected_serial_driver_" : lastDetectedFile;
        this.driverInterface = new SerialDriverInterfaceImpl();
    }

    public Vector getFilters() {
        return this.filters;
    }

    public void setFilters(Vector filters) {
        this.filters = filters;
    }

    public void setNotifications(boolean notifications) {
        this.notifications = notifications;
    }

    public final String getLastDetectedFile() {
        return this.lastDetectedFile;
    }

    public final void setLastDetectedFile(String lastDetectedFile) {
        this.lastDetectedFile = lastDetectedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        if (this.started || !this.running) {
            return;
        }
        SerialDriver serialDriver = this;
        synchronized (serialDriver) {
            if (!this.isRunning()) {
                return;
            }
            this.started = true;
            this.running = true;
            Thread t = new Thread(){

                @Override
                public void run() {
                    boolean b = SerialDriver.this.detect(true);
                    EcrLogic.getInstance().ecrConnected(b);
                    if (b) {
                        SerialDriver.this.startDriver();
                    }
                }
            };
            String name = this.getDriverName();
            t.setName(name == null ? DEFAULT_NAME : name);
            t.start();
        }
    }

    public final synchronized void stop() {
        Logger.logVerbose(this, ">>>>>>>>>>>>>> STOPING ECR <<<<<<<<<<<<");
        this.running = false;
        if (this.portInstance != null) {
            this.portInstance.close();
        }
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void setDriverInterface(SerialDriverInterface e) {
        if (e != null) {
            this.driverInterface = e;
        }
    }

    public final SerialDriverInterface getDriverInterface() {
        return this.driverInterface;
    }

    public final boolean detect() {
        boolean b = this.detect(false);
        EcrLogic.getInstance().ecrConnected(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detect(boolean firstDetection) {
        if (this.portInstance != null) {
            this.portInstance.close();
        }
        if (!firstDetection) {
            Logger.logVerbose(this, "ECR INTERFACE: ecrRemoved()");
            int result = this.driverInterface.deviceRemoved(this.notifications);
            if (result != 0) {
                Logger.logVerbose(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            Logger.logVerbose(this, "ECR INTERFACE: user choose RETRY");
        }
        while (this.isRunning()) {
            int result;
            SerialPortInstance ecr;
            SerialDriver serialDriver = this;
            synchronized (serialDriver) {
                if (!this.isRunning()) {
                    return false;
                }
                ecr = SerialUtils.detect(this.buildSpeeds(), this.getLastDetectedFile(), (SerialIOBuilder)this, this, this.filters);
                if (ecr != null) {
                    this.updateEcrPortInstance(ecr);
                    return true;
                }
            }
            SerialUtils.sleep(500L);
            if (!this.isRunning()) {
                return false;
            }
            if (ecr != null) continue;
            Logger.logVerbose(this, "ECR INTERFACE: ecrRemoved()");
            int n = result = firstDetection ? this.driverInterface.deviceNotPresent(this.notifications) : this.driverInterface.deviceRemoved(this.notifications);
            if (result != 0) {
                Logger.logVerbose(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            if (result != 0) continue;
            Logger.logVerbose(this, "ECR INTERFACE: user choose RETRY");
        }
        return false;
    }

    private void updateEcrPortInstance(SerialPortInstance ecr) {
        this.portInstance = ecr;
        this.writer = this.portInstance.getWriter();
        this.reader = this.portInstance.getReader();
    }

    protected void write(byte[] data) throws EcrClosedException {
        boolean detected;
        if (!this.writer.writetoport(data) && !(detected = this.detect())) {
            throw new EcrClosedException();
        }
    }

    protected final Object read(int timeout) throws EcrClosedException {
        Object result;
        block2: {
            result = null;
            try {
                result = this.reader.read(timeout);
            }
            catch (IOException e) {
                boolean detected = this.detect();
                if (detected) break block2;
                throw new EcrClosedException();
            }
        }
        return result;
    }

    protected final void clearReader() {
        this.reader.clearReader();
    }

    public String getDriverName() {
        return DEFAULT_NAME;
    }

    protected abstract void startDriver();

    protected abstract Integer[] buildSpeeds();
}

