/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;
import purejavacomm.SerialPort;
import ro.atreides.ecr.SerialIOBuilder;
import ro.atreides.ecr.SerialReader;
import ro.atreides.ecr.SerialSettings;
import ro.atreides.ecr.SerialUtils;
import ro.atreides.ecr.SerialWriter;

public final class SerialPortInstance {
    private SerialSettings settings;
    private InputStream input;
    private OutputStream output;
    private SerialPort serialPort;
    private SerialWriter writer;
    private SerialReader reader;

    public SerialPortInstance(InputStream in, OutputStream out, SerialPort port, SerialSettings settings, SerialIOBuilder ioBuilder) {
        if (in == null || out == null || port == null || settings == null) {
            throw new NullPointerException();
        }
        this.input = in;
        this.output = out;
        this.serialPort = port;
        this.settings = settings;
        if (ioBuilder != null) {
            this.writer = ioBuilder.buildWriter(port, out);
            this.reader = ioBuilder.buildReader(port, in);
        }
    }

    public SerialWriter getWriter() {
        return this.writer;
    }

    public SerialReader getReader() {
        return this.reader;
    }

    public String getPort() {
        return this.settings.getName();
    }

    public int getSpeed() {
        return this.settings.getSpeed();
    }

    public InputStream getInput() {
        return this.input;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public synchronized void close() {
        ReentrantLock readLock = null;
        if (this.reader != null) {
            this.reader.close();
            readLock = this.reader.getLock();
            this.reader = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        SerialUtils.closeAll(this.input, this.output, this.serialPort, readLock);
        this.input = null;
        this.output = null;
        this.serialPort = null;
    }
}

