/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.ConfigUtils;
import ro.atreides.ecr.SerialConnectInfo;
import ro.atreides.ecr.SerialDeviceDetector;
import ro.atreides.ecr.SerialIOBuilder;
import ro.atreides.ecr.SerialPortInstance;
import ro.atreides.ecr.SerialSettings;
import ro.atreides.utils.Logger;

public class SerialUtils {
    private static final ReentrantLock detectLock = new ReentrantLock(true);

    public static Vector<String> getPorts() {
        TreeSet<String> treeset = new TreeSet<String>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        System.out.println("portList : " + portList);
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            System.out.println("port : name " + portId.getName() + " owner " + portId.getCurrentOwner() + " portType " + portId.getPortType() + " owned " + portId.isCurrentlyOwned());
            if (portId.getPortType() != 1) continue;
            System.out.println("port : name " + portId.getName() + " isSerial !");
            treeset.add(portId.getName());
        }
        return new Vector<String>(treeset);
    }

    public static SerialPortInstance initPort(SerialSettings serialSettings) {
        return SerialUtils.initPort(serialSettings, null);
    }

    public static SerialPortInstance initPort(SerialSettings serialSettings, SerialIOBuilder ioBuilder) {
        if (serialSettings == null) {
            return null;
        }
        Logger.logVerbose(SerialUtils.getClassName(), ">>>>>>>>>>>>>>>>>>> INITIALIZARE: port=" + serialSettings.getName() + " speed=" + serialSettings.getSpeed() + " <<<<<<<<<<<<<<<<<<");
        InputStream input = null;
        OutputStream output = null;
        SerialPort serialPort = null;
        try {
            String portName = serialSettings.getName();
            if (portName == null) {
                Logger.logWarning(SerialUtils.getClassName(), ">>>>> nume port = null");
                throw new NullPointerException();
            }
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != serialSettings.getPortType() || !portId.getName().equals(portName)) continue;
                Logger.logInfo(SerialUtils.getClassName(), ">>>>> Opening port: " + portName + "");
                serialPort = (SerialPort)portId.open("CasaDeMarkatReader", 2000);
                serialPort.setRTS(serialSettings.isRTS());
                input = serialPort.getInputStream();
                output = serialPort.getOutputStream();
                serialPort.setSerialPortParams(serialSettings.getSpeed(), serialSettings.getDataBits(), serialSettings.getStopBits(), serialSettings.getPariry());
                Logger.logInfo(SerialUtils.getClassName(), ">>>>> Initializare port corecta");
                return new SerialPortInstance(input, output, serialPort, serialSettings, ioBuilder);
            }
            Logger.logWarning(SerialUtils.getClassName(), "port indisponibil");
            throw new NoSuchPortException();
        }
        catch (Exception e) {
            SerialUtils.closeAll(input, output, serialPort);
            Logger.logWarning(SerialUtils.getClassName(), ">>>>> Eroare de initializare port, portul se va inchide");
            Logger.logWarning(SerialUtils.getClassName(), e.toString());
            return null;
        }
    }

    private static String getClassName() {
        return SerialUtils.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll(InputStream input, OutputStream output, SerialPort serialPort, ReentrantLock readLock) {
        block12: {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Throwable e) {
                Logger.logWarning(SerialUtils.getClassName(), e.toString());
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Throwable e) {
                Logger.logWarning(SerialUtils.getClassName(), e.toString());
            }
            try {
                if (serialPort == null) break block12;
                if (readLock != null) {
                    readLock.lock();
                    try {
                        serialPort.close();
                        break block12;
                    }
                    finally {
                        readLock.unlock();
                    }
                }
                serialPort.close();
            }
            catch (Throwable e) {
                Logger.logWarning(SerialUtils.getClassName(), e.toString());
            }
        }
    }

    public static void closeAll(InputStream input, OutputStream output, SerialPort serialPort) {
        SerialUtils.closeAll(input, output, serialPort, null);
    }

    public static Vector<SerialConnectInfo> getSerialConnectInfos(Integer[] speeds, String lastDetectedfile, Vector filters) {
        Vector<SerialConnectInfo> result1 = new Vector<SerialConnectInfo>();
        SerialConnectInfo lastDetected = SerialUtils.getLastDetected(lastDetectedfile);
        if (lastDetected != null) {
            result1.add(lastDetected);
        }
        Vector result2 = SerialUtils.getAllSerialConnectInfos(speeds, filters, lastDetected);
        result1.addAll(result2);
        return result1;
    }

    private static Vector getAllSerialConnectInfos(Integer[] speeds, Vector filters, SerialConnectInfo toSkip) {
        Vector<SerialConnectInfo> result = new Vector<SerialConnectInfo>();
        Vector<String> ports = SerialUtils.getPorts();
        for (int i = 0; i < ports.size(); ++i) {
            int j;
            String port = ports.get(i);
            boolean ok = false;
            for (j = 0; j < filters.size() && !ok; ++j) {
                String s = (String)filters.elementAt(j);
                if (!port.matches(s)) continue;
                ok = true;
            }
            if (!ok) continue;
            for (j = 0; j < speeds.length; ++j) {
                int speed = speeds[j];
                SerialConnectInfo toAdd = new SerialConnectInfo(port, speed);
                if (toSkip != null && toAdd.equals(toSkip)) continue;
                result.add(toAdd);
            }
        }
        return result;
    }

    public static SerialConnectInfo getLastDetected(String LAST_DETECTED_ECR_FILE) {
        SerialConnectInfo result = null;
        Object o = ConfigUtils.readObjectFrom(LAST_DETECTED_ECR_FILE);
        if (o instanceof SerialConnectInfo) {
            result = (SerialConnectInfo)o;
        }
        return result;
    }

    public static void setLastDetected(SerialConnectInfo pp, String LAST_DETECTED_ECR_FILE) {
        if (pp == null) {
            pp = new SerialConnectInfo("empty_port", 0);
        }
        ConfigUtils.writeObjectTo(pp, LAST_DETECTED_ECR_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialPortInstance detect(Integer[] speeds, String lastDetectedFile, SerialIOBuilder ioBuilder, SerialDeviceDetector deviceDetector, Vector portFilters) {
        detectLock.lock();
        try {
            Vector<SerialConnectInfo> pps = SerialUtils.getSerialConnectInfos(speeds, lastDetectedFile, portFilters);
            for (int i = 0; i < pps.size(); ++i) {
                SerialConnectInfo info = pps.get(i);
                Logger.logVerbose(SerialUtils.getClassName(), "trying to detect on: " + info);
                SerialPortInstance ecr = SerialUtils.detect(info, ioBuilder, lastDetectedFile, deviceDetector);
                if (ecr == null) continue;
                SerialPortInstance serialPortInstance = ecr;
                return serialPortInstance;
            }
            SerialPortInstance serialPortInstance = null;
            return serialPortInstance;
        }
        finally {
            detectLock.unlock();
        }
    }

    public static SerialPortInstance detect(SerialConnectInfo pp, SerialIOBuilder ioBuilder, String LAST_DETECTED_ECR_FILE, SerialDeviceDetector deviceDetector) {
        return SerialUtils.detect(pp.getName(), pp.getSpeed(), ioBuilder, LAST_DETECTED_ECR_FILE, deviceDetector);
    }

    public static SerialPortInstance detect(String port, int speed, SerialIOBuilder ioBuilder, String LAST_DETECTED_ECR_FILE, SerialDeviceDetector deviceDetector) {
        SerialSettings settings = new SerialSettings();
        settings.setName(port);
        settings.setSpeed(speed);
        return SerialUtils.detect(settings, ioBuilder, LAST_DETECTED_ECR_FILE, deviceDetector);
    }

    public static SerialPortInstance detect(SerialSettings settings, SerialIOBuilder ioBuilder, String LAST_DETECTED_ECR_FILE, SerialDeviceDetector deviceDetector) {
        SerialPortInstance ecr = null;
        try {
            ecr = SerialUtils.initPort(settings, ioBuilder);
            if (ecr != null) {
                Logger.logVerbose(SerialUtils.getClassName(), ">>>>>>>>>>>>>>>>>>>>> DETECTARE CASA: port=" + settings.getName() + " speed=" + settings.getSpeed() + " <<<<<<<<<<<<<<<<<<<");
                boolean detected = deviceDetector.detectDevice(ecr.getReader(), ecr.getWriter());
                if (detected) {
                    SerialUtils.setLastDetected(new SerialConnectInfo(ecr.getPort(), ecr.getSpeed()), LAST_DETECTED_ECR_FILE);
                    Logger.logVerbose(SerialUtils.getClassName(), ">>>>> casa a fost detectata!");
                    return ecr;
                }
                Logger.logVerbose(SerialUtils.getClassName(), ">>>>> casa NU a fost detectata!");
                ecr.close();
            }
        }
        catch (Exception e) {
            if (ecr != null) {
                ecr.close();
            }
            Logger.logWarning(SerialUtils.getClassName(), e.toString());
        }
        return null;
    }

    public static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

