/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.aclas.noarch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.ecr.aclas.noarch.AclasPersistentList;
import ro.atreides.ecr.aclas.noarch.AclasUtils;
import ro.atreides.ecr.aclas.noarch.Bon;
import ro.atreides.ecr.aclas.noarch.messages.AClasMessageResponse;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessage;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageAllVoid;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageCheckHardware;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageCheckSoftware;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageClerkLogin;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageOpenDrawer;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessagePayment;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageResponseCheckHardware;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageResponseCheckSoftware;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageResponseTotalDue;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageTotalDue;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;

public abstract class AclasImpl
extends Thread {
    protected InputStream inS;
    protected OutputStream outS;
    protected String portName;
    private int sequence = 0;
    private Hashtable<Integer, AclasMessage> sentMessages = new Hashtable();
    public static final String driverName = "aclas";
    protected boolean mustRun = true;
    protected AclasPersistentList outQueue;
    private boolean connected;

    protected AclasImpl(String port) {
        this.portName = port;
        this.outQueue = this.getPersistentList();
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void addBon(Bon b) {
        this.outQueue.addBon(b);
    }

    public void setMustRun(boolean mustRun) {
        this.mustRun = mustRun;
        this.connected = false;
    }

    private int getNextSeq() {
        ++this.sequence;
        if (this.sequence > 99) {
            this.sequence = 1;
        }
        return this.sequence;
    }

    protected abstract AclasPersistentList getPersistentList();

    protected abstract boolean connectSerial() throws IOException;

    protected abstract boolean connectTCP();

    protected abstract void closeSerialPort();

    protected abstract void closeSocket();

    protected abstract void logException(Exception var1);

    protected abstract void logError(AclasImpl var1, Object var2);

    protected abstract void ecrConnected(boolean var1);

    protected abstract void errorDialog(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (AclasUtils.correctString(this.portName)) {
            while (this.mustRun) {
                try {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.portName.startsWith("tcp") ? !this.connectTCP() : !this.connectSerial()) continue;
                    this.tryToConnect();
                    try {
                        Thread.sleep(4500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    this.logException(e);
                }
                catch (Throwable th) {
                    this.logError(this, th);
                }
                finally {
                    this.closeSocket();
                    this.closeSerialPort();
                }
            }
        } else {
            this.errorDialog("aclas: port nedefinit. Corectati si reporniti !!", "Nu pot continua!");
        }
    }

    private void tryToConnect() throws IOException {
        int maxRetriesForConnect = 3;
        this.connected = false;
        while (maxRetriesForConnect > 0 && !this.connected && this.mustRun) {
            AclasMessageCheckHardware checkH = new AclasMessageCheckHardware();
            checkH.setPacketNo(this.getNextSeq());
            this.sentMessages.put(checkH.getPacketNo(), checkH);
            AClasMessageResponse checkHResp = null;
            try {
                checkHResp = this.write(checkH, this.outS, this.inS);
            }
            catch (IOException e) {
                this.logException(e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.logException(e);
            }
            if (checkHResp == null || checkHResp.isError()) {
                this.ecrConnected(false);
                this.emptyInputBuffer(15000L);
                --maxRetriesForConnect;
                continue;
            }
            this.connected = true;
        }
        if (!this.connected) {
            this.errorDialog("Casa de marcat nefunctionala!!", "1. Verificati hartia, 2. restart program, 3. efectuati Z, 4. Contactati suportul tehnic!!!");
            return;
        }
        this.ecrConnected(true);
        this.sendBonIfAny();
    }

    private boolean tryLogin() {
        AclasMessageClerkLogin loginQuery = new AclasMessageClerkLogin();
        loginQuery.setPacketNo(this.getNextSeq());
        this.sentMessages.put(loginQuery.getPacketNo(), loginQuery);
        AClasMessageResponse loginResp = null;
        try {
            loginResp = this.write(loginQuery, this.outS, this.inS);
        }
        catch (IOException e) {
            this.logException(e);
        }
        if (loginResp != null) {
            if (loginResp.isError()) {
                System.out.println("eroare la login !");
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean voidPrevious() {
        AclasMessageAllVoid allVoid = new AclasMessageAllVoid();
        allVoid.setPacketNo(this.getNextSeq());
        this.sentMessages.put(allVoid.getPacketNo(), allVoid);
        AClasMessageResponse allVoidResp = null;
        try {
            allVoidResp = this.write(allVoid, this.outS, this.inS);
        }
        catch (IOException e) {
            this.logException(e);
        }
        return allVoidResp != null && !allVoidResp.isError();
    }

    private AclasMessageResponseCheckSoftware checkSoftwareStatus() {
        AclasMessageCheckSoftware checkS = new AclasMessageCheckSoftware();
        checkS.setPacketNo(this.getNextSeq());
        this.sentMessages.put(checkS.getPacketNo(), checkS);
        AclasMessageResponseCheckSoftware checkSResp = null;
        try {
            checkSResp = (AclasMessageResponseCheckSoftware)this.write(checkS, this.outS, this.inS);
        }
        catch (IOException e) {
            this.logException(e);
            e.printStackTrace();
        }
        return checkSResp;
    }

    private SendProductStatus sendProduct(AclasMessage query) {
        AClasMessageResponse result = this.sendProductWithResponse(query);
        if (result == null) {
            return SendProductStatus.TIMEOUT;
        }
        if (result.isError()) {
            return SendProductStatus.ERROR;
        }
        return SendProductStatus.OK;
    }

    private AClasMessageResponse sendProductWithResponse(AclasMessage query) {
        query.setPacketNo(this.getNextSeq());
        this.sentMessages.put(query.getPacketNo(), query);
        AClasMessageResponse result = null;
        try {
            AClasMessageResponse resp;
            result = resp = this.write(query, this.outS, this.inS);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logException(e);
        }
        return result;
    }

    private void sendBonIfAny() {
        int maxErrorCountForProduct = 3;
        while (this.mustRun && this.connected) {
            if (this.outQueue.size() > 0) {
                String x;
                boolean loginOK;
                Bon bon = this.outQueue.get();
                this.sentMessages.clear();
                AclasMessageResponseCheckSoftware checkSoftware = this.checkSoftwareStatus();
                if (checkSoftware == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    return;
                }
                if (checkSoftware.isReceiptOpen()) {
                    this.voidPrevious();
                    String x2 = "anulat bon nefinalizat INAINTE";
                    System.out.println(x2);
                    Logger.logInfo(this, x2);
                }
                if (!(loginOK = this.tryLogin())) {
                    return;
                }
                boolean bonAnulat = false;
                Vector products = bon.get();
                for (AclasMessage query : products) {
                    SendProductStatus status = this.sendProduct(query);
                    if (!status.equals((Object)SendProductStatus.OK)) {
                        bon.increaseErrorCount();
                        this.errorDialog("Produs Netiparit : '" + query.toString() + "' pe casa fiscala. ", "Atentie");
                        this.errorDialog("INTREGUL BON fiscal a fost anulat !!", "Atentie");
                        bonAnulat = true;
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!bonAnulat) {
                    System.out.println("VERIFICARE DUPA PRODUSE");
                    AclasMessageTotalDue totalDue = new AclasMessageTotalDue();
                    AClasMessageResponse response = this.sendProductWithResponse(totalDue);
                    AclasMessageResponseTotalDue responseTotalDue = (AclasMessageResponseTotalDue)response;
                    if (responseTotalDue != null) {
                        Double totalDePlata = responseTotalDue.getDeplata();
                        if (totalDePlata == null) {
                            Logger.logWarning(this, "TotaldePlata is NULL !!!");
                        } else {
                            Logger.logInfo(this, "total de plata " + totalDePlata);
                            double totalPlatit = 0.0;
                            Vector<AclasMessagePayment> payments = bon.getPayment();
                            for (AclasMessagePayment payment : payments) {
                                SendProductStatus status = this.sendProduct(payment);
                                totalPlatit += payment.getSuma();
                                String message = "PAYMENT STATUS : " + status.toString();
                                Logger.logDebug(this, message);
                                System.out.println(message);
                            }
                            double diff = totalDePlata - totalPlatit;
                            if (Utils.isValueGreaterThanZero(diff)) {
                                Logger.logInfo(this, "FORCE TOTAL : " + diff);
                                AclasMessagePayment payment = new AclasMessagePayment(bon.getCashDefault().getEcrMapping(), diff);
                                SendProductStatus status = this.sendProduct(payment);
                                String message = "FORCE TOTAL STATUS : " + status.toString();
                                Logger.logDebug(this, message);
                                System.out.println(message);
                            }
                        }
                    } else {
                        Logger.logWarning(this, "responseTotalDue is NULL !!!");
                    }
                }
                System.out.println("VERIFICARE DUPA PAYMENTS");
                boolean removeFromQueue = false;
                checkSoftware = this.checkSoftwareStatus();
                if (checkSoftware == null || checkSoftware.isReceiptOpen() || bonAnulat) {
                    boolean voidOK = this.voidPrevious();
                    x = "Anulare bon nefinalizat DUPA";
                    System.out.println(x);
                    Logger.logError((Object)this, x);
                    bon.increaseErrorCount();
                } else {
                    if (checkSoftware != null) {
                        int idBon = Integer.parseInt(checkSoftware.getNrBonFiscalCurent());
                        x = "IDBON : " + idBon;
                        System.out.println(x);
                        Logger.logInfo(this, x);
                        removeFromQueue = true;
                    }
                    this.sendProduct(new AclasMessageOpenDrawer());
                }
                if (removeFromQueue) {
                    this.outQueue.remove(bon);
                    return;
                }
                if (bon.getErrorCount() < maxErrorCountForProduct) continue;
                String x3 = "ERROR COUNT " + maxErrorCountForProduct + " reached. DO NOT RETRY BON !!";
                System.out.println(x3);
                Logger.logError((Object)this, x3);
                this.outQueue.remove(bon);
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private AClasMessageResponse write(AclasMessage toWrite, OutputStream outS, InputStream inS) throws IOException {
        byte[] stream = toWrite.getBytes();
        System.out.println(Formatters.FULL_TIMESTAMP.format(new Date()) + " Class: " + toWrite.getClass().getName() + " LogDetails : " + toWrite.getLogDetails() + "||");
        System.out.println(Formatters.FULL_TIMESTAMP.format(new Date()) + " HexString: " + TextUtils.getHexString(stream, true) + "||");
        System.out.flush();
        outS.write(stream);
        outS.flush();
        AClasMessageResponse mess = this.getReponse(inS, 15000L);
        return mess;
    }

    private void emptyInputBuffer(long readTimeout) throws IOException {
        int toRead = 0;
        long start = System.currentTimeMillis();
        while (toRead > 0 && System.currentTimeMillis() < start + readTimeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.inS.read();
            toRead = this.inS.available();
        }
    }

    private AClasMessageResponse getReponse(InputStream inS, long readTimeout) throws IOException {
        long start = System.currentTimeMillis();
        int toRead = 0;
        while (toRead <= 0 && System.currentTimeMillis() < start + readTimeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            toRead = inS.available();
        }
        if (toRead <= 0) {
            String th = "Read Timeout expired " + readTimeout + " millis ";
            System.out.println(th);
            this.logError(this, th);
            new Exception().printStackTrace();
            return null;
        }
        int ch = 0;
        while (ch != 192 && toRead > 0) {
            ch = inS.read();
            toRead = inS.available();
        }
        int i = 0;
        boolean packetfound = false;
        byte[] buffer = new byte[65535];
        if (ch == 192) {
            buffer[0] = (byte)ch;
            ch = 0;
            long endOfPacketTimeout = 10L * readTimeout;
            start = System.currentTimeMillis();
            ++i;
            while (System.currentTimeMillis() < start + endOfPacketTimeout) {
                toRead = inS.available();
                if (toRead > 0) {
                    ch = inS.read();
                    buffer[i] = (byte)ch;
                    ++i;
                    if (ch != 192) continue;
                    packetfound = true;
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        byte[] buffer2 = new byte[i];
        System.arraycopy(buffer, 0, buffer2, 0, buffer2.length);
        System.out.println(Formatters.FULL_TIMESTAMP.format(new Date()) + " Read: " + TextUtils.getHexString(buffer2, true) + "||");
        System.out.flush();
        byte responseSequence = buffer2[1];
        AclasMessage originalMessage = this.sentMessages.get(responseSequence);
        if (originalMessage == null) {
            this.logError(this, "Message not found for sequence : " + responseSequence);
            new Exception().printStackTrace();
            return null;
        }
        if (responseSequence != originalMessage.getPacketNo()) {
            this.logError(this, "Secventa gresita : Original message seqence : " + originalMessage.getPacketNo() + " responseSequence : " + responseSequence);
            return null;
        }
        if (originalMessage != null) {
            if (originalMessage instanceof AclasMessageCheckHardware) {
                return new AclasMessageResponseCheckHardware(buffer2);
            }
            if (originalMessage instanceof AclasMessageCheckSoftware) {
                return new AclasMessageResponseCheckSoftware(buffer2);
            }
            if (originalMessage instanceof AclasMessageTotalDue) {
                return new AclasMessageResponseTotalDue(buffer2);
            }
        }
        return new AClasMessageResponse(buffer2);
    }

    public final int getNoOfBonsToPrint() {
        return this.outQueue.size();
    }

    private static enum SendProductStatus {
        OK,
        TIMEOUT,
        ERROR;

    }
}

