/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.aclas.noarch;

import java.io.File;
import java.util.Vector;
import ro.atreides.ecr.aclas.noarch.Bon;

public abstract class AclasPersistentList {
    public String PERSISTENT_FILE;
    private Vector<Bon> products;

    public AclasPersistentList() {
        this(0);
    }

    public AclasPersistentList(int id) {
        this.PERSISTENT_FILE = "_ecr_aclas_persistent_products_list_" + id;
        if (!new File(this.PERSISTENT_FILE).exists()) {
            this.products = new Vector();
            this.setProductsFor(this.products, this.PERSISTENT_FILE);
        } else {
            this.products = this.getProductsFor(this.PERSISTENT_FILE);
        }
    }

    public synchronized void addBon(Bon bon) {
        if (bon != null) {
            this.products.add(bon);
            this.setProductsFor(this.products, this.PERSISTENT_FILE);
        }
    }

    public synchronized void remove(Bon bon) {
        this.products.remove(bon);
        this.setProductsFor(this.products, this.PERSISTENT_FILE);
    }

    public synchronized Bon get() {
        return this.products.get(0);
    }

    public synchronized int size() {
        return this.products.size();
    }

    public synchronized void clear() {
        this.products.clear();
        this.setProductsFor(this.products, this.PERSISTENT_FILE);
    }

    protected abstract Vector<Bon> getProductsFor(String var1);

    protected abstract void setProductsFor(Vector<Bon> var1, String var2);
}

