/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.activa;

import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "KARAT\n";
        for (EcrSale ecrSale : sales) {
            double nrPortii = ecrSale.getQuantity();
            double ppu = ecrSale.getPpuDupaDiscount();
            String priceString = EcrUtils.getPrice(8, this.onlineDecimalPlaces, ppu);
            String prodName = this.getString(16, ecrSale.getProduct()).toUpperCase();
            String portiiString = EcrUtils.getPrice(9, 3, nrPortii);
            String commandText = "*" + prodName + "        " + priceString + this.onlineDecimalPlaces + portiiString + ecrSale.getCodTva();
            String dep = "" + ecrSale.getDepartament();
            commandText = !Validators.correctString(dep) ? commandText + "00" : commandText + dep + "0";
            items = items + commandText;
            items = items + "\n";
        }
        if (plati == null || plati.size() == 0) {
            items = items + "T0000010000ABCDEF\n";
        } else {
            double totalPlatit = 0.0;
            for (EcrPlata plata : plati) {
                items = items + "T";
                int number = (int)(plata.getSuma() * 1000.0);
                String value = Utils.getStringMaxSize(9, "" + number, Character.valueOf('0'), true);
                items = items + value;
                items = items + plata.getEcrMapping();
                items = items + Utils.getStringMaxSize(6, plata.getTipPlata().toUpperCase(), Character.valueOf(' '), false);
                items = items + "\n";
                totalPlatit += plata.getSuma();
            }
            if (totalPlatit < total) {
                items = items + "T0000010000ABCDEF\n";
            }
        }
        items = items + "END KARAT\n";
        this.pt.addToQueue(items);
    }

    private String getString(int totalDigits, String toConvert) {
        if (toConvert.length() > totalDigits) {
            return toConvert.substring(0, totalDigits);
        }
        if (toConvert.length() < totalDigits) {
            String result = toConvert;
            for (int i = toConvert.length(); i < totalDigits; ++i) {
                result = result + " ";
            }
            return result;
        }
        return toConvert;
    }

    @Override
    public void forceTotal() {
    }
}

