/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.carat;

import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private String endOfLine = "\r\n";

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "7000" + this.endOfLine;
        for (EcrSale sale : sales) {
            String produs = Utils.getStringMaxSize(22, sale.getProduct(), Character.valueOf(' '), false);
            String line = "vanzaredupatext#" + produs + "#" + Utils.getString2DecimalsNoTrunc(sale.getPpuDupaDiscount()) + "#" + Utils.getString2DecimalsNoTrunc(sale.getQuantity()) + "#" + sale.getCodTva() + this.endOfLine;
            items = items + line;
        }
        if (plati == null || plati.size() == 0) {
            items = items + "plata#" + cashDefault.getEcrMapping() + "#" + Utils.getString2DecimalsNoTrunc(total) + this.endOfLine;
        } else {
            double platit = 0.0;
            for (EcrPlata plata : plati) {
                if (plata.equals(cashDefault)) continue;
                items = items + "plata#" + plata.getEcrMapping() + "#" + Utils.getString2DecimalsNoTrunc(plata.getSuma()) + this.endOfLine;
                platit += plata.getSuma();
            }
            double diff = total - platit;
            if (Utils.isValueGreaterThanZero(diff)) {
                items = items + "plata#" + cashDefault.getEcrMapping() + "#" + Utils.getString2DecimalsNoTrunc(diff) + this.endOfLine;
            }
        }
        items = items + "inchidebon" + this.endOfLine;
        items = items + "deschidesertar" + this.endOfLine;
        this.pt.addToQueue(items);
    }

    @Override
    public boolean multiplePaymentTypesSupported() {
        return true;
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void introduNumerar(double suma) {
        if (Utils.isValueZero(suma)) {
            return;
        }
        String items = "7000" + this.endOfLine;
        items = suma > 0.0 ? items + "IntroducereServiciu#0#" + Utils.getString2DecimalsNoTrunc(suma) + this.endOfLine : items + "ScoatereServiciu#0#" + Utils.getString2DecimalsNoTrunc(-suma) + this.endOfLine;
        this.pt.addToQueue(items);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }
}

