/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.chd;

import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private boolean forceTotal;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.forceTotal = Boolean.parseBoolean(conf.getProperty("forceTotal", "false"));
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String file = "";
        for (EcrSale ecrSale : sales) {
            String p = Utils.getStringMaxSize(18, ecrSale.getProduct(), null, false);
            String line = "SALE: DEPTNR = " + ecrSale.getDepartament() + ";" + " PRICE = " + Utils.getString2Decimals(ecrSale.getPpuDupaDiscount()) + ";" + " QNTY = " + Utils.getString3Decimals(ecrSale.getQuantity()) + ";" + " NAME = \"" + p + "\"\r\n";
            file = file + line;
        }
        if (plati == null || plati.size() == 0) {
            file = file + "TENDER\r\n";
        } else {
            for (EcrPlata plata : plati) {
                file = file + "TENDER: NAME = " + plata.getEcrMapping() + "; AMOUNT = " + Utils.getString2DecimalsNoTrunc(plata.getSuma()) + "\r\n";
            }
            if (this.forceTotal) {
                file = file + "TENDER\r\n";
            }
        }
        this.pt.addToQueue(file);
    }

    @Override
    public void forceTotal() {
    }
}

