/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs;

import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.Validators;

public class CasaDeMarkatXmlHandler
extends DefaultHandler {
    private StringBuffer buffer = new StringBuffer();
    private Hashtable paymentTypes;
    private int maxGrp;
    private int minGrp;
    private String idBon;
    private int idOrder;

    public void setMaxGrp(int maxGrp) {
        this.maxGrp = maxGrp;
    }

    public void setMinGrp(int minGrp) {
        this.minGrp = minGrp;
    }

    public void setPaymentTypes(Hashtable paymentTypes) {
        this.paymentTypes = paymentTypes;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("product")) {
            this.buffer.append("S,1,______,_,__;");
            this.buffer.append(attributes.getValue("label"));
            this.buffer.append(";");
            this.buffer.append(attributes.getValue("price"));
            this.buffer.append(";");
            this.buffer.append(attributes.getValue("quantity"));
            this.buffer.append(";");
            this.buffer.append(attributes.getValue("department"));
            this.buffer.append(";");
            String s1 = attributes.getValue("group");
            if (Validators.correctInteger(s1)) {
                int grp = Integer.parseInt(s1);
                grp = AbstractCashRegister.getRightNumber(grp, this.minGrp, this.maxGrp);
                s1 = grp + "";
            }
            this.buffer.append(s1);
            this.buffer.append(";");
            this.buffer.append(attributes.getValue("vat"));
            this.buffer.append(";0;0;\n");
        } else if (qName.equalsIgnoreCase("ad")) {
            this.buffer.append("P,1,______,_,__;");
            String text = attributes.getValue("text");
            if (!Validators.correctString(text)) {
                text = " ";
            }
            this.buffer.append(text);
            this.buffer.append(";;;;;\n");
        } else if (qName.equalsIgnoreCase("discount")) {
            this.buffer.append("C,1,______,_,__;1;");
            this.buffer.append(attributes.getValue("percent"));
            this.buffer.append(";;;;\n");
        } else if (qName.equalsIgnoreCase("adaos")) {
            this.buffer.append("C,1,______,_,__;0;");
            this.buffer.append(attributes.getValue("percent"));
            this.buffer.append(";;;;\n");
        } else if (qName.equalsIgnoreCase("payment")) {
            String type = attributes.getValue("type");
            this.buffer.append("T,1,______,_,__;");
            type = type.toUpperCase();
            String codCasa = (String)this.paymentTypes.get(type);
            this.buffer.append(codCasa);
            this.buffer.append(";");
            this.buffer.append(attributes.getValue("amount"));
            this.buffer.append(";;;;\n");
        } else if (qName.equalsIgnoreCase("receipt")) {
            this.idBon = attributes.getValue("bonId");
            String s1 = attributes.getValue("idOrder");
            this.idOrder = -1;
            if (Validators.correctString(s1)) {
                this.idOrder = Integer.parseInt(s1);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("receipt")) {
            // empty if block
        }
    }

    public void resetBuffer() {
        if (this.buffer.length() != 0) {
            this.buffer.delete(0, this.buffer.length());
        }
    }

    public String getBuffer() {
        return this.buffer.toString();
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    public String getIdBon() {
        return this.idBon;
    }

    public int getIdOrder() {
        return this.idOrder;
    }
}

