/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs;

import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLicenseVerifier;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.SerialLibraryType;
import ro.atreides.ecr.datecs.Generic;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortParams;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecs.nativeImpl.NewMP55SerialImpl;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecsgen3.UserNotifiyInterface;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;

public class NewMP55
extends AbstractCashRegister {
    private String ecrPort = "";
    private int speed = 9600;
    private boolean errorNotifications;
    protected Vector ecrLicenseCode = new Vector();
    protected boolean discountLaProdus;
    private String discountText;
    private String adaosText;
    protected boolean discountGlobal;
    private UserNotifiyInterface userNotifiyInterface;
    protected Vector<EcrFeedbackInterface> feedbackListeners = new Vector();
    private NewMP55SerialImpl casa;
    private boolean rts;
    private boolean forceDtr;
    private boolean shortTake;
    private PortSettingsPureJava.SerialLibrary serialLibraryType;
    private Integer flowControl;
    private EcrType ecrDef = null;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.ecrPort = conf.getProperty("ecrPort");
        this.speed = Integer.parseInt(conf.getProperty("ecrSpeed", "9600"));
        this.errorNotifications = Boolean.parseBoolean(conf.getProperty("errorNotifications", "true"));
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(conf.getProperty("discountLaProdus", "false"));
        this.discountText = conf.getProperty("discountText", "Discount");
        this.adaosText = conf.getProperty("adaosText", "Adaos");
        Enumeration<?> enu = conf.propertyNames();
        while (enu.hasMoreElements()) {
            String nume = (String)enu.nextElement();
            if (!nume.startsWith("datecs.ecr.code.")) continue;
            String value = conf.getProperty(nume);
            this.ecrLicenseCode.add(value);
        }
        String s2 = conf.getProperty("ecrLicenceCode");
        if (Validators.correctString(s2)) {
            this.ecrLicenseCode.add(s2);
        }
        this.ecrLicenseCode.add("917b203efec1c523103f234b21b83e53bc3bed1");
        this.rts = Boolean.parseBoolean(conf.getProperty("rts", "false"));
        this.shortTake = Boolean.parseBoolean(conf.getProperty("shortTake", "false"));
        String flowS = conf.getProperty("flowControl");
        if (Validators.correctInteger(flowS)) {
            this.flowControl = Integer.parseInt(flowS);
        }
        SerialLibraryType type = SerialLibraryType.valueOf(conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.SERIAL_TYPE.toString(), SerialLibraryType.PureJava.toString()));
        this.forceDtr = type.isForceDtr();
        this.serialLibraryType = type.getLibrary();
        String ecrTypeEnum = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString());
        if (ecrTypeEnum != null) {
            this.ecrDef = EcrType.valueOf(ecrTypeEnum);
        }
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER NewMP55");
        this.userNotifiyInterface = new UserNotifiyInterface(){

            @Override
            public void showTextToUserAndWait(String text) {
                if (NewMP55.this.errorNotifications) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, text, LangRoAll.atentie);
                }
            }

            @Override
            public boolean askTextToUserAndWait(String text) {
                if (NewMP55.this.errorNotifications) {
                    return DialogUtils.confirmDialog(GuiUtils.currentFrame, text, LangRoAll.confirmare);
                }
                return true;
            }

            @Override
            public void bonFinished(int nrBon, int nrZ, int idOrder, String orderIdentifier, int idCasa, boolean lastBon) {
                for (EcrFeedbackInterface feedbackListener : NewMP55.this.feedbackListeners) {
                    feedbackListener.bonFinished(idOrder, nrBon, nrZ, idCasa, MP55Impl.CASA_EXPLAIN_MESSAGES.BON_SELLED_NORMALLY, orderIdentifier, lastBon);
                }
            }
        };
        EcrPortParams ecrPortParams = new EcrPortParams(this.ecrPort, this.speed);
        ecrPortParams.setLibrary(this.serialLibraryType);
        ecrPortParams.setRts(this.rts);
        ecrPortParams.setFlowControl(this.flowControl);
        ecrPortParams.setForceDtr(this.forceDtr);
        ecrPortParams.setShortTake(this.shortTake);
        this.casa = new NewMP55SerialImpl(this.userNotifiyInterface, ecrPortParams);
        this.casa.start();
        this.casa.setSerialNumberInterface(new EcrSerialNumberReadInterface(){

            @Override
            public void licenseBySerieFiscala(String serieFiscala) {
                EcrLicenseVerifier.getInstance().setSerieFiscalaCasaAndLicenseOldSchool(serieFiscala, NewMP55.this.ecrLicenseCode);
            }
        });
    }

    @Override
    public void addListener(EcrFeedbackInterface listener) {
        this.feedbackListeners.add(listener);
    }

    @Override
    public void forceTotal() {
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = Generic.buildBonFiscalText(sales, total, plati, cashDefault, comments, orderIdentifier, idOrder, this.discountGlobal, this.discountLaProdus, false, false, this.discountText, this.adaosText);
        this.processBonFiscal(items, orderIdentifier, idOrder, null, null, null);
        Logger.logDebugVerbose(this, "Content bon fiscal : " + items);
    }

    @Override
    public void processBonFiscal(String items, String idBon, int idOrder, EcrType ecrType, String serieFiscala, BonValidatorResponseInterface responseInterface) {
        Date ecrDate = EcrLogic.getInstance().getEcrDate();
        if (ecrDate == null) {
            EcrLogic.getInstance().setDate(new Date());
        }
        if (!EcrLogic.getInstance().checkBonLimitForTodayAndIncreaseUsage()) {
            return;
        }
        System.out.println("Received bonId \"" + idBon + "\" items \"" + items + "\" ecrType : " + (Object)((Object)ecrType) + " serieFiscala : " + serieFiscala);
        boolean bonHasErrors = false;
        if (ecrType != null && serieFiscala != null && responseInterface != null) {
            BonValidator bv = new BonValidator();
            boolean canCorrect = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.correctBonEnabled);
            Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> generalErrors = new Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>();
            Map<Integer, Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>> errors = bv.checkForErrors(items, ecrType, null, canCorrect, 2, 3, generalErrors);
            System.out.println(errors);
            responseInterface.processErrors(errors, items, serieFiscala, idBon, generalErrors);
            for (Integer n : errors.keySet()) {
                if (bonHasErrors) break;
                Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> errorsForLine = errors.get(n);
                for (Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE> map : errorsForLine) {
                    for (BonValidator.ERROR_FUNCTION function : map.keySet()) {
                        switch (function) {
                            case ERROR: {
                                bonHasErrors = true;
                            }
                        }
                    }
                }
            }
            for (Map map : generalErrors) {
                for (BonValidator.ERROR_FUNCTION function : map.keySet()) {
                    switch (function) {
                        case ERROR: {
                            bonHasErrors = true;
                        }
                    }
                }
            }
        }
        if (bonHasErrors && this.isPrevalidareBonuriEnabled()) {
            return;
        }
        if (this.casa != null) {
            this.casa.process(items, idOrder, idBon);
        }
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void addLicenseCode(String licenseCode) {
        this.ecrLicenseCode.add(licenseCode);
    }

    @Override
    public void setEcrSerialNumberReadInterface(EcrSerialNumberReadInterface ecrSerialNumberInterface) {
        this.casa.setSerialNumberInterface(ecrSerialNumberInterface);
    }

    @Override
    public void printX() {
    }

    @Override
    public void printZ() {
        if (this.ecrDef != null && this.ecrDef.isSupportsZ()) {
            this.processBonFiscal("Z,1,______,_,__;1;\n", "", -1, this.ecrDef, "", null);
        }
    }

    @Override
    public void introduNumerar(double suma) {
        String codOp = "";
        String sumaNoua = "";
        if (suma > 0.0) {
            codOp = "0";
        } else if (suma < 0.0) {
            codOp = "1";
        } else {
            return;
        }
        suma = Math.abs(suma);
        sumaNoua = Utils.getString2DecimalsNoTrunc(suma);
        String s = "I,1,______,_,__;" + codOp + ";" + sumaNoua + ";;;;\n";
        String idBon = Utils.getLocalComputerName() + "_L_" + "numerar";
        this.processBonFiscal(s, idBon, -1, this.ecrDef, "", null);
        Logger.logDebugVerbose(this, "Content bon fiscal : " + s);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }
}

