/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

public class Crc {
    public static final String CRC_NAME = "CRC-16-ECR";
    private static final int POLYNOMIAL = 32769;
    public static final int WIDTH = 16;
    public static final int TOPBIT = 32768;
    short CRC;
    static short[] crcTable = new short[256];

    public Crc() {
        this.crcInit();
    }

    private void crcInit() {
        for (int dividend = 0; dividend < 256; ++dividend) {
            int remainder = dividend << 8;
            for (int bit = 8; bit > 0; bit = (int)((byte)(bit - 1))) {
                remainder = (remainder & 0x8000) != 0 ? (remainder << 1 ^ 0x8001) & 0xFFFF : remainder << 1 & 0xFFFF;
            }
            Crc.crcTable[dividend] = (short)remainder;
        }
    }

    public static short crcFast(byte[] message, int nBytes) {
        int remainder = 0;
        for (int oneByte = 0; oneByte < nBytes; ++oneByte) {
            int data = (message[oneByte] ^ remainder >> 8) & 0xFF;
            remainder = crcTable[data] ^ remainder << 8;
        }
        return (short)remainder;
    }
}

