/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.util.LinkedList;
import java.util.Vector;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrInterface;
import ro.atreides.ecr.EcrInterfaceImpl;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Bon;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.CasaClosedException;
import ro.atreides.ecr.datecs.nativeImpl.Ecr;
import ro.atreides.ecr.datecs.nativeImpl.EcrLicenseInstance;
import ro.atreides.ecr.datecs.nativeImpl.EcrLogger;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortInstanse;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortManager;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecs.nativeImpl.MessageTypes;
import ro.atreides.ecr.datecs.nativeImpl.PersistentList;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecs.nativeImpl.Product;
import ro.atreides.ecr.datecs.nativeImpl.Reader;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.ecr.datecs.nativeImpl.Wrapper;
import ro.atreides.ecr.datecs.nativeImpl.Writer;
import ro.atreides.utils.Logger;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tricky.NonPrintedBonInterface;

public abstract class EcrImpl
extends LangRoAll
implements Ecr {
    protected EcrInterface ecrInterface;
    protected EcrLicenseInstance licenseInstance;
    private EcrPortInstanse portInstance;
    private Writer writer;
    private Reader reader;
    protected EcrLogger logger;
    protected Wrapper wrapper;
    protected PersistentList productsList;
    protected PersistentList feedbackList;
    private boolean running = true;
    private boolean started = false;
    private Vector filters;
    protected int id = 0;
    protected Vector<EcrFeedbackInterface> feedbackListeners;
    protected boolean rts;
    protected PortSettingsPureJava.SerialLibrary type;

    public EcrImpl(Vector license, int id, Vector<EcrFeedbackInterface> feedbackListeners, boolean rts, PortSettingsPureJava.SerialLibrary type) {
        this.id = id;
        this.feedbackListeners = feedbackListeners;
        this.rts = rts;
        this.type = type;
        this.logger = new EcrLogger(id);
        this.wrapper = new Wrapper();
        this.ecrInterface = new EcrInterfaceImpl(id);
        this.productsList = new PersistentList(id);
        this.feedbackList = new PersistentList("_ecr_persistent_feedback_list_" + (id == 0 ? "" : Integer.valueOf(id)));
        this.licenseInstance = new EcrLicenseInstance(license);
    }

    public void addListener(EcrFeedbackInterface newListener) {
        this.feedbackListeners.add(newListener);
    }

    public void notifyListeners(MP55Impl.CASA_EXPLAIN_MESSAGES explain, Bon bon, int nrBon, int nrZ, boolean lastBon) {
        for (EcrFeedbackInterface listener : this.feedbackListeners) {
            int idOrder = bon.getIdOrder();
            listener.bonFinished(idOrder, nrBon, nrZ, this.id, explain, bon.getOrderIdentifier(), lastBon);
        }
    }

    public Vector<EcrFeedbackInterface> getListeners() {
        return this.feedbackListeners;
    }

    public void setErrorNotifications(boolean errorNotifications) {
        this.ecrInterface.setErrorNotifications(errorNotifications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        if (this.started || !this.running) {
            return;
        }
        EcrImpl ecrImpl = this;
        synchronized (ecrImpl) {
            if (!this.isRunning()) {
                return;
            }
            this.started = true;
            this.running = true;
            Thread t = new Thread(){

                @Override
                public void run() {
                    EcrImpl.this.detect(true);
                    if (EcrImpl.this.isRunning()) {
                        EcrImpl.this.startSelling();
                    }
                }
            };
            t.setName("Ecr Printing Thread");
            t.start();
        }
    }

    @Override
    public final synchronized void stop() {
        Logger.logVerbose(this, ">>>>>>>>>>>>>> STOPING ECR <<<<<<<<<<<<");
        this.running = false;
        if (this.portInstance != null) {
            this.portInstance.close();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public final void setEcrInterface(EcrInterface e) {
        if (e != null) {
            this.ecrInterface = e;
        }
    }

    protected abstract void startSelling();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean detect(boolean firstDetection) {
        if (this.portInstance != null) {
            this.portInstance.close();
        }
        if (!firstDetection) {
            Logger.logInfo(this, "ECR INTERFACE: ecrRemoved()");
            int result = this.ecrInterface.ecrRemoved();
            if (result != 0) {
                Logger.logInfo(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            Logger.logInfo(this, "ECR INTERFACE: user choose RETRY");
        }
        while (this.isRunning()) {
            int result;
            EcrPortInstanse ecr;
            EcrImpl ecrImpl = this;
            synchronized (ecrImpl) {
                if (!this.isRunning()) {
                    return false;
                }
                ecr = EcrPortManager.detect(this.id, this.filters, this.rts, this.type);
                if (ecr != null) {
                    this.updateEcrPortInstance(ecr);
                    try {
                        this.ecrInterface.ecrConnected();
                    }
                    catch (Exception e) {
                        Logger.logException(this, e);
                    }
                    return true;
                }
            }
            Utils.sleep(500);
            if (!this.isRunning()) {
                return false;
            }
            if (ecr != null) continue;
            Logger.logInfo(this, "ECR INTERFACE: ecrRemoved()");
            int n = result = firstDetection ? this.ecrInterface.ecrNotPresent() : this.ecrInterface.ecrRemoved();
            if (result != 0) {
                Logger.logInfo(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            if (result != 0) continue;
            Logger.logInfo(this, "ECR INTERFACE: user choose RETRY");
        }
        return false;
    }

    private void updateEcrPortInstance(EcrPortInstanse ecr) {
        this.portInstance = ecr;
        this.writer = this.portInstance.getWriter();
        this.reader = this.portInstance.getReader();
        this.portInstance.setLogger(this.logger);
    }

    @Override
    public final double process(String s, int idOrder, String identifier) {
        this.logger.logDebugVerbose(this, "requesting sell:\n" + s);
        Vector<String> lines = Utils.getLines(s);
        if (BonValidator.correctBon(lines)) {
            LinkedList<Product> products = new LinkedList<Product>();
            double total = 0.0;
            for (String line : lines) {
                Product item = Wrapper.getMessageFromString(line);
                if (item == null) continue;
                if (item.getItemType().equals(MessageTypes.PRODUCT)) {
                    total += item.getItemPrice() * item.getItemQuantity();
                } else if (item.getItemType().equals(MessageTypes.ADAOS)) {
                    total += item.getPercent() / 100.0 * total;
                } else if (item.getItemType().equals(MessageTypes.DISCOUNT)) {
                    total -= item.getPercent() / 100.0 * total;
                } else if (item.getItemType().equals(MessageTypes.SERTAR)) {
                    // empty if block
                }
                products.add(item);
            }
            if (products.size() > 0) {
                Bon bon = new Bon(products, idOrder, identifier);
                bon.setSource(s);
                this.productsList.addBon(bon);
            }
            return total;
        }
        return 0.0;
    }

    public String getFeedback(String identifier) {
        Bon b = this.feedbackList.getByIdentifier(identifier);
        if (b != null) {
            return identifier + "|" + b.getCasaZ() + "|" + b.getCasaBon() + "|" + b.getCasaExplain().toString();
        }
        return identifier + "|" + "NOT_FOUND";
    }

    public void clearFeedbackFile() {
        this.feedbackList.clear();
    }

    @Override
    public boolean isCheckingLicense() {
        return this.licenseInstance.isCheckingLicense();
    }

    protected final void write(byte[] data) throws CasaClosedException {
        boolean detected;
        if (!this.writer.writetoport(data) && !(detected = this.detect(false))) {
            throw new CasaClosedException();
        }
    }

    protected final ArrivedMessage read(int timeout) throws CasaClosedException {
        ArrivedMessage result;
        block2: {
            result = null;
            try {
                result = this.reader.read(timeout);
            }
            catch (Exception e) {
                boolean detected = this.detect(false);
                if (detected) break block2;
                throw new CasaClosedException();
            }
        }
        return result;
    }

    protected final void clearReader() {
        if (this.reader != null && this.reader.queueSize() > 0) {
            this.reader.clear();
        }
    }

    public int getNoOfBonsToPrint() {
        return this.productsList.size();
    }

    public void deleteByIdentifier(String identifier) {
        this.productsList.removeByIdentifier(identifier);
    }

    public void deleteNonPrintedBons(NonPrintedBonInterface inter) {
        this.productsList.deleteNonPrintedBons(inter);
    }

    public Vector getFilters() {
        return this.filters;
    }

    public void setFilters(Vector filters) {
        this.filters = filters;
    }
}

