/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Vector;
import ro.atreides.ecr.EcrLicenseVerifier;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.datecs.NewResponse;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Bon;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.Constants;
import ro.atreides.ecr.datecs.nativeImpl.Crc;
import ro.atreides.ecr.datecs.nativeImpl.EventType;
import ro.atreides.ecr.datecs.nativeImpl.LogerInterface;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecs.nativeImpl.MessageTypes;
import ro.atreides.ecr.datecs.nativeImpl.PersistentList;
import ro.atreides.ecr.datecs.nativeImpl.Product;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.ecr.datecs.nativeImpl.Wrapper;
import ro.atreides.ecr.datecsgen3.UserNotifiyInterface;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.gui.Validators;
import ro.deversoft.drivers.datecs.gen3.noarch.QueBoonAbstract;

public abstract class NewMP55Abstract
extends Thread {
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected boolean mustRun = true;
    LogerInterface logerInterface;
    protected QueBoonAbstract bonsQueue;
    private static final int FULL_MESSAGE_READ_TIMEOUT = 1000;
    private static final int TRY_LOCK_TIMEOUT = 10000;
    private long cleanPipeMillis = 500L;
    private STATE currentState = STATE.MUST_CONNECT;
    private static final String errMessage = "Lipsa hartie sau Z nescos sau casa de marcat deconectata sau neconfigurata. Corectati si apoi apasati OK";
    private static final String bonulSaStersDinFisierulOutQue = "Bonul s-a sters din fisierul 'outQue'. ";
    private Vector<Product> outQueue11 = new Vector();
    private Bon currentBonGlobal;
    protected String serie;
    private NewResponse lastLock = null;
    private ArrivedMessage bonInfosAtBonStart = null;
    private ArrivedMessage currentBonInfos = null;
    private ArrivedMessage previousBonInfos = null;
    protected int ecrId;
    protected PersistentList feedbackList;
    protected UserNotifiyInterface userNotifiyInterface;
    private Product currentCommand;
    private int maxErrCount = 3;
    private boolean commErrOccured = false;
    private int bonCountForToday = 0;
    private boolean shortTake;

    protected NewMP55Abstract(boolean shortTake) {
        this.shortTake = shortTake;
    }

    private STATE cleanPipe() {
        StringBuilder pipeCleanedLog = new StringBuilder();
        try {
            long lastRead = System.currentTimeMillis();
            while (lastRead + this.cleanPipeMillis > System.currentTimeMillis()) {
                int bytesReady = this.inputStream.available();
                if (bytesReady <= 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                lastRead = System.currentTimeMillis();
                byte[] data = new byte[bytesReady];
                int actuallyRead = this.inputStream.read(data);
                for (int i = 0; i < actuallyRead; ++i) {
                    pipeCleanedLog.append(Integer.toHexString(data[i])).append(" ");
                }
            }
            this.logWithState("PipeCleaned [" + pipeCleanedLog.toString() + " ]");
        }
        catch (Exception e) {
            this.logWithState("Exception at cleanPipe : " + e.getMessage());
            e.printStackTrace();
            return STATE.MUST_CONNECT;
        }
        return STATE.WAITING_FOR_COMMANDS;
    }

    public abstract boolean restartSocket();

    public abstract void forceSignalDTR();

    private void setConnected(boolean newValue) {
        this.logWithState("SET CONNECTED TO : " + newValue);
        this.logerInterface.connected(newValue);
    }

    private NewResponse tryLock(String tryLockInfos) throws IOException {
        NewResponse lockResponse = null;
        this.logWithState("TryLock : " + tryLockInfos);
        byte[] ffBuffer = new byte[]{-1};
        if (this.shortTake) {
            int i;
            for (i = 0; i < 10; ++i) {
                this.write(ffBuffer);
            }
            this.write(Constants.RELEASE_MESSAGE_NOU);
            for (i = 0; i < 5; ++i) {
                this.write(ffBuffer);
            }
        } else {
            this.write(Constants.RELEASE_MESSAGE);
        }
        long start = System.currentTimeMillis();
        while (start + 10000L > System.currentTimeMillis()) {
            if (this.shortTake) {
                int i;
                for (i = 0; i < 10; ++i) {
                    this.write(ffBuffer);
                }
                this.write(Constants.TAKE_MESSAGE_NOU_NOU);
                for (i = 0; i < 5; ++i) {
                    this.write(ffBuffer);
                }
            } else {
                this.write(Constants.TAKE_MESSAGE_NOU);
            }
            this.forceSignalDTR();
            lockResponse = this.readResponse(100);
            if (lockResponse == null || lockResponse.isTimeout()) continue;
        }
        if (lockResponse == null) {
            lockResponse = new NewResponse();
            lockResponse.setTimeout(true);
        }
        if (lockResponse.isNack()) {
            this.logWithState("NACK AT TRY LOCK");
        } else if (lockResponse.isTimeout()) {
            this.logWithState("TIMEOUT AT TRY LOCK");
        } else if (lockResponse.isGarbage()) {
            this.logWithState("GARBAGE AT TRY LOCK");
        } else {
            this.writeByte((byte)6);
        }
        return lockResponse;
    }

    protected NewResponse readResponse(int byteReceiveTimeout) throws IOException {
        NewResponse response = null;
        int bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, 1, byteReceiveTimeout);
        if (bytesReady >= 1) {
            byte b = (byte)this.inputStream.read();
            if (b == 6) {
                response = new NewResponse();
                response.setAck(true);
            } else if (b == 21) {
                response = new NewResponse();
                response.setNack(true);
            } else if (b == 10) {
                MESSAGE_READ_STATE state = MESSAGE_READ_STATE.START;
                byte[] currentMessage = new byte[8192];
                int currentPosition = 0;
                long startReadingMessage = System.currentTimeMillis();
                do {
                    bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, 1, byteReceiveTimeout);
                    while (bytesReady >= 1 && response == null) {
                        b = (byte)this.inputStream.read();
                        --bytesReady;
                        currentMessage[currentPosition] = b;
                        ++currentPosition;
                        switch (state) {
                            case START: {
                                state = MESSAGE_READ_STATE.SEARCHING_FOR_END;
                                break;
                            }
                            case SEARCHING_FOR_END: {
                                if (b != 13) break;
                                state = MESSAGE_READ_STATE.SEARCHING_FOR_FIRST_CRC_BYTE;
                                break;
                            }
                            case SEARCHING_FOR_FIRST_CRC_BYTE: {
                                state = MESSAGE_READ_STATE.SEARCHING_FOR_SECOND_CRC_BYTE;
                                break;
                            }
                            case SEARCHING_FOR_SECOND_CRC_BYTE: {
                                short crc = Crc.crcFast(currentMessage, currentPosition - 2);
                                short crcInMessage = (short)(currentMessage[currentPosition - 2] << 8 & 0xFF00 | currentMessage[currentPosition - 1] & 0xFF);
                                if (crc != crcInMessage) {
                                    this.logWithState(EventType.MESSAGE_ERROR.toString() + " COMPUTED : " + crc + " in message " + crcInMessage);
                                }
                                response = new NewResponse();
                                byte[] correctData = new byte[currentPosition];
                                System.arraycopy(currentMessage, 0, correctData, 0, currentPosition);
                                response.setData(correctData);
                            }
                        }
                    }
                } while (response == null && startReadingMessage + 1000L > System.currentTimeMillis());
                if (response == null) {
                    response = new NewResponse();
                    response.setGarbage(true);
                }
            }
        }
        if (response == null) {
            response = new NewResponse();
            response.setTimeout(true);
        }
        return response;
    }

    private void newState(STATE newState) {
        if (newState != this.currentState) {
            this.logWithState("NEW STATE -> " + (Object)((Object)newState));
        }
        this.currentState = newState;
    }

    @Override
    public void run() {
        this.setName(this.getClass().getName());
        this.newState(STATE.MUST_CONNECT);
        while (this.mustRun) {
            switch (this.currentState) {
                case MUST_CONNECT: {
                    boolean status = this.restartSocket();
                    this.setConnected(status);
                    if (status) {
                        this.newState(STATE.MUST_CLEAN_PIPE);
                        this.logWithState("Connected !");
                        break;
                    }
                    this.logerInterface.addLogAndNotifyUser("CONFIGURARE ERONATA PORT SAU PORT INDISPONIBIL ! Remediati si apasati OK !");
                    this.newState(STATE.MUST_CONNECT);
                    break;
                }
                case MUST_CLEAN_PIPE: {
                    this.newState(this.cleanPipe());
                    break;
                }
                case WAITING_FOR_COMMANDS: {
                    if (this.serie == null) {
                        try {
                            this.lastLock = this.tryLock("TRY LOCK TO GET SERIAL NUMBER");
                        }
                        catch (IOException e) {
                            this.newState(STATE.CONNECTION_LOST);
                        }
                        this.interpretLockResponse(this.lastLock);
                    }
                    this.newState(this.scheduleNextBon());
                    break;
                }
                case SENDING: {
                    this.newState(this.sendCommandsFromQueue());
                    break;
                }
                case CONNECTION_LOST: {
                    this.logWithState(" > CONNECTION LOST . ");
                    this.setCommErrOccured(true);
                    this.logerInterface.addLogAndNotifyUser(errMessage);
                    this.newState(STATE.MUST_CONNECT);
                    break;
                }
                case BON_FINISHED: {
                    if (this.currentBonGlobal != null) {
                        this.removeBonFromQueue(this.currentBonGlobal, null);
                    }
                    this.newState(STATE.WAITING_FOR_COMMANDS);
                }
            }
        }
        System.out.println("Stopping thread : " + this.getName());
    }

    public boolean isCommErrOccured() {
        this.logWithState("COMM ERROR : " + this.commErrOccured);
        return this.commErrOccured;
    }

    public void setCommErrOccured(boolean commErrOccured) {
        this.logWithState("SET COMM ERROR : " + commErrOccured);
        this.commErrOccured = commErrOccured;
    }

    public abstract void licenceDriver(String var1);

    private ArrivedMessage interpretLockResponse(NewResponse lockResponse) {
        byte[] data = lockResponse.getData();
        if (data != null) {
            String serieNoua;
            String bytes = TextUtils.getHexString(data, true);
            this.logWithState("TAKE RESPONSE : \"" + new String(data) + "\" bytes : [" + bytes + "]");
            ArrivedMessage responseMessage = Wrapper.parse(data, data.length);
            if (this.serie == null && (serieNoua = responseMessage.getSeria()) != null && serieNoua.length() > 0) {
                this.serie = serieNoua;
                this.licenceDriver(serieNoua);
            }
            if (responseMessage.isType_A()) {
                this.logWithState("TAKE RESPONSE = OK");
                this.currentBonInfos = responseMessage;
                if (this.bonInfosAtBonStart == null) {
                    this.logWithState("SET BON INFOS : [" + responseMessage + "]");
                    this.bonInfosAtBonStart = responseMessage;
                    this.logerInterface.newBonStarted(this.bonInfosAtBonStart.getNrZ(), this.bonInfosAtBonStart.getNrBon());
                }
            } else {
                this.logWithState("TAKE RESPONSE NOT \"A\" : " + lockResponse);
            }
            return responseMessage;
        }
        this.logWithState("RECEIVED LOCK WITH NULL data[] . This shouldn't happen");
        new Exception().printStackTrace();
        return null;
    }

    private STATE sendCommandsFromQueue() {
        if (this.currentCommand != null) {
            this.logWithState("CURRENT COMMAND NOT NULL . INITIATING CHECK PROCEDURE");
            if (this.currentCommand.isSentToEcr()) {
                if (!this.currentCommand.isConfirmedByEcr()) {
                    if (this.isCommErrOccured()) {
                        boolean printedOK = false;
                        switch (this.currentCommand.getItemType()) {
                            case COMMENTS: 
                            case SERTAR: 
                            case COPIE: {
                                printedOK = true;
                                break;
                            }
                            default: {
                                try {
                                    this.lastLock = this.tryLock("TRY LOCK TO CHECK IF LAST COMMAND WAS ACTUALLY EXECUTED");
                                }
                                catch (IOException e) {
                                    return STATE.CONNECTION_LOST;
                                }
                                this.interpretLockResponse(this.lastLock);
                                double oldTotal = 0.0;
                                if (this.previousBonInfos != null) {
                                    oldTotal = this.previousBonInfos.getTotal();
                                }
                                double newTotal = this.currentBonInfos.getTotal();
                                this.logWithState("RECOVERY CHECK : CHECKING TOTALS : OLD TOTAL : " + oldTotal + " NEW TOTAL : " + newTotal);
                                if (oldTotal == newTotal) {
                                    this.logWithState("RECOVERY CHECK : TOTAL IS NOT MODIFIED !! WILL RETRY PRODUCT !!");
                                    printedOK = false;
                                    break;
                                }
                                printedOK = true;
                                this.logWithState("RECOVERY CHECK : COMMAND WAS ACTUALLY EXECUTED BEFORE COMM LOST . GOOD. JUST REMOVING FROM QUEUE !!");
                            }
                        }
                        if (printedOK) {
                            this.currentCommand.setConfirmedByEcr(true);
                            this.outQueue11.remove(0);
                            this.currentCommand = null;
                        }
                    } else if (this.currentCommand.getErrCount() > this.maxErrCount) {
                        if (!this.logerInterface.addLogAndASKUser("PRODUSUL " + this.currentCommand + " ARE DEJA " + this.maxErrCount + " INCERCARI DE TIPARIRE . VREI SA MAI INCERC (daca apesi NU voi sari peste acest produs) ")) {
                            this.outQueue11.remove(0);
                        } else {
                            this.currentCommand.setErrCount(0);
                            this.logerInterface.addLogAndNotifyUser("REMEDIAZA CAUZA SI APASA OK . DACA PROBLEMA PERSISTA SARI PESTE PRODUS ");
                        }
                        this.currentCommand = null;
                        return STATE.SENDING;
                    }
                } else {
                    this.logWithState("un produs sent si confirmed nu are ce cauta in coada. " + this.currentCommand);
                }
            } else if (this.currentCommand.getErrCount() > this.maxErrCount) {
                if (!this.logerInterface.addLogAndASKUser("PRODUSUL " + this.currentCommand.getSource() + " NU ESTE ACCEPTAT DE CASA DE MARCAT ! VREI SA MAI INCERC (daca apesi NU voi sari peste acest produs) ")) {
                    this.outQueue11.remove(0);
                } else {
                    this.currentCommand.setErrCount(0);
                    this.logerInterface.addLogAndNotifyUser("REMEDIAZA CAUZA SI APASA OK . DACA PROBLEMA PERSISTA SARI PESTE PRODUS ");
                }
                this.currentCommand = null;
                return STATE.SENDING;
            }
        }
        this.setCommErrOccured(false);
        if (this.outQueue11.size() > 0) {
            this.logWithState("SENDING FROM QUEUE");
            if (this.lastLock == null || this.lastLock != null && !this.lastLock.isCorectResponse()) {
                try {
                    this.lastLock = this.tryLock("TRY LOCK BECAUSE LAST LOCK IS NULL OR INCORRECT");
                }
                catch (IOException e) {
                    return STATE.CONNECTION_LOST;
                }
                this.interpretLockResponse(this.lastLock);
            }
            if (this.lastLock.isCorectResponse()) {
                this.currentCommand = this.outQueue11.get(0);
                try {
                    boolean timeout = false;
                    boolean printedOK = false;
                    for (int i = 0; i < 8; ++i) {
                        this.logWithState("COMMAND TO ECR : " + this.currentCommand.getSource());
                        this.write(this.currentCommand.getRawMessage());
                        NewResponse commandResponse = this.readResponse(150);
                        if (commandResponse.isAck()) {
                            this.logWithState("RECEIVED ACK");
                            this.currentCommand.setSentToEcr(true);
                            double oldTotal = this.currentBonInfos.getTotal();
                            this.previousBonInfos = this.currentBonInfos;
                            this.lastLock = this.tryLock("TRY LOCK TO CHECK PRODUCT PRINTED OK !!");
                            if (this.lastLock.isCorectResponse()) {
                                ArrivedMessage interpreted = this.interpretLockResponse(this.lastLock);
                                if (interpreted != null) {
                                    double newTotal = interpreted.getTotal();
                                    switch (this.currentCommand.getItemType()) {
                                        case COMMENTS: 
                                        case SERTAR: 
                                        case COPIE: {
                                            printedOK = true;
                                            break;
                                        }
                                        default: {
                                            this.logWithState("CHECKING TOTALS : OLD TOTAL : " + oldTotal + " NEW TOTAL : " + newTotal);
                                            if (oldTotal == newTotal) {
                                                this.logWithState("TOTAL IS NOT MODIFIED !! WILL RETRY PRODUCT AND INCREASE ERR COUNT !!");
                                                this.currentCommand.increaseErrCount();
                                                printedOK = false;
                                                break;
                                            }
                                            printedOK = true;
                                        }
                                    }
                                    if (printedOK) {
                                        this.currentCommand.setConfirmedByEcr(true);
                                        this.outQueue11.remove(0);
                                        this.currentCommand = null;
                                    }
                                    return STATE.SENDING;
                                }
                                return STATE.SENDING;
                            }
                            return STATE.CONNECTION_LOST;
                        }
                        if (commandResponse.isNack()) {
                            this.logWithState("RECEIVED NACK. RETRY WITH CURRENT LOCK! RETRY INDEX : " + i);
                            continue;
                        }
                        if (commandResponse.isTimeout()) {
                            this.logWithState("TIMEOUT. INVALIDATING LOCK, start over !");
                            timeout = true;
                            break;
                        }
                        if (!commandResponse.isGarbage()) continue;
                        this.logWithState("RECEIVED GARBAGE.");
                        return STATE.MUST_CLEAN_PIPE;
                    }
                    if (!printedOK && !timeout) {
                        this.logWithState("received NACK 8 times in a row for command " + this.currentCommand + " !! WILL TRY AGAIN WITH NEW LOCK AND INCREASE ERR COUNT !!");
                        this.currentCommand.increaseErrCount();
                    }
                    this.lastLock = null;
                    return STATE.SENDING;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return STATE.CONNECTION_LOST;
                }
            }
            return STATE.CONNECTION_LOST;
        }
        return STATE.BON_FINISHED;
    }

    private void logWithState(String message) {
        this.logerInterface.addLog((Object)((Object)this.currentState) + ": " + message);
    }

    private STATE scheduleNextBon() {
        if (this.outQueue11.size() <= 0) {
            Bon currentBon;
            if (this.bonsQueue.getQueBoonSize() > 0 && (currentBon = (Bon)this.bonsQueue.getBon()) != null) {
                try {
                    this.lastLock = this.tryLock("TRY LOCK - START PRINTING NEW RECEIPT");
                }
                catch (IOException e) {
                    return STATE.CONNECTION_LOST;
                }
                this.interpretLockResponse(this.lastLock);
                if (this.currentBonGlobal != null) {
                    this.logWithState("AM BON ANTERIOR NEFINALIZAT . AS PUTEA SA-L ANULEZ PRODUS CU PRODUS !");
                } else if (this.currentBonInfos != null && this.currentBonInfos.hasTotalRest()) {
                    this.logWithState("WARNING : PREVIOUS BON IS NOT CLOSED. FORCE CLOSE WITH TOTAL");
                    try {
                        this.write(Wrapper.buildTotal().getRawMessage());
                        this.logerInterface.addLogAndNotifyUser("AM INCHIS FORTAT BONUL ANTERIOR ( FACETI PROCES VERBAL !! )");
                        return STATE.WAITING_FOR_COMMANDS;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return STATE.CONNECTION_LOST;
                    }
                }
                this.outQueue11.addAll(currentBon.getProducts());
                this.currentBonGlobal = currentBon;
                return STATE.SENDING;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return STATE.WAITING_FOR_COMMANDS;
        }
        return STATE.SENDING;
    }

    private void writeByte(byte toWrite) throws IOException {
        byte[] array = new byte[]{toWrite};
        this.write(array);
    }

    private void write(byte[] array) throws IOException {
        String bytes = TextUtils.getHexString(array, true);
        this.logWithState("WRITING: [" + bytes + "]");
        this.outputStream.write(array);
        this.outputStream.flush();
    }

    private int waitUntilAllBytesAppearOrTimeout(InputStream inputStream, int howManyBytes, long timeoutInMillis) throws IOException {
        int bytesReady = -1;
        long lastRead = System.currentTimeMillis();
        while (lastRead + timeoutInMillis > System.currentTimeMillis() && (bytesReady = inputStream.available()) < howManyBytes) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        return bytesReady;
    }

    private void removeBonFromQueue(Bon currentBon, String errorReason) {
        this.bonsQueue.removeBon(currentBon);
        if (errorReason != null) {
            this.logWithState("Bonul s-a sters din fisierul 'outQue'.  Reason : " + errorReason + " . Bon follows " + currentBon + " \n");
            new Exception().printStackTrace();
            MP55Impl.CASA_EXPLAIN_MESSAGES explain = MP55Impl.CASA_EXPLAIN_MESSAGES.BON_FAILED;
            int nrBon = -1;
            int nrZ = -1;
            currentBon.setCasaExplain(explain);
            currentBon.setCasaBon(nrBon + "");
            currentBon.setCasaZ(nrZ + "");
            this.userNotifiyInterface.bonFinished(nrBon, nrZ, currentBon.getIdOrder(), currentBon.getOrderIdentifier(), this.ecrId, true);
            this.logerInterface.addLogAndNotifyUser(errorReason);
        } else {
            MP55Impl.CASA_EXPLAIN_MESSAGES explain = MP55Impl.CASA_EXPLAIN_MESSAGES.BON_SELLED_NORMALLY;
            int nrBon = -1;
            int nrZ = -1;
            if (this.bonInfosAtBonStart != null) {
                nrBon = this.bonInfosAtBonStart.getNrBon();
                nrZ = this.bonInfosAtBonStart.getNrZ();
            } else {
                this.logWithState("BON INFOS IS NULL : THIS SHOULDN'T HAPPEN !!!");
            }
            currentBon.setCasaExplain(explain);
            currentBon.setCasaBon(nrBon + "");
            currentBon.setCasaZ(nrZ + "");
            this.feedbackList.addBon(currentBon);
            this.userNotifiyInterface.bonFinished(nrBon, nrZ, currentBon.getIdOrder(), currentBon.getOrderIdentifier(), this.ecrId, true);
            this.logWithState("Bonul s-a sters din fisierul 'outQue'.  Reason : normal operation. Bon follows " + currentBon + "\n");
        }
        this.outQueue11.clear();
        this.currentBonGlobal = null;
        this.bonInfosAtBonStart = null;
    }

    public double process(String s, int idOrder, String identifier) {
        this.logWithState("Requesting sell:\n" + s);
        boolean lastCommandIsSale = false;
        boolean totalStarted = false;
        Vector<String> lines = Utils.getLines(s);
        if (BonValidator.correctBon(lines)) {
            LinkedList<Product> products = new LinkedList<Product>();
            double total = 0.0;
            for (String line : lines) {
                boolean acceptCommand = true;
                lastCommandIsSale = false;
                Product item = Wrapper.getMessageFromString(line);
                if (item == null) continue;
                if (item.getItemType().equals(MessageTypes.PRODUCT)) {
                    total += item.getItemPrice() * item.getItemQuantity();
                    lastCommandIsSale = true;
                } else if (item.getItemType().equals(MessageTypes.TOTAL)) {
                    String nextBonCui;
                    if (!totalStarted && Validators.correctString(nextBonCui = EcrLogic.getInstance().getNextBonCUI())) {
                        String cuiLine = "P,1,______,_,__;" + nextBonCui + ";;;;;";
                        Product item2 = Wrapper.getMessageFromString(cuiLine);
                        products.add(item2);
                        EcrLogic.getInstance().setNextBonCUI(null);
                    }
                    totalStarted = true;
                } else if (item.getItemType().equals(MessageTypes.ADAOS)) {
                    total += item.getPercent() / 100.0 * total;
                } else if (item.getItemType().equals(MessageTypes.DISCOUNT)) {
                    total -= item.getPercent() / 100.0 * total;
                } else if (!item.getItemType().equals(MessageTypes.SERTAR) && item.getItemType().equals(MessageTypes.COMMENTS)) {
                    if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.printCodFiscalEnabled)) {
                        acceptCommand = true;
                    } else {
                        acceptCommand = false;
                        if (lastCommandIsSale) {
                            String payload = line.substring("P,1,______,_,__;".length());
                            Vector textTokens = ro.atreides.utils.Utils.splitString(payload, ' ');
                            for (String textToken : textTokens) {
                                String numeric = textToken.replaceAll("[^\\d.]", "");
                                if (numeric.length() <= 5) continue;
                                acceptCommand = false;
                                break;
                            }
                        } else {
                            acceptCommand = false;
                        }
                    }
                }
                if (!acceptCommand) continue;
                products.add(item);
            }
            if (products.size() > 0) {
                Bon bon = new Bon(products, idOrder, identifier);
                bon.setSource(s);
                this.bonsQueue.addBon(bon);
                ++this.bonCountForToday;
            }
            return total;
        }
        return 0.0;
    }

    private static enum MESSAGE_READ_STATE {
        START,
        SEARCHING_FOR_END,
        SEARCHING_FOR_FIRST_CRC_BYTE,
        SEARCHING_FOR_SECOND_CRC_BYTE;

    }

    private static enum STATE {
        MUST_CLEAN_PIPE,
        MUST_CONNECT,
        CONNECTION_LOST,
        WAITING_FOR_COMMANDS,
        BON_FINISHED,
        SENDING;

    }
}

