/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.Enumeration;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.datecs.nativeImpl.Bon;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortParams;
import ro.atreides.ecr.datecs.nativeImpl.LogerInterface;
import ro.atreides.ecr.datecs.nativeImpl.NewMP55Abstract;
import ro.atreides.ecr.datecs.nativeImpl.PersistentList;
import ro.atreides.ecr.datecsgen3.UserNotifiyInterface;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.drivers.datecs.gen3.noarch.QueBoonAbstract;

public class NewMP55SerialImpl
extends NewMP55Abstract {
    protected static String driverName = "NewMP55SerialImpl";
    protected EcrSerialNumberReadInterface serialNumberInterface;
    protected EcrPortParams portParams;
    private gnu.io.SerialPort rxtxSerialPort = null;
    private SerialPort pureJavaSerialPort = null;

    public NewMP55SerialImpl(UserNotifiyInterface userNotifiyInterface1, EcrPortParams portParams) {
        super(portParams.isShortTake());
        this.portParams = portParams;
        this.userNotifiyInterface = userNotifiyInterface1;
        this.bonsQueue = new QueBoonAbstract("_datecs_gen1_persistent_product_list");
        this.feedbackList = new PersistentList("_datecs_gen1_persistent_feedback_list");
        this.logerInterface = new LogerInterface(){

            @Override
            public void addLog(String data) {
                Logger.logDebug(this, data);
            }

            @Override
            public void addLogAndNotifyUser(String string) {
                Logger.logDebug(this, string);
                NewMP55SerialImpl.this.userNotifiyInterface.showTextToUserAndWait(string);
            }

            @Override
            public void connected(boolean status) {
                EcrLogic.getInstance().ecrConnected(status);
            }

            @Override
            public void newBonStarted(int nrZ, int nrBon) {
                Logger.logDebug(this, "NEW BON STARTED : " + nrZ + "_" + nrBon);
                EcrLogic.getInstance().setCurrentBonNumber(nrZ, nrBon);
            }

            @Override
            public boolean addLogAndASKUser(String string) {
                Logger.logDebug(this, string);
                return NewMP55SerialImpl.this.userNotifiyInterface.askTextToUserAndWait(string);
            }
        };
    }

    @Override
    public boolean restartSocket() {
        switch (this.portParams.getLibrary()) {
            case PURE_JAVA: {
                return this.initPortPureJava(this.portParams);
            }
            case RXTX: {
                return this.initPortRxtx(this.portParams);
            }
        }
        return false;
    }

    @Override
    public void forceSignalDTR() {
        if (this.portParams.isForceDtr()) {
            if (this.pureJavaSerialPort != null) {
                this.pureJavaSerialPort.setDTR(true);
            }
            if (this.rxtxSerialPort != null) {
                this.rxtxSerialPort.setDTR(true);
            }
        }
    }

    private boolean initPortRxtx(EcrPortParams portParams) {
        block16: {
            String portName = portParams.getName();
            try {
                if (this.rxtxSerialPort != null) {
                    try {
                        this.rxtxSerialPort.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.rxtxSerialPort = null;
                boolean portFound = false;
                gnu.io.CommPortIdentifier portId = null;
                Enumeration portList = gnu.io.CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    portId = (gnu.io.CommPortIdentifier)portList.nextElement();
                    System.out.println("port : name " + portId.getName() + " owner " + portId.getCurrentOwner() + " portType " + portId.getPortType() + " owned " + portId.isCurrentlyOwned());
                    String currentPort = portId.getName();
                    if (!currentPort.equalsIgnoreCase(portName)) continue;
                    Logger.logDebug(this, "Found port: " + portName);
                    portFound = true;
                    break;
                }
                if (!portFound) {
                    try {
                        portId = gnu.io.CommPortIdentifier.getPortIdentifier((String)portName);
                    }
                    catch (gnu.io.NoSuchPortException e) {
                        Logger.logException(this, (Exception)((Object)e));
                        DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port incorect : \"" + portName + "\"." + " Corectati si reporniti !!", LangRoAll.nuPotContinua);
                        this.mustRun = false;
                        return false;
                    }
                }
                this.rxtxSerialPort = (gnu.io.SerialPort)portId.open(driverName, 2000);
                Integer flowControl = portParams.getFlowControl();
                if (flowControl != null) {
                    this.rxtxSerialPort.setFlowControlMode(flowControl.intValue());
                }
                int flow = this.rxtxSerialPort.getFlowControlMode();
                this.logerInterface.addLog("FLOW CONTROL TYPE : " + flow);
                this.rxtxSerialPort.setSerialPortParams(portParams.getSpeed(), 8, 1, 0);
                this.rxtxSerialPort.setRTS(portParams.isRts());
                this.rxtxSerialPort.setInputBufferSize(10);
                this.inputStream = this.rxtxSerialPort.getInputStream();
                this.outputStream = this.rxtxSerialPort.getOutputStream();
                String x = "RXTX forceDTR : " + portParams.isForceDtr() + " : RecvTimeout " + this.rxtxSerialPort.getReceiveTimeout() + " FLOW " + this.rxtxSerialPort.getFlowControlMode() + " baudrate " + this.rxtxSerialPort.getBaudRate() + " databits " + this.rxtxSerialPort.getDataBits() + " parity " + this.rxtxSerialPort.getParity() + " RTS " + this.rxtxSerialPort.isRTS() + " CTS " + this.rxtxSerialPort.isCTS() + " CD " + this.rxtxSerialPort.isCD() + " DSR " + this.rxtxSerialPort.isDSR() + " DTR " + this.rxtxSerialPort.isDTR() + " RI " + this.rxtxSerialPort.isRI() + " QueueInSize : " + this.rxtxSerialPort.getInputBufferSize() + " QueueOutSize : " + this.rxtxSerialPort.getOutputBufferSize();
                System.out.println(x);
                Logger.logInfo(this, x);
                return true;
            }
            catch (PortInUseException e) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port ocupat : \"" + portName + "\" ." + "<br> Verificati ce aplicatii folosesc portul, SAU incercati mai tarziu, SAU restart", LangRoAll.nuPotContinua);
                if (this.rxtxSerialPort != null) {
                    this.rxtxSerialPort.close();
                }
            }
            catch (UnsupportedCommOperationException e) {
                Logger.logException(this, (Exception)((Object)e));
                if (this.rxtxSerialPort != null) {
                    this.rxtxSerialPort.close();
                }
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                if (this.rxtxSerialPort == null) break block16;
                this.rxtxSerialPort.close();
            }
        }
        return false;
    }

    private boolean initPortPureJava(EcrPortParams portParams) {
        block16: {
            String portName = portParams.getName();
            String shortPortName = portName.replace("/dev/", "");
            try {
                if (this.pureJavaSerialPort != null) {
                    try {
                        this.pureJavaSerialPort.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.pureJavaSerialPort = null;
                boolean portFound = false;
                CommPortIdentifier portId = null;
                Enumeration portList = CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    portId = (CommPortIdentifier)portList.nextElement();
                    System.out.println("port : name " + portId.getName() + " owner " + portId.getCurrentOwner() + " portType " + portId.getPortType() + " owned " + portId.isCurrentlyOwned());
                    String currentPort = portId.getName();
                    if (!currentPort.equalsIgnoreCase(portName) && !currentPort.equalsIgnoreCase(shortPortName)) continue;
                    Logger.logDebug(this, "Found port: " + portName);
                    portFound = true;
                    break;
                }
                if (!portFound) {
                    try {
                        portId = CommPortIdentifier.getPortIdentifier((String)shortPortName);
                    }
                    catch (NoSuchPortException e) {
                        Logger.logException(this, (Exception)((Object)e));
                        DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port incorect : \"" + portName + "\"." + " Corectati si reporniti !!", LangRoAll.nuPotContinua);
                        this.mustRun = false;
                        return false;
                    }
                }
                this.pureJavaSerialPort = (SerialPort)portId.open(driverName, 2000);
                Integer flowControl = portParams.getFlowControl();
                if (flowControl != null) {
                    this.pureJavaSerialPort.setFlowControlMode(flowControl.intValue());
                }
                int flow = this.pureJavaSerialPort.getFlowControlMode();
                this.logerInterface.addLog("FLOW CONTROL TYPE : " + flow);
                this.pureJavaSerialPort.setSerialPortParams(portParams.getSpeed(), 8, 1, 0);
                this.pureJavaSerialPort.setRTS(portParams.isRts());
                this.inputStream = this.pureJavaSerialPort.getInputStream();
                this.outputStream = this.pureJavaSerialPort.getOutputStream();
                String x = "PUREJAVA : forceDTR : " + portParams.isForceDtr() + " RecvTimeout " + this.pureJavaSerialPort.getReceiveTimeout() + " FLOW " + this.pureJavaSerialPort.getFlowControlMode() + " baudrate " + this.pureJavaSerialPort.getBaudRate() + " databits " + this.pureJavaSerialPort.getDataBits() + " parity " + this.pureJavaSerialPort.getParity() + " RTS " + this.pureJavaSerialPort.isRTS() + " CTS " + this.pureJavaSerialPort.isCTS() + " CD " + this.pureJavaSerialPort.isCD() + " DSR " + this.pureJavaSerialPort.isDSR() + " DTR " + this.pureJavaSerialPort.isDTR() + " RI " + this.pureJavaSerialPort.isRI() + " QueueInSize : " + this.pureJavaSerialPort.getInputBufferSize() + " QueueOutSize : " + this.pureJavaSerialPort.getOutputBufferSize();
                System.out.println(x);
                Logger.logInfo(this, x);
                return true;
            }
            catch (purejavacomm.PortInUseException e) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port ocupat : \"" + portName + "\" ." + "<br> Verificati ce aplicatii folosesc portul, SAU incercati mai tarziu, SAU restart", LangRoAll.nuPotContinua);
                if (this.pureJavaSerialPort != null) {
                    this.pureJavaSerialPort.close();
                }
            }
            catch (purejavacomm.UnsupportedCommOperationException e) {
                Logger.logException(this, (Exception)((Object)e));
                if (this.pureJavaSerialPort != null) {
                    this.pureJavaSerialPort.close();
                }
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                if (this.pureJavaSerialPort == null) break block16;
                this.pureJavaSerialPort.close();
            }
        }
        return false;
    }

    public String getFeedback(String identifier) {
        Bon b = this.feedbackList.getByIdentifier(identifier);
        if (b != null) {
            return identifier + "|" + b.getCasaZ() + "|" + b.getCasaBon() + "|" + b.getCasaExplain().toString();
        }
        return identifier + "|" + "NOT_FOUND";
    }

    public void clearFeedbackFile() {
        this.feedbackList.clear();
    }

    @Override
    public void licenceDriver(String serialCode) {
        this.serialNumberInterface.licenseBySerieFiscala(serialCode);
    }

    public void setSerialNumberInterface(EcrSerialNumberReadInterface serialNumberInterface) {
        this.serialNumberInterface = serialNumberInterface;
    }
}

