/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.Serializable;
import ro.atreides.ecr.datecs.nativeImpl.MessageTypes;
import ro.atreides.utils.Logger;

public class Product
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 5315623375743308372L;
    private String Name;
    private double Price;
    private double Quantity;
    private byte[] rawMessage;
    private MessageTypes itemType;
    private double percent;
    private String source;
    private int errCount;
    private boolean lastCommand;
    private boolean sentToEcr;
    private boolean confirmedByEcr;

    public Product(byte[] message, String itemName, double price, double quantity, String source) {
        this.rawMessage = message;
        this.Name = itemName;
        this.Price = price;
        this.Quantity = quantity;
        this.itemType = MessageTypes.PRODUCT;
        this.source = source;
    }

    public Product(byte[] message, double percent, MessageTypes type, String source) {
        this.rawMessage = message;
        this.percent = percent;
        this.Name = "";
        this.Quantity = 1.0;
        this.itemType = type;
        this.source = source;
    }

    public Product(byte[] message, MessageTypes type, String source) {
        this.rawMessage = message;
        this.Name = "";
        this.Quantity = 1.0;
        this.itemType = type;
        this.source = source;
    }

    public String getItemName() {
        return this.Name;
    }

    public double getItemPrice() {
        return this.Price;
    }

    public void setItemPrice(double newPrice) {
        this.Price = newPrice;
    }

    public double getItemQuantity() {
        return this.Quantity;
    }

    public MessageTypes getItemType() {
        return this.itemType;
    }

    public byte[] getRawMessage() {
        return this.rawMessage;
    }

    public double getPercent() {
        return this.percent;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return this.source;
    }

    protected Product clone() {
        Product result = null;
        try {
            result = (Product)super.clone();
            result.rawMessage = (byte[])this.rawMessage.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }

    public int getErrCount() {
        return this.errCount;
    }

    public void setErrCount(int errCount) {
        this.errCount = errCount;
    }

    public void increaseErrCount() {
        ++this.errCount;
    }

    public boolean isLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(boolean lastCommand) {
        this.lastCommand = lastCommand;
    }

    public boolean isSentToEcr() {
        return this.sentToEcr;
    }

    public void setSentToEcr(boolean sentToEcr) {
        this.sentToEcr = sentToEcr;
    }

    public boolean isConfirmedByEcr() {
        return this.confirmedByEcr;
    }

    public void setConfirmedByEcr(boolean confirmedByEcr) {
        this.confirmedByEcr = confirmedByEcr;
    }
}

