/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortWrapper;
import ro.atreides.ecr.datecs.nativeImpl.UnsupportedCommOperationExceptionWrapper;

public class SerialPortPureJavaImpl
implements SerialPortWrapper {
    SerialPort serialPort;

    private void printPortSettings(String prefix) {
        System.out.println(prefix + " RecvTimeout " + this.serialPort.getReceiveTimeout() + " FLOW " + this.serialPort.getFlowControlMode() + " baudrate " + this.serialPort.getBaudRate() + " databits " + this.serialPort.getDataBits() + " parity " + this.serialPort.getParity() + " RTS " + this.serialPort.isRTS() + " CTS " + this.serialPort.isCTS() + " CD " + this.serialPort.isCD() + " DSR " + this.serialPort.isDSR() + " DTR " + this.serialPort.isDTR() + " RI " + this.serialPort.isRI());
    }

    @Override
    public void enableReceiveTimeout(int timeout) throws UnsupportedCommOperationExceptionWrapper {
        try {
            String x = "Enable receive timeout BEFORE ";
            this.printPortSettings(x);
            this.serialPort.enableReceiveTimeout(timeout);
            x = "Enable receive timeout AFTER ";
            this.printPortSettings(x);
        }
        catch (UnsupportedCommOperationException e) {
            UnsupportedCommOperationExceptionWrapper wrapper = new UnsupportedCommOperationExceptionWrapper();
            wrapper.setPureJavaUnsupportedException(e);
            throw wrapper;
        }
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    @Override
    public void setRTS(boolean newValue) {
        this.serialPort.setRTS(newValue);
    }

    @Override
    public void setSerialPortParams(int speed, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationExceptionWrapper {
        try {
            this.serialPort.setSerialPortParams(speed, dataBits, stopBits, parity);
        }
        catch (UnsupportedCommOperationException e) {
            UnsupportedCommOperationExceptionWrapper wrapper = new UnsupportedCommOperationExceptionWrapper();
            wrapper.setPureJavaUnsupportedException(e);
            throw wrapper;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.serialPort.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.serialPort.getOutputStream();
    }

    @Override
    public void setRealSerialPort(Object serialPort) {
        this.serialPort = (SerialPort)serialPort;
    }

    @Override
    public int getFlowControl() {
        return this.serialPort.getFlowControlMode();
    }
}

