/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.util.Date;
import java.util.Vector;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Crc;
import ro.atreides.ecr.datecs.nativeImpl.Message;
import ro.atreides.ecr.datecs.nativeImpl.MessageTypes;
import ro.atreides.ecr.datecs.nativeImpl.Product;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;

public class Wrapper {
    private static Crc crcCalculator = new Crc();
    private static final int INVALID = Integer.MIN_VALUE;

    public static Product getMessageFromString(String s) {
        char c = s.charAt(0);
        try {
            switch (c) {
                case 'S': {
                    int index = 2;
                    String LogicalNumber = s.substring(index, s.indexOf(44, index));
                    index = s.indexOf(59, index) + 1;
                    String Name2 = s.substring(index, s.indexOf(59, index));
                    index = s.indexOf(59, index) + 1;
                    int indexOfStart = index - 1;
                    String Price = s.substring(index, s.indexOf(59, index));
                    index = s.indexOf(59, index) + 1;
                    String Quantity = s.substring(index, s.indexOf(59, index));
                    index = s.indexOf(59, index) + 1;
                    String Department = s.substring(index, s.indexOf(59, index));
                    index = s.indexOf(59, index) + 1;
                    String Articol_Group = s.substring(index, s.indexOf(59, index));
                    index = s.indexOf(59, index) + 1;
                    String TVA_Group = s.substring(index, s.indexOf(59, index));
                    String normalizedName = Utils.getStringMaxSize(22, Name2, Character.valueOf(' '), false).toUpperCase();
                    double price = Utils.parseDouble(Price);
                    double quantity = Utils.parseDouble(Quantity);
                    String rest2 = ";" + Utils.getString2DecimalsNoTrunc(price) + ";" + Utils.getString3DecimalsNoTrunc(quantity) + ";" + Department + ";" + Articol_Group + ";" + TVA_Group + ";0;0;";
                    String tmp = "L;" + LogicalNumber + ";" + normalizedName + rest2;
                    byte[] message = Wrapper.constructMessage(tmp);
                    return new Product(message, Name2, price, (int)quantity, s);
                }
                case 'P': {
                    String tmp = "X" + s.substring(s.indexOf(59), s.length());
                    return new Product(Wrapper.constructMessage(tmp), MessageTypes.COMMENTS, s);
                }
                case 'T': {
                    String tipPlata2;
                    if (s.length() <= 16) {
                        String tmp = "E;0;;;;;";
                        return new Product(Wrapper.constructMessage(tmp), MessageTypes.TOTAL, s);
                    }
                    boolean isCopie = false;
                    Vector tokens = Utils.splitString(s, ';');
                    if (tokens.size() != 1 && tokens.size() == 2 && (tipPlata2 = (String)tokens.get(1)).equals("8")) {
                        isCopie = true;
                    }
                    if (!isCopie) {
                        int beginIndex = s.indexOf(59);
                        String payload = s.substring(beginIndex, s.length());
                        String tmp = "E" + payload;
                        return new Product(Wrapper.constructMessage(tmp), MessageTypes.TOTAL, s);
                    }
                    String tmp = "E;8;;;;;";
                    return new Product(Wrapper.constructMessage(tmp), MessageTypes.COPIE, s);
                }
                case 'D': {
                    String tmp = "E;8;;;;;";
                    return new Product(Wrapper.constructMessage(tmp), MessageTypes.COPIE, s);
                }
                case 'C': {
                    int index = s.indexOf(59);
                    String tmp = "C" + s.substring(index, s.length());
                    String type = s.substring(++index, s.indexOf(59, index));
                    index = s.indexOf(59, index) + 1;
                    String percent = s.substring(index, s.indexOf(59, index));
                    int t = Integer.parseInt(type);
                    double p = Utils.parseDouble(percent);
                    if (t == 1) {
                        return new Product(Wrapper.constructMessage(tmp), p, MessageTypes.DISCOUNT, s);
                    }
                    if (t == 0) {
                        return new Product(Wrapper.constructMessage(tmp), p, MessageTypes.ADAOS, s);
                    }
                    return null;
                }
                case 'I': {
                    int index = s.indexOf(59);
                    String tmp = "I" + s.substring(index, s.length());
                    return new Product(Wrapper.constructMessage(tmp), MessageTypes.SERTAR, s);
                }
                case 'H': {
                    String tmp = "H;;;;;;";
                    return new Product(Wrapper.constructMessage(tmp), MessageTypes.BLOCARE_TASTATURA, s);
                }
                case 'F': {
                    String tmp = "F;;;;;;";
                    return new Product(Wrapper.constructMessage(tmp), MessageTypes.DEBLOCARE_TASTATURA, s);
                }
                case 'Z': {
                    int beginIndex = s.indexOf(59);
                    String payload = s.substring(beginIndex, s.length());
                    String tmp = "Z" + payload;
                    Logger.logDebugVerbose("Wrapper", "Z : fullmessage : \"" + tmp + "\"");
                    return new Product(Wrapper.constructMessage(tmp), MessageTypes.ZGOLIRE, s);
                }
            }
            return null;
        }
        catch (Exception e) {
            Logger.logException(Wrapper.class.getName(), e);
            return null;
        }
    }

    public static byte[] constructMessage(String s) {
        byte[] temp_buffer_for_construct = new byte[256];
        byte[] tempBuffer = new byte[s.length() + 4];
        Logger.logDebugVerbose("Wrapper", "TEXT = " + s);
        int j = 0;
        tempBuffer[j++] = 10;
        int i = 0;
        while (i < s.length()) {
            temp_buffer_for_construct[i] = tempBuffer[j] = (byte)s.charAt(i);
            ++i;
            ++j;
        }
        temp_buffer_for_construct[i++] = 13;
        tempBuffer[j++] = 13;
        short crc = Crc.crcFast(temp_buffer_for_construct, i);
        byte bite1 = (byte)(crc & 0xFF);
        crc = (short)(crc >> 8);
        byte bite0 = (byte)(crc & 0xFF);
        crc = (short)(crc >> 8);
        tempBuffer[j++] = bite0;
        tempBuffer[j++] = bite1;
        return tempBuffer;
    }

    public static ArrivedMessage parse(Message message) {
        byte[] currentMessage = message.getData();
        int length = currentMessage.length;
        return Wrapper.parse(currentMessage, length);
    }

    public static ArrivedMessage parse(byte[] currentMessage, int length) {
        String message = TextUtils.getHexString(currentMessage, true);
        ArrivedMessage result = new ArrivedMessage(currentMessage);
        result.setReceivedAt(new Date());
        StringBuilder bufferCode = new StringBuilder();
        try {
            int i;
            int k = 0;
            bufferCode.delete(0, bufferCode.length());
            for (i = 0; i < currentMessage.length && i < 6; ++i) {
                byte b = currentMessage[i];
                bufferCode.append((char)b);
            }
            result.setSeria(bufferCode.toString());
            bufferCode.delete(0, bufferCode.length());
            for (i = 0; i < length; ++i) {
                if (k == 2) {
                    char c = (char)currentMessage[i];
                    switch (c) {
                        case '1': {
                            Logger.logVerbose(Wrapper.class.getName(), "\nWARNING: RESPONSE NOT A: \n" + message);
                            result.setType(2);
                            break;
                        }
                        case '3': {
                            Logger.logVerbose(Wrapper.class.getName(), "\nWARNING: RESPONSE NOT A: \n" + message);
                            result.setType(3);
                            break;
                        }
                        case '7': {
                            Logger.logVerbose(Wrapper.class.getName(), "\nWARNING: RESPONSE NOT A: \n" + message);
                            result.setType(4);
                            break;
                        }
                        case 'A': {
                            return Wrapper.parseTypeA(result, currentMessage);
                        }
                        case 'B': {
                            Logger.logVerbose(Wrapper.class.getName(), "\nWARNING: RESPONSE NOT A: \n" + message);
                            return Wrapper.markAsErrorTypeA(result);
                        }
                        case 'F': {
                            Logger.logVerbose(Wrapper.class.getName(), "\nWARNING: RESPONSE NOT A: \n" + message);
                            return Wrapper.markAsErrorTypeA(result);
                        }
                    }
                    ++i;
                }
                if (i >= length || currentMessage[i] != 59) continue;
                ++k;
            }
        }
        catch (Exception e) {
            Logger.logException("Wrapper.parse ", e);
        }
        return result;
    }

    private static ArrivedMessage parseTypeA(ArrivedMessage result, byte[] message) {
        result.setType(5);
        StringBuilder buffer = new StringBuilder();
        int k = 0;
        for (int i = 0; i < message.length; ++i) {
            if (k == 1) {
                i = Wrapper.getDataFromBytes(buffer, message, i);
                String index = buffer.toString();
                if (index.length() > 0) {
                    result.setIndex(Integer.parseInt(index));
                } else {
                    result.setIndex(0);
                }
            } else if (k == 3) {
                i = Wrapper.getDataFromBytes(buffer, message, i);
                if (buffer.length() > 0) {
                    result.setIDLE(false);
                } else {
                    result.setIDLE(true);
                }
            } else if (k == 5) {
                i = Wrapper.getDataFromBytes(buffer, message, i);
                String nrBon = buffer.toString();
                Logger.logVerbose("Wrapper.parseTypeA.nrBon = ", nrBon);
                if (nrBon.length() > 0) {
                    result.setNrBon(Integer.parseInt(nrBon));
                }
            } else if (k == 6) {
                i = Wrapper.getDataFromBytes(buffer, message, i);
                String total = buffer.toString();
                Logger.logVerbose("Wrapper.parseTypeA.total = ", total);
                if (total.length() > 0) {
                    result.setTotal(Utils.parseDoubleIgnoreThousands(total));
                } else {
                    result.setTotal(0.0);
                }
            } else if (k == 8) {
                i = Wrapper.getDataFromBytes(buffer, message, i);
                String nrZ = buffer.toString();
                Logger.logVerbose("Wrapper.parseTypeA.nrZ", nrZ);
                if (nrZ.length() <= 0) break;
                result.setNrZ(Integer.parseInt(nrZ));
                break;
            }
            if (message[i] != 59) continue;
            ++k;
        }
        return result;
    }

    private static int getDataFromBytes(StringBuilder buffer, byte[] message, int startIndex) {
        int result = startIndex;
        buffer.delete(0, buffer.length());
        for (int i = startIndex; i < message.length; ++i) {
            byte b = message[i];
            if (b == 59) {
                result = i;
                break;
            }
            buffer.append((char)b);
        }
        return result;
    }

    private static ArrivedMessage markAsErrorTypeA(ArrivedMessage message) {
        if (message != null) {
            message.setType(5);
            message.setError_Message(true);
        }
        return message;
    }

    public static Product buildTotal() {
        return Wrapper.getMessageFromString("T,1,______,_,__;");
    }

    public Product buildNoLicenseMessage() {
        String s = "P;----------------;NO LICENSE;----------------;FABRICADESOFT.RO;----------------;";
        return Wrapper.getMessageFromString(s);
    }

    public static Vector getAnulareForProducts(Vector products) {
        Vector<Product> result = new Vector<Product>();
        for (int i = 0; i < products.size(); ++i) {
            Product p = (Product)products.get(i);
            if (p.getItemType() != MessageTypes.PRODUCT || !(p.getItemQuantity() > 0.0)) continue;
            String s = p.getSource();
            int index = 2;
            String LogicalNumber = s.substring(index, s.indexOf(44, index));
            index = s.indexOf(59, index) + 1;
            String Name2 = s.substring(index, s.indexOf(59, index));
            index = s.indexOf(59, index) + 1;
            String Price = s.substring(index, s.indexOf(59, index));
            index = s.indexOf(59, index) + 1;
            String Quantity = "-" + s.substring(index, s.indexOf(59, index));
            index = s.indexOf(59, index) + 1;
            int indexOfStart = index - 1;
            String tmp = s.substring(0, s.indexOf(59) + 1) + (Name2.length() > 22 ? Name2.substring(0, 22) : Name2) + ";" + Price + ";" + Quantity + s.substring(indexOfStart, s.length());
            Product ppp = Wrapper.getMessageFromString(tmp);
            if (ppp == null) continue;
            result.add(ppp);
        }
        return result;
    }
}

