/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.IOException;
import java.io.OutputStream;
import ro.atreides.ecr.datecs.nativeImpl.EcrLogger;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;

public class Writer {
    private OutputStream out;
    private EcrLogger ecrLogger;

    public Writer(OutputStream out, EcrLogger ecrLogger) {
        this.out = out;
        this.ecrLogger = ecrLogger;
    }

    public void setEcrLogger(EcrLogger ecrLogger) {
        this.ecrLogger = ecrLogger;
    }

    public Writer(OutputStream outPut) {
        this(outPut, null);
    }

    public synchronized boolean writetoport(byte[] array) {
        try {
            this.writetoport_NOFLUSH_Internal(array);
            this.flushInternal();
            return true;
        }
        catch (IOException e) {
            this.printError(e);
            return false;
        }
    }

    public synchronized boolean flush() {
        try {
            this.flushInternal();
            return true;
        }
        catch (IOException e) {
            this.printError(e);
            return false;
        }
    }

    private void writetoport_NOFLUSH_Internal(byte[] array) throws IOException {
        if (array != null) {
            this.out.write(array);
            String bytes = TextUtils.getHexString(array, true);
            this.printDebugVerbose("WRITING: [" + bytes + "]");
        }
    }

    private void flushInternal() throws IOException {
        this.out.flush();
    }

    private void printDebugVerbose(String s) {
        if (this.ecrLogger == null) {
            Logger.logDebugVerbose(this, s);
        } else {
            this.ecrLogger.logDebugVerbose(this, s);
        }
    }

    private void printError(Exception e) {
        if (this.ecrLogger == null) {
            Logger.logWarning(this, ">>>>>>>>>>>>>>>>>>>>> I/O WRITE EXCEPTION <<<<<<<<<<<<<<<<<<<<");
        } else {
            this.ecrLogger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>> I/O WRITE EXCEPTION <<<<<<<<<<<<<<<<<<<<");
        }
    }
}

