/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.elcom;

import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private int um;
    private int tvaDefault;
    private int totalDecimalPlaces;
    private boolean forceTotal;
    private boolean paymentAsFloat = false;
    private boolean paymentReplaceDotWithComma = false;
    private boolean discountLaLinie = false;

    @Override
    public void buildConfiguration(Properties conf) {
        int u;
        super.buildConfiguration(conf);
        String um = conf.getProperty("unitateMasura", "1");
        this.um = u = Integer.parseInt(um);
        String tvaDefault = conf.getProperty("tvaDefault", "1");
        this.tvaDefault = Integer.parseInt(tvaDefault);
        this.forceTotal = Boolean.parseBoolean(conf.getProperty("forceTotal", "false"));
        this.paymentAsFloat = Boolean.parseBoolean(conf.getProperty("paymentAsFloat", "false"));
        this.paymentReplaceDotWithComma = Boolean.parseBoolean(conf.getProperty("paymentReplaceDotWithComma", "false"));
        this.discountLaLinie = Boolean.parseBoolean(conf.getProperty("discountLaLinie", "false"));
        this.totalDecimalPlaces = Integer.parseInt(conf.getProperty("totalDecimalPlaces", "2"));
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "";
        long printPrice = 1L;
        for (int i = 0; i < this.onlineDecimalPlaces; ++i) {
            printPrice *= 10L;
        }
        for (EcrSale newsaleentry : sales) {
            String product = newsaleentry.getProduct();
            double nrPortii = FloatUtils.roundDouble(newsaleentry.getQuantity(), 2);
            double orig = FloatUtils.roundDouble(newsaleentry.getPpuOriginal(), 2);
            double cuReducere = FloatUtils.roundDouble(newsaleentry.getPpuDupaDiscount(), 2);
            double pret = this.discountLaLinie ? orig : cuReducere;
            long p = (long)((double)printPrice * pret);
            String codTva = "" + this.tvaDefault;
            if (Validators.correctString(newsaleentry.getCodTva())) {
                codTva = newsaleentry.getCodTva();
            }
            String commandText = "1;" + product + ";" + this.um + ";" + newsaleentry.getDepartament() + ";" + codTva + ";" + p + ";" + Utils.getString3Decimals(nrPortii * 1000.0) + ";0;1";
            items = items + commandText;
            items = items + "\n";
            if (orig == cuReducere || !this.discountLaLinie) continue;
            String tip = "";
            long origL = (long)((double)printPrice * orig);
            long cuReducereL = (long)((double)printPrice * cuReducere);
            long val = 0L;
            if (orig > cuReducere) {
                tip = "1";
                val = origL - cuReducereL;
            } else {
                tip = "0";
                val = cuReducereL - origL;
            }
            String line = "7;" + tip + ";0;1;0;" + val + ";1";
            items = items + line + "\n";
        }
        for (int i = 0; i < comments.size(); ++i) {
            String o = (String)comments.elementAt(i);
            if (!Validators.correctString(o = o.toUpperCase())) {
                o = "*";
            }
            String line = "1;" + o + ";8;1;1;100;1000;0;1";
            items = items + line + "\n";
        }
        if (plati == null || plati.size() == 0) {
            items = items + "3\n";
        } else {
            double totalPlatit = 0.0;
            for (EcrPlata plata : plati) {
                double p = FloatUtils.roundDouble(plata.getSuma(), 2);
                String s = "";
                if (this.paymentAsFloat) {
                    s = Utils.getString2DecimalsNoTrunc(p);
                } else {
                    long l = FloatUtils.convertToLong(p, this.totalDecimalPlaces);
                    s = l + "";
                }
                if (this.paymentReplaceDotWithComma) {
                    s = s.replaceAll("\\.", ",");
                }
                items = items + "5;" + s + ";" + plata.getEcrMapping() + ";0;\n";
                totalPlatit += plata.getSuma();
            }
            if (!Utils.isValueZero(totalPlatit - total)) {
                double p = total - totalPlatit;
                p = FloatUtils.roundDouble(p, this.totalDecimalPlaces);
                String s = "";
                if (this.paymentAsFloat) {
                    s = Utils.getString2DecimalsNoTrunc(p);
                } else {
                    long l = (long)(p * (double)printPrice);
                    s = l + "";
                }
                if (this.paymentReplaceDotWithComma) {
                    s = s.replaceAll("\\.", ",");
                }
                items = items + "5;" + s + ";" + cashDefault.getEcrMapping() + ";0;\n";
            }
            if (this.forceTotal) {
                items = items + "3\n";
            }
        }
        this.pt.addToQueue(items);
    }

    @Override
    public void forceTotal() {
    }
}

