/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.eltrade;

import java.util.Iterator;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private String endOfLine = "\r\n";

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "";
        Iterator iter = sales.iterator();
        double discount = 0.0;
        while (iter.hasNext()) {
            EcrSale sale = (EcrSale)iter.next();
            String codS = Utils.getStringMaxSize(4, sale.getCod() + "", Character.valueOf('0'), true);
            String produs = Utils.getStringMaxSize(12, sale.getProduct(), Character.valueOf(' '), false);
            String priceS = this.getValue(sale.getPpuOriginal(), 2);
            priceS = Utils.getStringMaxSize(8, priceS, Character.valueOf('0'), true);
            String quantity = this.getValue(sale.getQuantity(), 3);
            quantity = Utils.getStringMaxSize(8, quantity, Character.valueOf('0'), true);
            String tva = Utils.getStringMaxSize(1, sale.getCodTva(), null, false);
            String departament = Utils.getStringMaxSize(2, sale.getDepartament(), Character.valueOf('0'), true);
            String saleCommand = codS + produs + priceS + quantity + tva + departament + this.endOfLine;
            items = items + saleCommand;
            discount += sale.getQuantity() * sale.getDiscount();
        }
        if ((discount = FloatUtils.roundDoubleUp(discount, 2)) > 0.0) {
            String d = this.getValue(discount, 2);
            d = Utils.getStringMaxSize(4, d, Character.valueOf('0'), true);
            items = items + "#S-" + d + this.endOfLine;
        }
        if (plati == null || plati.size() == 0) {
            items = items + "#E1" + this.endOfLine;
        } else {
            for (EcrPlata plata : plati) {
                if (plata.equals(cashDefault)) continue;
                String p = Utils.getString2Decimals(plata.getSuma());
                items = items + "#E" + plata.getEcrMapping() + p + this.endOfLine;
            }
            items = items + this.endOfLine;
        }
        this.pt.addToQueue(items);
    }

    private String getValue(double toConvert, int decimals) {
        long l = FloatUtils.convertToLong(toConvert, decimals);
        return l + "";
    }

    @Override
    public void printX() {
        String cmd = "$FI" + this.endOfLine;
        this.pt.addToQueue(cmd);
    }

    @Override
    public void printZ() {
        String cmd = "$FN" + this.endOfLine;
        this.pt.addToQueue(cmd);
    }

    @Override
    public void forceTotal() {
    }
}

