/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.euro;

import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private boolean forceTotal;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.forceTotal = Boolean.parseBoolean(conf.getProperty("forceTotal", "false"));
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        int i;
        StringBuffer s = new StringBuffer();
        for (i = 0; i < sales.size(); ++i) {
            EcrSale ecrSale = (EcrSale)sales.elementAt(i);
            long tva = FloatUtils.convertToLong(ecrSale.getCotaTva(), 2);
            String line = "01;" + Utils.getStringMaxSize(14, ".", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(14, Utils.getString2DecimalsNoTrunc(ecrSale.getPpuDupaDiscount()), Character.valueOf('0'), true) + ";" + Utils.getStringMaxSize(11, Utils.getString4DecimalsNoTrunc(ecrSale.getQuantity()), Character.valueOf('0'), true) + ";" + Utils.getStringMaxSize(2, ecrSale.getDepartament(), Character.valueOf('0'), true) + ";" + Utils.getStringMaxSize(5, Utils.getString2DecimalsNoTrunc(tva), Character.valueOf('0'), true) + ";" + Utils.getStringMaxSize(25, ecrSale.getProduct(), Character.valueOf(' '), false) + ";\n";
            s.append(line);
        }
        for (i = 0; i < comments.size(); ++i) {
            String comment = (String)comments.elementAt(i);
            String line = "03;" + Utils.getStringMaxSize(14, i + 1 + "", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(14, " ", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(11, " ", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(2, " ", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(5, " ", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(25, comment, Character.valueOf(' '), false) + ";\n";
            s.append(line);
        }
        String defaultEcrMap = "1";
        if (cashDefault != null) {
            defaultEcrMap = cashDefault.getEcrMapping();
        }
        if (plati == null || plati.size() == 0) {
            String line = this.getPlataLine(defaultEcrMap, "");
            s.append(line);
        } else {
            double totalPlatit = 0.0;
            for (EcrPlata plata : plati) {
                String line = this.getPlataLine(plata.getEcrMapping(), Utils.getString2DecimalsNoTrunc(plata.getSuma()));
                s.append(line);
                totalPlatit += plata.getSuma();
            }
            if (this.forceTotal || totalPlatit < total) {
                String line = this.getPlataLine(defaultEcrMap, "");
                s.append(line);
            }
        }
        this.processBonFiscal(s.toString(), "", idOrder, null, null, null);
    }

    private String getPlataLine(String ecrMapping, String suma) {
        String line = "02;" + Utils.getStringMaxSize(14, ecrMapping, Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(14, suma, Character.valueOf('0'), true) + ";" + Utils.getStringMaxSize(11, " ", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(2, " ", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(5, " ", Character.valueOf(' '), false) + ";" + Utils.getStringMaxSize(25, " ", Character.valueOf(' '), false) + ";\n";
        return line;
    }

    @Override
    public void forceTotal() {
    }
}

