/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.incotex.noarch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import ro.atreides.ecr.incotex.noarch.Bon;
import ro.atreides.ecr.incotex.noarch.IncotexPersistentList;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessage;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageResponse;

public class IncotexNoarchImpl
extends Thread {
    protected InputStream inS;
    protected OutputStream outS;
    private boolean mustRun = true;
    protected IncotexPersistentList outQueue = new IncotexPersistentList(){

        @Override
        protected Vector<Bon> getProductsFor(String file) {
            return null;
        }

        @Override
        protected void setProductsFor(Vector<Bon> products, String file) {
        }
    };

    public void addBon(Bon b) {
        this.outQueue.addBon(b);
    }

    private IncotexMessageResponse write(IncotexMessage toWrite, OutputStream outS, InputStream inS) throws IOException {
        byte[] stream = toWrite.getBytes();
        outS.write(stream);
        outS.flush();
        IncotexMessageResponse mess = this.getReponse(inS, 5000L);
        return mess;
    }

    private void emptyInputBuffer(long readTimeout) throws IOException {
        int toRead = 0;
        long start = System.currentTimeMillis();
        while (toRead > 0 && System.currentTimeMillis() < start + readTimeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.inS.read();
            toRead = this.inS.available();
        }
    }

    private IncotexMessageResponse getReponse(InputStream inS, long readTimeout) throws IOException {
        long start = System.currentTimeMillis();
        int toRead = 0;
        while (toRead <= 0 && System.currentTimeMillis() < start + readTimeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            toRead = inS.available();
        }
        if (toRead <= 0) {
            return new IncotexMessageResponse(IncotexMessageResponse.ERROR_TIMEOUT);
        }
        for (int synMax = 50; synMax > 0; --synMax) {
            int ch = inS.read();
            if (ch == 21) {
                return new IncotexMessageResponse(IncotexMessageResponse.ERROR_RECEIVED_NACK);
            }
            if (ch == 22) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                continue;
            }
            if (ch == 1) {
                byte[] buffer = new byte[65535];
                buffer[0] = (byte)ch;
                long endOfPacketTimeout = 10L * readTimeout;
                start = System.currentTimeMillis();
                int i = 1;
                boolean packetfound = false;
                while (System.currentTimeMillis() < start + endOfPacketTimeout) {
                    toRead = inS.available();
                    if (toRead > 0) {
                        ch = inS.read();
                        buffer[i] = (byte)ch;
                        ++i;
                        if (ch != 3) continue;
                        packetfound = true;
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!packetfound) {
                    return new IncotexMessageResponse(IncotexMessageResponse.ERROR_TIMEOUT);
                }
                byte[] buffer2 = new byte[i];
                System.arraycopy(buffer, 0, buffer2, 0, buffer2.length);
                return new IncotexMessageResponse(buffer2);
            }
            return new IncotexMessageResponse(IncotexMessageResponse.ERROR_STRANGE_CHARS);
        }
        return new IncotexMessageResponse(IncotexMessageResponse.ERROR_TIMEOUT);
    }

    public final int getNoOfBonsToPrint() {
        return this.outQueue.size();
    }

    public void setMustRun(boolean mustRun) {
        this.mustRun = mustRun;
    }

    protected void startWork() throws IOException {
        boolean error = false;
        int maxTries = 5;
        int tries = 0;
        while (this.mustRun) {
            if (this.outQueue.size() > 0) {
                Bon bon = this.outQueue.get();
                int seq = 1;
                int respSeq = 1;
                Vector<IncotexMessage> products = bon.getSales();
                for (IncotexMessage query : products) {
                    query.setPacketNo(++seq);
                    IncotexMessageResponse resp = this.write(query, this.outS, this.inS);
                    if (resp.isNack()) {
                        System.out.println("incotex: Received NACK !!!");
                    } else if (resp.isTimeout()) {
                        System.out.println("incotex: TIMEOUT !!!");
                    } else {
                        respSeq = resp.getPacketNo();
                        if (respSeq != seq) {
                            System.out.println("incotex: Secventa gresita message=" + seq + " resp=" + respSeq);
                        } else {
                            System.out.println("incotex: Secventa corecta message=" + seq + " resp=" + respSeq);
                        }
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!error) {
                    this.outQueue.remove(bon);
                    tries = 0;
                    continue;
                }
                if (tries >= 5) {
                    System.out.println("incotex: Eroare fatala - am renuntat");
                    this.outQueue.remove(bon);
                } else {
                    this.emptyInputBuffer(5000L);
                    ++tries;
                }
                error = false;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
    }

    public void setInS(InputStream inS) {
        this.inS = inS;
    }

    public void setOutS(OutputStream outS) {
        this.outS = outS;
    }

    public void clearQueue() {
        this.outQueue.clear();
    }
}

