/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.incotex.noarch;

import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.incotex.noarch.Bon;
import ro.atreides.ecr.incotex.noarch.IncotexNoarchImpl;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageAllVoid;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageCloseFiscalReceipt;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageComment;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageOpenFiscalReceipt;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessagePayment;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessagePaymentCashRest;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageSaleProduct;
import ro.atreides.utils.Utils;

public class XmlParser
extends DefaultHandler {
    IncotexNoarchImpl driver;
    Bon currentBon = null;
    Hashtable<String, String> paymentTypesCodes = new Hashtable();
    String idBon = "";
    String idOrder = "";
    double totalSales = 0.0;
    double totalPlati = 0.0;
    boolean demo;

    public XmlParser(IncotexNoarchImpl driver, boolean isDemo) {
        this.driver = driver;
        this.demo = isDemo;
        this.paymentTypesCodes.put("CASH", "P");
        this.paymentTypesCodes.put("CARD", "N");
        this.paymentTypesCodes.put("TICKET", "C");
    }

    @Override
    public void startElement(String uri, String qName, String localName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("product")) {
            String product = attributes.getValue("label");
            String priceS = attributes.getValue("price");
            String qS = attributes.getValue("quantity");
            String vatCode = attributes.getValue("vat");
            double q = Utils.parseDouble(qS);
            double priceDupaDiscount = Utils.parseDouble(priceS);
            IncotexMessageSaleProduct sale = new IncotexMessageSaleProduct(priceDupaDiscount, q, product, 'A', 0.0);
            this.currentBon.addSale(sale);
            this.totalSales += q * priceDupaDiscount;
        } else if (qName.equalsIgnoreCase("ad")) {
            String text = attributes.getValue("text");
            if (text != null && text.length() > 0) {
                text = " ";
            }
            IncotexMessageComment sale = new IncotexMessageComment(text);
            this.currentBon.addSale(sale);
        } else if (qName.equalsIgnoreCase("discount")) {
            attributes.getValue("percent");
        } else if (qName.equalsIgnoreCase("adaos")) {
            attributes.getValue("percent");
        } else if (qName.equalsIgnoreCase("payment")) {
            String type = attributes.getValue("type");
            type = type.toUpperCase();
            String codCasa = this.paymentTypesCodes.get(type);
            String valueS = attributes.getValue("amount");
            double value = Utils.parseDouble(valueS);
            IncotexMessagePayment payment = new IncotexMessagePayment(codCasa, value);
            this.currentBon.addSale(payment);
            this.totalPlati += value;
        } else if (qName.equalsIgnoreCase("receipt")) {
            this.idBon = attributes.getValue("bonId");
            this.idOrder = attributes.getValue("idOrder");
            this.currentBon = new Bon();
            this.currentBon.addSale(new IncotexMessageAllVoid());
            this.currentBon.addSale(new IncotexMessageOpenFiscalReceipt());
            this.totalSales = 0.0;
            this.totalPlati = 0.0;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("receipt")) {
            if (this.totalPlati < this.totalSales) {
                this.currentBon.addSale(new IncotexMessagePaymentCashRest());
            }
            if (this.demo) {
                this.currentBon.addSale(new IncotexMessageComment(" "));
                IncotexMessageComment sale = new IncotexMessageComment("Soft by www.DeverSoft.ro");
                this.currentBon.addSale(sale);
                this.currentBon.addSale(new IncotexMessageComment(" "));
            }
            this.currentBon.addSale(new IncotexMessageCloseFiscalReceipt());
            this.driver.addBon(this.currentBon);
            this.idBon = "";
            this.idOrder = "";
        }
    }
}

