/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.incotex.noarch.test;

import java.util.Iterator;
import java.util.Vector;
import ro.atreides.ecr.incotex.noarch.Bon;
import ro.atreides.ecr.incotex.noarch.IncotexNoarchImpl;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessage;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageAllVoid;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageCloseFiscalReceipt;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageComment;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageOpenFiscalReceipt;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessagePayment;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessagePaymentCashRest;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageSaleProduct;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageXReport;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageZReport;
import ro.atreides.ecr.incotex.noarch.test.IncotexNoarchEcrPlata;
import ro.atreides.ecr.incotex.noarch.test.IncotexNoarchEcrSale;

public class IncotexTestNoarch {
    public static void prepareMessages(IncotexNoarchImpl driver) {
        if (driver == null) {
            return;
        }
        Vector<IncotexNoarchEcrSale> sales = new Vector<IncotexNoarchEcrSale>();
        IncotexNoarchEcrSale s1 = new IncotexNoarchEcrSale("test1", 1.0, 2.0, 3.0, 1.0, 101, "1", 1, "A", 0.24);
        sales.add(s1);
        IncotexNoarchEcrSale s2 = new IncotexNoarchEcrSale("test2", 2.0, 1.0, 2.0, 1.0, 101, "1", 1, "A", 0.24);
        sales.add(s2);
        Vector<IncotexNoarchEcrPlata> plati = new Vector<IncotexNoarchEcrPlata>();
        IncotexNoarchEcrPlata p1 = new IncotexNoarchEcrPlata();
        p1.setEcrMapping("N");
        p1.setSuma(3.0);
        p1.setTipPlata("Numerar");
        plati.add(p1);
        IncotexTestNoarch.setSale(driver, sales, plati);
    }

    public static void setSale(IncotexNoarchImpl driver, Vector<IncotexNoarchEcrSale> sales, Vector<IncotexNoarchEcrPlata> plati) {
        Object sale;
        Bon b = new Bon();
        b.addSale(new IncotexMessageAllVoid());
        IncotexMessageOpenFiscalReceipt openFiscalReceipt = new IncotexMessageOpenFiscalReceipt();
        b.addSale(openFiscalReceipt);
        double total = 0.0;
        for (IncotexNoarchEcrSale o : sales) {
            sale = o;
            double price = ((IncotexNoarchEcrSale)sale).getPpuOriginal();
            double discount = (((IncotexNoarchEcrSale)sale).getPpuDupaDiscount() - ((IncotexNoarchEcrSale)sale).getPpuOriginal()) * ((IncotexNoarchEcrSale)sale).getQuantity();
            IncotexMessageSaleProduct produs = new IncotexMessageSaleProduct(price, ((IncotexNoarchEcrSale)sale).getQuantity(), ((IncotexNoarchEcrSale)sale).getProduct(), ((IncotexNoarchEcrSale)sale).getCodTva().charAt(0), discount);
            b.addSale(produs);
            total += ((IncotexNoarchEcrSale)sale).getPpuDupaDiscount() * ((IncotexNoarchEcrSale)sale).getQuantity();
        }
        double totalPlatit = 0.0;
        Iterator<IncotexNoarchEcrPlata> i$ = plati.iterator();
        while (i$.hasNext()) {
            IncotexNoarchEcrPlata o;
            IncotexNoarchEcrPlata plata = o = i$.next();
            IncotexMessagePayment payment = new IncotexMessagePayment(plata.getEcrMapping(), plata.getSuma());
            b.addSale(payment);
            totalPlatit += plata.getSuma();
        }
        if (totalPlatit < total) {
            IncotexMessagePaymentCashRest payment = new IncotexMessagePaymentCashRest();
            b.addSale(payment);
        }
        b.addSale(new IncotexMessageComment(" "));
        sale = new IncotexMessageComment("Soft by www.DeverSoft.ro");
        b.addSale((IncotexMessage)sale);
        b.addSale(new IncotexMessageComment(" "));
        IncotexMessageCloseFiscalReceipt closeFiscalReceipt = new IncotexMessageCloseFiscalReceipt();
        b.addSale(closeFiscalReceipt);
        driver.addBon(b);
    }

    private static void sendCancel(IncotexNoarchImpl impl) {
        if (impl == null) {
            return;
        }
        Bon b = new Bon();
        b.addSale(new IncotexMessageAllVoid());
        impl.addBon(b);
    }

    public static void sendZReport(IncotexNoarchImpl impl) {
        if (impl == null) {
            return;
        }
        Bon b = new Bon();
        b.addSale(new IncotexMessageZReport());
        impl.addBon(b);
    }

    public static void sendXReport(IncotexNoarchImpl impl) {
        if (impl == null) {
            return;
        }
        Bon b = new Bon();
        b.addSale(new IncotexMessageXReport());
        impl.addBon(b);
    }
}

