/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.atreides.ecr.SerialUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ZipUtils;

public class LogsArchivator
implements Runnable {
    private static final Pattern PATTERN_IS_LOGFILE = Pattern.compile("[0-9]{4}-[0-1][0-9]-[0-3][0-9]_[0-2][0-9]-[0-6][0-9]__[0-9]{1,5}[.]log", 2);
    private String logsDir;

    public LogsArchivator(String logsDir) {
        this.logsDir = logsDir;
    }

    @Override
    public void run() {
        SerialUtils.sleep(300000L);
        ArrayList<LogFile> tmp = new ArrayList<LogFile>();
        while (true) {
            ArrayList<LogFile> files;
            if ((files = this.getCurrentLogsFiles()).size() > 0) {
                tmp.clear();
                tmp.add(files.get(0));
                for (int i = 1; i < files.size(); ++i) {
                    LogFile lg = files.get(i);
                    String date = lg.getData();
                    if (date.equals(((LogFile)tmp.get(0)).getData())) {
                        tmp.add(lg);
                        continue;
                    }
                    this.archiveLogFiles(tmp);
                    tmp.clear();
                    tmp.add(lg);
                }
            }
            SerialUtils.sleep(0x6DDD00L);
        }
    }

    public ArrayList<LogFile> getCurrentLogsFiles() {
        ArrayList<LogFile> result = new ArrayList<LogFile>();
        File dir = new File(this.logsDir);
        if (dir.exists() && dir.isDirectory()) {
            Object[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return LogsArchivator.isValidLogFile(pathname);
                }
            });
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                Object f = files[i];
                LogFile logFile = LogsArchivator.getLogFileForFile((File)f);
                result.add(logFile);
            }
        }
        return result;
    }

    private static LogFile getLogFileForFile(File file) {
        LogFile result = new LogFile();
        String name = file.getName();
        result.setSource(file);
        result.setData(LogsArchivator.getDataFromFile(name));
        result.setId(LogsArchivator.getIdFromFileName(name));
        return result;
    }

    private static String getIdFromFileName(String filename) {
        String result = null;
        int indexOfStart = filename.indexOf("__") + 2;
        int indexOfEnd = filename.indexOf(".", indexOfStart);
        if (indexOfStart != -1) {
            result = filename.substring(indexOfStart, indexOfEnd);
        }
        return result;
    }

    private static String getDataFromFile(String filename) {
        return filename.substring(0, filename.indexOf("_"));
    }

    private static boolean isValidLogFile(File file) {
        Matcher matcher;
        return file != null && file.exists() && file.isFile() && (matcher = PATTERN_IS_LOGFILE.matcher(file.getName())).matches();
    }

    private void archiveLogFiles(ArrayList files) {
        if (files.size() > 0) {
            File[] tt = new File[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                File file;
                LogFile lg = (LogFile)files.get(i);
                tt[i] = file = lg.getSource();
            }
            String zipDir = this.logsDir + File.separator + ((LogFile)files.get(0)).getData();
            FileUtils.moveFilesToDir(tt, new File(zipDir), true);
            tt = null;
            String zipFilename = zipDir + ".zip";
            try {
                ZipUtils.zipCreateRecursive(zipDir, zipFilename);
            }
            catch (Exception e) {
                Logger.logVerbose(this, e.getMessage());
                FileUtils.removeFileRecurse(new File(zipFilename));
            }
            FileUtils.removeFileRecurse(new File(zipDir));
        }
    }

    private static class LogFile {
        private File source;
        private String data;
        private String id;

        private LogFile() {
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public File getSource() {
            return this.source;
        }

        public void setSource(File source) {
            this.source = source;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            return "LogFile{data='" + this.data + '\'' + ", source=" + this.source + ", id='" + this.id + '\'' + '}';
        }
    }
}

