/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import purejavacomm.SerialPort;
import ro.atreides.ecr.EcrClosedException;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.SerialEcr;
import ro.atreides.ecr.SerialReader;
import ro.atreides.ecr.SerialWriter;
import ro.atreides.ecr.mercury.nativeImpl.CancelledReceiptException;
import ro.atreides.ecr.mercury.nativeImpl.LogsArchivator;
import ro.atreides.ecr.mercury.nativeImpl.MercuryDriverInterface;
import ro.atreides.ecr.mercury.nativeImpl.MercuryLogger;
import ro.atreides.ecr.mercury.nativeImpl.MercuryReaderImpl;
import ro.atreides.ecr.mercury.nativeImpl.MercurySeqManager;
import ro.atreides.ecr.mercury.nativeImpl.MercuryWriterImpl;
import ro.atreides.ecr.mercury.nativeImpl.PaperEndException;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.ecr.mercury.nativeImpl.Response;
import ro.atreides.ecr.mercury.nativeImpl.Status;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryFiscalReceiptImpl;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryNonFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryReport;
import ro.atreides.ecr.mercury.nativeImpl.requests.CloseFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.requests.CloseNonFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.requests.DailyReport;
import ro.atreides.ecr.mercury.nativeImpl.requests.FiscalSale;
import ro.atreides.ecr.mercury.nativeImpl.requests.NonFiscalText;
import ro.atreides.ecr.mercury.nativeImpl.requests.OpenFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.requests.OpenNonFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.requests.Payment;
import ro.atreides.ecr.mercury.nativeImpl.requests.ReceiptCancelation;
import ro.atreides.ecr.mercury.nativeImpl.requests.RequestFiscalReceiptStatus;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseFiscalReceiptStatus;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseOpenFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseOpenNonFiscalReceipt;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.licensing.LicenseVerifier;
import ro.atreides.utils.multilang.LangRoAll;

public class Mercury130FImpl
extends SerialEcr {
    private static final Integer[] speeds = new Integer[]{38400, 19200, 9600, 4800, 2400, 1200};
    private MercurySeqManager seqManager;
    private int opNumber = 1;
    private int password = 0;
    private boolean licenseRequired = true;
    private String license;
    private boolean verifyEachItem = true;
    private int itemsPrinted;
    private final int TIMEOUT = 1000;

    public Mercury130FImpl(String id, Vector filters) {
        super("driver" + File.separator + "mercury" + id + File.separator);
        super.setFilters(filters);
        this.logger = new MercuryLogger("driver" + File.separator + "mercury" + id + File.separator);
        this.seqManager = new MercurySeqManager("driver" + File.separator + "mercury" + id + File.separator);
        this.seqManager.setLogger(this.logger);
        this.setDriverInterface(new MercuryDriverInterface());
        Thread th = new Thread(new LogsArchivator("driver" + File.separator + "mercury" + id + File.separator + "logs"));
        th.setName("MercuryEcrLogsArchivator");
        th.start();
    }

    public Mercury130FImpl(Vector filters) {
        this("0", filters);
    }

    protected void updateSEQ(Request request) {
        request.setSeq(this.seqManager.nextSEQ());
    }

    @Override
    protected Integer[] buildSpeeds() {
        return speeds;
    }

    @Override
    public SerialReader buildReader(SerialPort serialPort, InputStream in) {
        MercuryReaderImpl reader = new MercuryReaderImpl(in, serialPort);
        reader.setLogger(this.logger);
        return reader;
    }

    @Override
    public SerialWriter buildWriter(SerialPort serialPort, OutputStream out) {
        MercuryWriterImpl writer = new MercuryWriterImpl(out);
        writer.setLogger(this.logger);
        return writer;
    }

    @Override
    public boolean detectDevice(SerialReader reader, SerialWriter writer) {
        boolean result = false;
        Logger.logVerbose(this, "\n\ndetectDevice");
        try {
            RequestFiscalReceiptStatus request = new RequestFiscalReceiptStatus();
            Response response = this.requestToResponseIncludeNak(request, reader, writer);
            if (response != null && response.isPacked()) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger.logVerbose(this, "detected = " + result);
        return result;
    }

    public int getOpNumber() {
        return this.opNumber;
    }

    public void setOpNumber(int opNumber) {
        this.opNumber = opNumber;
    }

    public int getPassword() {
        return this.password;
    }

    public void setPassword(int password) {
        this.password = password;
    }

    public void setVerifyEachItem(boolean verifyEachItem) {
        this.verifyEachItem = verifyEachItem;
    }

    private Response requestToResponseIncludeNak(Request request) throws EcrClosedException {
        Response result = null;
        int numberOfRetryes = 10;
        this.updateSEQ(request);
        for (int i = 0; i < numberOfRetryes; ++i) {
            this.log("\nREQUEST: " + request);
            this.write(request.buildRawMessage());
            result = (Response)this.read(1000);
            if (result != null && result.isPacked()) break;
        }
        return result;
    }

    private Response requestToResponseIncludeNak(Request request, SerialReader reader, SerialWriter writer) throws EcrClosedException, IOException {
        Response result = null;
        this.updateSEQ(request);
        int numberOfRetryes = 4;
        for (int i = 0; i < numberOfRetryes; ++i) {
            writer.writetoport(request.buildRawMessage());
            result = (Response)reader.read(1000);
            if (result != null) break;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Response requestToResponse(Request request) throws EcrClosedException {
        Response result;
        boolean paperEnd;
        block11: {
            boolean detectNow;
            MercuryDriverInterface ecrInreface = (MercuryDriverInterface)this.getDriverInterface();
            paperEnd = false;
            result = null;
            do {
                result = this.requestToResponseIncludeNak(request);
                detectNow = false;
                if (result != null) {
                    if (result.isPacked()) {
                        int retry;
                        EnumSet<Status> status = result.getStatus();
                        if (status.contains((Object)Status.PAPER_END)) {
                            paperEnd = true;
                            retry = ecrInreface.paperEnd();
                            if (retry != 1) continue;
                            throw new EcrClosedException();
                        }
                        if (status.contains((Object)Status.GENERAL_ERROR)) {
                            retry = ecrInreface.failedPrint();
                            if (retry == 2) {
                                this.requestToResponse(new ReceiptCancelation());
                                throw new CancelledReceiptException();
                            }
                            if (retry != 1) continue;
                            break block11;
                        }
                        if (!this.verifyEachItem || !(request instanceof FiscalSale)) break block11;
                        this.log("\n>>>>>>> VERIFYING each item");
                        RequestFiscalReceiptStatus req = new RequestFiscalReceiptStatus();
                        Response resp = this.requestToResponseIncludeNak(req);
                        if (resp == null || !resp.isResponseToRequest(req)) break block11;
                        ResponseFiscalReceiptStatus rs = (ResponseFiscalReceiptStatus)resp;
                        if (rs.getNumberOfItems() > this.itemsPrinted) {
                            ++this.itemsPrinted;
                            this.log(">>>>>>> verification SUCSESSFULL");
                            break block11;
                        } else {
                            this.log(">>>>>>> verification FAILED, asking user what to do");
                            int retry2 = ecrInreface.failedPrint();
                            if (retry2 == 2) {
                                this.requestToResponse(new ReceiptCancelation());
                                throw new CancelledReceiptException();
                            }
                            if (retry2 != 1) {
                                // empty if block
                            }
                        }
                        break block11;
                    }
                    detectNow = true;
                    continue;
                }
                detectNow = true;
            } while (!detectNow || !this.detect());
            throw new EcrClosedException();
        }
        if (paperEnd) {
            this.requestToResponse(new ReceiptCancelation());
            throw new PaperEndException();
        }
        return result;
    }

    protected void openFiscalReceipt() throws EcrClosedException {
        block2: {
            Response response;
            block3: {
                while (true) {
                    this.clearReader();
                    OpenFiscalReceipt request = new OpenFiscalReceipt(this.getOpNumber(), this.getPassword());
                    response = this.requestToResponseIncludeNak(request);
                    if (response != null && response.isNak()) continue;
                    if (response == null || !response.isResponseToRequest(request)) break block2;
                    EnumSet<Status> status = response.getStatus();
                    if (!status.contains((Object)Status.GENERAL_ERROR) || !status.contains((Object)Status.COMMAND_EXECUTION_IS_NOT_PERMITTED)) break block3;
                    if (status.contains((Object)Status.OPEN_FISCAL_RECEIPT)) {
                        this.closeFiscalReceipt();
                        continue;
                    }
                    if (!status.contains((Object)Status.OPEN_NON_FISCAL_RECEIPT)) break;
                    this.closeNonFiscalReceipt();
                }
                throw new RuntimeException();
            }
            ResponseOpenFiscalReceipt rrr = (ResponseOpenFiscalReceipt)response;
            ((MercuryLogger)this.logger).setIdReceipt(rrr.getId());
        }
    }

    protected void closeFiscalReceipt() throws EcrClosedException {
        this.clearReader();
        RequestFiscalReceiptStatus request = new RequestFiscalReceiptStatus();
        Response response = this.requestToResponse(request);
        if (response != null) {
            if (response.isResponseToRequest(request)) {
                ResponseFiscalReceiptStatus receiptStatus = (ResponseFiscalReceiptStatus)response;
                if (receiptStatus.isReceiptOpened()) {
                    CloseFiscalReceipt requestCloseFiscalReceipt;
                    Response responseToClose;
                    double total = receiptStatus.getTotal();
                    double paid = receiptStatus.getPaid();
                    if (total == 0.0 || total > paid) {
                        Payment requestPaymentAll = new Payment();
                        this.requestToResponse(requestPaymentAll);
                    }
                    if ((responseToClose = this.requestToResponse(requestCloseFiscalReceipt = new CloseFiscalReceipt())) != null && responseToClose.getStatus().contains((Object)Status.OPEN_FISCAL_RECEIPT)) {
                        this.clearReader();
                        this.closeFiscalReceipt();
                    }
                }
            } else {
                this.clearReader();
                this.closeFiscalReceipt();
            }
        }
    }

    protected void openNonFiscalReceipt() throws EcrClosedException {
        block4: {
            OpenNonFiscalReceipt request;
            Response response;
            this.clearReader();
            while ((response = this.requestToResponseIncludeNak(request = new OpenNonFiscalReceipt())) != null && response.isResponseToRequest(request)) {
                EnumSet<Status> status = response.getStatus();
                if (status.contains((Object)Status.GENERAL_ERROR) && status.contains((Object)Status.COMMAND_EXECUTION_IS_NOT_PERMITTED)) {
                    if (status.contains((Object)Status.OPEN_FISCAL_RECEIPT)) {
                        this.closeFiscalReceipt();
                        continue;
                    }
                    if (status.contains((Object)Status.OPEN_NON_FISCAL_RECEIPT)) {
                        this.closeNonFiscalReceipt();
                        continue;
                    }
                    throw new RuntimeException();
                }
                ResponseOpenNonFiscalReceipt rrr = (ResponseOpenNonFiscalReceipt)response;
                ((MercuryLogger)this.logger).setIdReceipt(rrr.getId());
                break block4;
            }
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Deschiderea bonului fiscal nu a reusit!", LangRoAll.eroare);
        }
    }

    protected void closeNonFiscalReceipt() throws EcrClosedException {
        this.clearReader();
        this.requestToResponseIncludeNak(new CloseNonFiscalReceipt());
    }

    protected void cancelFiscalReceipt() throws EcrClosedException {
        RequestFiscalReceiptStatus request = new RequestFiscalReceiptStatus();
        Response response = this.requestToResponse(request);
        if (response != null && response.isResponseToRequest(request)) {
            ResponseFiscalReceiptStatus receiptStatus = (ResponseFiscalReceiptStatus)response;
            double total = receiptStatus.getTotal();
            double paid = receiptStatus.getPaid();
            if (receiptStatus.isReceiptOpened()) {
                if (receiptStatus.getNumberOfItems() > 0) {
                    this.requestToResponseIncludeNak(new ReceiptCancelation());
                } else if (receiptStatus.getStatus().contains((Object)Status.OPEN_FISCAL_RECEIPT)) {
                    this.requestToResponseIncludeNak(new CloseFiscalReceipt());
                } else if (receiptStatus.getStatus().contains((Object)Status.OPEN_NON_FISCAL_RECEIPT)) {
                    this.requestToResponseIncludeNak(new CloseNonFiscalReceipt());
                }
            }
        }
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    public void setLicenseRequired(boolean licenseRequired) {
        this.licenseRequired = licenseRequired;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Override
    public String getDriverName() {
        return "Mercury Ecr Printing Thread";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void newReceipt(EcrReceipt receipt) throws EcrClosedException {
        Date startDate = new Date();
        try {
            this.logger.clearLogs();
            this.log("\n\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> NEW BON start <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<" + receipt);
            if (this.isLicenseRequired() && !LicenseVerifier.isLicensed(this.getLicense(), 88)) {
                MercuryDriverInterface ecrInreface = (MercuryDriverInterface)this.getDriverInterface();
                ecrInreface.noLicense();
                return;
            }
            if (receipt == null) {
                return;
            }
            if (receipt instanceof MercuryFiscalReceiptImpl) {
                try {
                    this.processReceipt((MercuryFiscalReceiptImpl)receipt);
                }
                catch (PaperEndException e) {
                    this.processReceipt((MercuryFiscalReceiptImpl)receipt);
                }
            } else if (receipt instanceof MercuryNonFiscalReceipt) {
                this.processReceipt((MercuryNonFiscalReceipt)receipt);
            } else if (receipt instanceof MercuryReport) {
                this.removeReceipt(receipt);
                this.requestToResponse(new DailyReport(((MercuryReport)receipt).getType()));
            } else {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Selling " + receipt.getClass() + " is not Implemented", "Error");
            }
        }
        finally {
            ((MercuryLogger)this.logger).saveLogs(startDate);
        }
        this.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> NEW BON stop <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
    }

    private void processReceipt(MercuryNonFiscalReceipt receipt) throws EcrClosedException {
        Vector sales = receipt.getSales();
        if (sales.size() <= 0) {
            return;
        }
        this.openNonFiscalReceipt();
        for (NonFiscalText sale : sales) {
            Response response = this.requestToResponse(sale);
            if (response != null) continue;
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Cant print text", "Error");
        }
        this.closeNonFiscalReceipt();
    }

    private void processReceipt(MercuryFiscalReceiptImpl receipt) throws EcrClosedException {
        Vector sales = receipt.getSalesAndComments();
        Vector<Payment> payments = receipt.getPayments();
        Vector subtotals = receipt.getSubtotals();
        if (sales.size() == 0) {
            return;
        }
        if (receipt.isPrinting()) {
            this.cancelFiscalReceipt();
        } else {
            receipt.setPrinting(true);
            this.updatePersistentList();
        }
        this.openFiscalReceipt();
        this.processSales(sales);
        this.processSubtotals(subtotals);
        this.processPayments(payments);
        this.closeFiscalReceipt();
    }

    private void processSales(Vector sales) throws EcrClosedException {
        this.itemsPrinted = 0;
        for (int i = 0; i < sales.size(); ++i) {
            Response response;
            Request request = (Request)sales.get(i);
            if (request instanceof FiscalSale) {
                response = this.requestToResponse(request);
                if (response != null) continue;
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Cant print text", "Error");
                continue;
            }
            response = this.requestToResponse(request);
            if (response != null) continue;
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Cant print text", "Error");
        }
    }

    private void processSubtotals(Vector subtotals) throws EcrClosedException {
        for (int i = 0; i < subtotals.size(); ++i) {
            Request request = (Request)subtotals.get(i);
            Response response = this.requestToResponse(request);
            if (response != null) continue;
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Cant print text", "Error");
        }
    }

    private void processPayments(Vector<Payment> payments) throws EcrClosedException {
        for (int i = 0; i < payments.size(); ++i) {
            Payment p = payments.get(i);
            Response response = this.requestToResponse(p);
        }
    }

    public static void main(String[] args) {
        Logger.getInstance(6, "out.log");
        String prop = "/dev/ttyS.,/dev/ttyUSB.,COM.";
        prop = prop.replace("/dev/", "");
        Vector filters = Utils.splitString(prop, ',');
        final Mercury130FImpl ecr = new Mercury130FImpl(filters);
        ecr.setLicenseRequired(false);
        ecr.setVerifyEachItem(false);
        ecr.start();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JButton fiscal = new JButton("fiscal bon");
        fiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MercuryFiscalReceiptImpl receipt = new MercuryFiscalReceiptImpl(-1);
                for (int i = 0; i < 3; ++i) {
                    receipt.addSale(new FiscalSale(LangRoAll.produs + (i + 1), 1.0, 5.3f));
                }
                receipt.addPayment(new Payment());
                ecr.addEcrReceipt(receipt);
            }
        });
        JButton nonFiscal = new JButton("non fiscal");
        nonFiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MercuryNonFiscalReceipt receipt = new MercuryNonFiscalReceipt();
                receipt.addSale("test 1");
                receipt.addSale("test 2");
                receipt.addSale("test 3");
                receipt.addSale("test 4");
                receipt.addSale("test 5");
                ecr.addEcrReceipt(receipt);
            }
        });
        JButton stop = new JButton("stop");
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ecr.stop();
            }
        });
        JPanel panel = new JPanel();
        panel.add(fiscal);
        panel.add(nonFiscal);
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

