/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.io.IOException;
import java.io.InputStream;
import purejavacomm.SerialPort;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.SerialReaderImplSingleThread;
import ro.atreides.ecr.mercury.nativeImpl.MercuryUtils;
import ro.atreides.ecr.mercury.nativeImpl.Response;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class MercuryReaderImpl
extends SerialReaderImplSingleThread {
    public static final int IDLE = 0;
    public static final int SEARCHING_FOR_TERMINATOR = 1;
    private int state = 0;
    protected int currentPosition = 0;
    protected byte[] currentMessage = new byte[8192];

    public MercuryReaderImpl(InputStream in, SerialPort serial) {
        super(in, serial);
    }

    @Override
    protected void dataArrived(byte[] buffer, int offset, int len) {
        int i = offset;
        while (i < len) {
            switch (this.state) {
                case 0: {
                    byte b;
                    this.currentPosition = 0;
                    while (i < len) {
                        b = buffer[i];
                        if (b == 22) {
                            this.log(">>>>>>>> adding to queue: \t\tSYN");
                            this.addMessage(Response.buildSyn());
                            break;
                        }
                        if (b == 21) {
                            this.log(">>>>>>>> adding to queue: \t\tNACK");
                            this.addMessage(Response.buildNak());
                            break;
                        }
                        if (b == 1) {
                            this.state = 1;
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    break;
                }
                case 1: {
                    byte b;
                    while (i < len) {
                        b = buffer[i];
                        if (b == 3) {
                            this.state = 0;
                            boolean correct = MercuryUtils.correctChecksum(this.currentMessage, 0, this.currentPosition);
                            if (correct) {
                                byte[] tmp = new byte[this.currentPosition - 6];
                                System.arraycopy(this.currentMessage, 1, tmp, 0, tmp.length);
                                Response r = Response.buildPacked(tmp);
                                this.log(">>>>>>>> adding to queue: \t" + (Object)((Object)r.getCMD()) + " response : " + BinaryUtils.toHexString(tmp));
                                this.addMessage(r);
                                break;
                            }
                            this.log("CRC IN MESSAGE IS INCORRECT!!!");
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "CRC IN MESSAGE IS INCORRECT!!!", "Error");
                            break;
                        }
                        this.currentMessage[this.currentPosition] = b;
                        ++this.currentPosition;
                        ++i;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public Response read(int timeout) throws IOException {
        Response r = (Response)super.read(timeout);
        if (r != null) {
            this.log(">>>>>>>> reading from queue: \t" + r);
            if (r.isSyn()) {
                int timeChunk = 1000;
                while ((r = (Response)super.read(timeChunk)) != null) {
                    this.log(">>>>>>>> reading from queue: \t" + r);
                    if (r.isSyn()) continue;
                }
            }
        }
        if (r == null) {
            this.log(">>>>>>> AM CITIT NULL <<<<<<<<");
        }
        return r;
    }

    @Override
    public void clearReader() {
        super.clearReader();
        this.state = 0;
    }
}

