/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.io.File;
import java.util.Date;
import java.util.EnumSet;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.Status;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;

public class MercuryUtils {
    public static final byte BIT7_MASK = -128;
    public static final byte BIT6_MASK = 64;
    public static final byte BIT5_MASK = 32;
    public static final byte BIT4_MASK = 16;
    public static final byte BIT3_MASK = 8;
    public static final byte BIT2_MASK = 4;
    public static final byte BIT1_MASK = 2;
    public static final byte BIT0_MASK = 1;

    public static void sleep(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static boolean correctChecksum(byte[] bytes, int offset, int len) {
        int currentCRC = 0;
        len -= 4;
        for (int i = offset; i < len; ++i) {
            byte aByte = bytes[i];
            currentCRC += BinaryUtils.unsignedByteToInt(aByte);
        }
        String hex0 = BinaryUtils.secondHexDigitAsString(bytes[len]);
        String hex1 = BinaryUtils.secondHexDigitAsString(bytes[len + 1]);
        String hex2 = BinaryUtils.secondHexDigitAsString(bytes[len + 2]);
        String hex3 = BinaryUtils.secondHexDigitAsString(bytes[len + 3]);
        int crcFromMessage = Integer.parseInt(hex0 + hex1 + hex2 + hex3, 16);
        return crcFromMessage == (currentCRC &= 0xFFFF);
    }

    public static void setChecksum(byte[] bytes, int offset, int crcStartOffset) {
        int currentCRC = 0;
        for (int i = offset; i < crcStartOffset; ++i) {
            byte aByte = bytes[i];
            currentCRC += BinaryUtils.unsignedByteToInt(aByte);
        }
        byte[] crc = BinaryUtils.toBytes((short)(currentCRC &= 0xFFFF));
        byte byte0 = (byte)(BinaryUtils.firstHexDigitAsByte(crc[0]) + 48);
        byte byte1 = (byte)(BinaryUtils.secondHexDigitAsByte(crc[0]) + 48);
        byte byte2 = (byte)(BinaryUtils.firstHexDigitAsByte(crc[1]) + 48);
        byte byte3 = (byte)(BinaryUtils.secondHexDigitAsByte(crc[1]) + 48);
        bytes[crcStartOffset] = byte0;
        bytes[crcStartOffset + 1] = byte1;
        bytes[crcStartOffset + 2] = byte2;
        bytes[crcStartOffset + 3] = byte3;
    }

    public static EnumSet<Status> parseStatus(byte[] message) {
        EnumSet<Status> result = null;
        try {
            if (message == null) {
                return null;
            }
            result = EnumSet.of(Status.NONE);
            byte byte0 = message[message.length - 6];
            byte byte1 = message[message.length - 5];
            byte byte2 = message[message.length - 4];
            byte byte3 = message[message.length - 3];
            byte byte4 = message[message.length - 2];
            byte byte5 = message[message.length - 1];
            byte[] statusBytes = new byte[]{byte0, byte1, byte2, byte3, byte4, byte5};
            MercuryUtils.setStatusesForByte(byte0, result, null, null, Status.GENERAL_ERROR, Status.PRINTING_MECHANISM_FAILURE, null, Status.TIME_DATE_IS_NOT_SET, Status.INVALID_COMMAND_CODE, Status.SYNTAX_ERROR);
            MercuryUtils.setStatusesForByte(byte1, result, null, null, Status.THREE_CONSECUTIVE_WRONG_PASSWORDS, null, null, Status.RAM_RESET, Status.COMMAND_EXECUTION_IS_NOT_PERMITTED, Status.OVERFLOW);
            MercuryUtils.setStatusesForByte(byte2, result, null, null, Status.OPEN_NON_FISCAL_RECEIPT, Status.ELECTRONIC_JOURNAL_OVERFLOW, Status.OPEN_FISCAL_RECEIPT, null, null, Status.PAPER_END);
            MercuryUtils.setStatusesForByte(byte3, result, null, null, null, null, null, null, null, null);
            MercuryUtils.setStatusesForByte(byte4, result, null, null, Status.GENERAL_FISCAL_FM_MEMORY_ERROR, Status.FULL_FISCAL_MEMORY, Status.LESS_THAN_60_FREE_RECORDS_IN_FM, Status.ERROR_RECORD_IN_FM, null, Status.ERROR_WHEN_RECORDING_IN_FM);
            MercuryUtils.setStatusesForByte(byte5, result, null, null, Status.ECR_IDENTIFICATION_NUMBER_IS_RECORDED_IN_FM, Status.VAT_RATES_ASSIGNED_AT_LEAST_ONCE, Status.ECR_IS_FISCALIZED, null, null, Status.THE_FM_SET_IN_READONLY_MODE);
            if (result.size() > 1) {
                result.remove((Object)Status.NONE);
            }
        }
        catch (Throwable e) {
            result = null;
            e.printStackTrace();
            return null;
        }
        return result;
    }

    private static void setStatusesForByte(byte b, EnumSet<Status> set, Status status7, Status status6, Status status5, Status status4, Status status3, Status status2, Status status1, Status status0) {
        MercuryUtils.setStatusForBitMask(b, (byte)1, status0, set);
        MercuryUtils.setStatusForBitMask(b, (byte)2, status1, set);
        MercuryUtils.setStatusForBitMask(b, (byte)4, status2, set);
        MercuryUtils.setStatusForBitMask(b, (byte)8, status3, set);
        MercuryUtils.setStatusForBitMask(b, (byte)16, status4, set);
        MercuryUtils.setStatusForBitMask(b, (byte)32, status5, set);
        MercuryUtils.setStatusForBitMask(b, (byte)64, status6, set);
        MercuryUtils.setStatusForBitMask(b, (byte)-128, status7, set);
    }

    private static void setStatusForBitMask(byte b, byte mask, Status status, EnumSet<Status> set) {
        if (status != null && (b & mask) == mask) {
            set.add(status);
        }
    }

    public static void saveLog(String dir, String idReceipt, Date date, String log) {
        String name = Formatters.currentDateAndTimeForFileSystem.format(date) + "__" + idReceipt + ".log";
        try {
            new File(dir).mkdirs();
            FileUtils.writeTextToFile(dir + File.separator + name, log);
        }
        catch (Exception e) {
            Logger.logWarning(MercuryUtils.getClassName(), e.toString());
        }
    }

    public static String getClassName() {
        return MercuryUtils.class.getName();
    }
}

