/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.bons;

import java.util.Vector;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.ecr.mercury.nativeImpl.requests.FiscalSale;
import ro.atreides.ecr.mercury.nativeImpl.requests.FiscalTextPrint;
import ro.atreides.ecr.mercury.nativeImpl.requests.Payment;
import ro.atreides.ecr.mercury.nativeImpl.requests.Subtotal;

public final class MercuryFiscalReceiptImpl
extends EcrReceipt {
    public static final long serialVersionUID = 100L;
    private Vector salesAndComments = new Vector();
    private Vector<Payment> payments = new Vector();
    private Vector subtotals = new Vector();
    private boolean printing = false;

    public MercuryFiscalReceiptImpl(int idOrder) {
        this.idOrder = idOrder;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public void setPrinting(boolean printing) {
        this.printing = printing;
    }

    public void addSale(FiscalSale sale) {
        if (sale != null) {
            this.salesAndComments.add(sale);
        }
    }

    public void addComment(String text) {
        FiscalTextPrint comment = new FiscalTextPrint(text);
        this.salesAndComments.add(comment);
    }

    public Vector getSalesAndComments() {
        return (Vector)this.salesAndComments.clone();
    }

    public Vector<FiscalTextPrint> getComments() {
        Vector<FiscalTextPrint> result = new Vector<FiscalTextPrint>();
        for (int i = 0; i < this.salesAndComments.size(); ++i) {
            Request request = (Request)this.salesAndComments.get(i);
            if (!(request instanceof FiscalTextPrint)) continue;
            result.add((FiscalTextPrint)request);
        }
        return result;
    }

    public void addPayment(Payment payment) {
        this.payments.add(payment);
    }

    public Vector<Payment> getPayments() {
        return (Vector)this.payments.clone();
    }

    public Vector getSubtotals() {
        return (Vector)this.subtotals.clone();
    }

    public void addSubtotal(double percent) {
        this.subtotals.add(new Subtotal(percent));
    }

    public String toString() {
        return "\nMercuryFiscalReceiptImpl {\n\tsalesAndComments=" + this.salesAndComments + "," + "\n\tpayments=" + this.payments + "\n}";
    }
}

