/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.requests;

import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.utils.Utils;

public final class FiscalSale
extends Request {
    private String name;
    private TaxGroup taxGroup;
    private double price;
    private double quantity;
    private double percent;

    public FiscalSale(String name, double price, double quantity) {
        this(name, price, quantity, null);
    }

    public FiscalSale(String name, double price, double quantity, double percent) {
        this(name, price, quantity, null, percent);
    }

    public FiscalSale(String name, double price, double quantity, TaxGroup taxGroup) {
        this(name, price, quantity, taxGroup, 0.0);
    }

    public FiscalSale(String name, double price, double quantity, TaxGroup taxGroup, double percent) {
        super(CMD_ENUM.SALE_REGISTRATION);
        this.name = name == null ? null : (name.length() > 24 ? name.substring(0, 24) : name);
        this.taxGroup = taxGroup == null ? TaxGroup.A : taxGroup;
        this.price = price;
        this.quantity = quantity;
        this.setPercent(percent);
    }

    public void setPercent(double percent) {
        this.percent = percent == 0.0 ? 0.0 : (percent > 0.0 ? Math.min(percent, (double)99.99f) : Math.max(percent, (double)-99.99f));
    }

    @Override
    protected final byte[] buildDataBytes() {
        String name = this.name == null ? "" : this.name;
        String price = Utils.getString2DecimalsNoTrunc(this.price);
        String quantity = Utils.getString3DecimalsNoTrunc(this.quantity);
        String percent = Utils.getString2DecimalsNoTrunc(this.percent);
        int length = (name.length() > 0 ? 1 + name.length() : 0) + 1 + 1 + price.length() + 1 + quantity.length() + (this.percent == 0.0 ? 0 : 1 + percent.length());
        byte[] result = new byte[length];
        int i = -1;
        if (name.length() > 0) {
            result[++i] = 10;
            BinaryUtils.copyAsciiBytes(name, 0, result, ++i, name.length());
            i += name.length() - 1;
        }
        result[++i] = 9;
        result[++i] = this.taxGroup.getId();
        BinaryUtils.copyAsciiBytes(price, 0, result, ++i, price.length());
        i += price.length() - 1;
        result[++i] = 42;
        BinaryUtils.copyAsciiBytes(quantity, 0, result, ++i, quantity.length());
        i += quantity.length() - 1;
        if (this.percent != 0.0) {
            result[++i] = 44;
            BinaryUtils.copyAsciiBytes(percent, 0, result, ++i, percent.length());
            i += percent.length() - 1;
        }
        return result;
    }

    public String toString() {
        return "\n\t\tFiscalSale { name='" + this.name + '\'' + ", taxGroup=" + (Object)((Object)this.taxGroup) + ", price=" + this.price + ", quantity=" + this.quantity + ", percent=" + this.percent + " }";
    }

    public static enum TaxGroup {
        NON_TAXABLE(' '),
        A('A'),
        B('B'),
        C('C'),
        D('D'),
        E('E'),
        G('G');

        private byte id;

        private TaxGroup(char id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }
    }
}

