/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus;

import java.util.Properties;
import java.util.Vector;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.optimus.XmlHandler;
import ro.atreides.ecr.optimus.nativeImpl.Bon;
import ro.atreides.ecr.optimus.nativeImpl.MG1200Impl;
import ro.atreides.ecr.optimus.nativeImpl.Payment;
import ro.atreides.ecr.optimus.nativeImpl.Produs;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private boolean forceTotal;
    private boolean discountGlobal;
    private boolean forceTotalAt2Decimals;
    private boolean errorNotifications;
    private boolean verifyEachItem;
    private MG1200Impl driver;
    private String ecrLicenseCode;
    private Vector filters = new Vector();

    @Override
    public void buildConfiguration(Properties conf) throws RuntimeException {
        super.buildConfiguration(conf);
        this.forceTotal = Boolean.parseBoolean(conf.getProperty("forceTotal", "false"));
        this.errorNotifications = Boolean.parseBoolean(conf.getProperty("errorNotifications", "true"));
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        String prop = conf.getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        prop = prop.replace("/dev/", "");
        this.filters = Utils.splitString(prop, ',');
        this.ecrLicenseCode = conf.getProperty("ecrLicenceCode", "772274515e9e02e8f1aaf17f7b3aac5c56cd85");
    }

    @Override
    public void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER: " + this.driver);
        if (this.driver != null) {
            this.driver.stop();
        }
    }

    @Override
    public void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER: " + this.driver);
        if (this.driver != null) {
            this.driver.stop();
        }
        this.driver = new MG1200Impl("0", this.filters);
        this.driver.setNotifications(this.errorNotifications);
        this.driver.start();
    }

    @Override
    public void processXml(String fileName) {
        try {
            XmlHandler handler = new XmlHandler();
            Utils.importXml((DefaultHandler)handler, fileName);
            this.processBon(handler.getReceipt());
        }
        catch (Exception e) {
            Logger.logError((Object)this, e);
            e.printStackTrace();
        }
    }

    public void processBon(EcrReceipt b) {
        if (this.driver != null) {
            this.driver.addEcrReceipt(b);
        }
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        Bon b = new Bon(idOrder);
        double totalFaraReducere = 0.0;
        double totalReducere = 0.0;
        double totalCuRotunjire = 0.0;
        for (EcrSale sale : sales) {
            String name = sale.getProduct();
            double nrPortii = sale.getQuantity();
            double ppu = sale.getPpuDupaDiscount();
            totalFaraReducere += sale.getPpuOriginal() * sale.getQuantity();
            totalReducere += (sale.getPpuOriginal() - sale.getPpuDupaDiscount()) * sale.getQuantity();
            totalCuRotunjire += FloatUtils.roundDoubleUp(nrPortii * ppu, 2);
            String codTva = sale.getCodTva();
            char c1 = 'A';
            if (codTva.length() > 0) {
                c1 = codTva.charAt(0);
            }
            Produs p = new Produs(name, ppu, nrPortii, c1);
            b.add(p);
            Logger.logDebug(this, "Produs: " + p.toString());
        }
        if (this.discountGlobal && totalReducere != 0.0) {
            double procent = totalReducere * 100.0 / totalFaraReducere;
            System.out.println("subtotal procent = " + procent);
            b.setAdaosTotal(procent);
            Logger.logDebug(this, "subtotal procent = " + procent);
        }
        for (Object comment : comments) {
            String com = (String)comment;
            b.add(com);
        }
        Payment cashPayment = null;
        double totalPlatit = 0.0;
        for (EcrPlata plata : plati) {
            double suma = plata.getSuma();
            String tip = plata.getEcrMapping();
            Payment.TYPE type = Payment.TYPE.valueOf(tip);
            Payment p = new Payment(suma, type);
            if (type == Payment.TYPE.CASH) {
                cashPayment = p;
            }
            b.addPayment(p);
            Logger.logDebug(this, "Payment: " + tip + " : " + suma);
            totalPlatit += FloatUtils.roundDoubleUp(suma, 2);
        }
        if (total > totalPlatit) {
            double diff = FloatUtils.roundDoubleUp(totalCuRotunjire - totalPlatit, 2);
            Logger.logWarning(this, "Diferenta de plata: " + diff + " . Adaugam diferenta pe cash !!");
            if (cashPayment != null) {
                cashPayment.setValue(cashPayment.getValue() + diff);
            } else {
                Payment p = new Payment(diff, Payment.TYPE.CASH);
                b.addPayment(p);
            }
        }
        this.processBon(b);
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.driver.deleteNonPrintedBons(this.inter);
        }
    }

    @Override
    public int getNoOfBonsToPrint() {
        if (this.driver != null) {
            return this.driver.getNoOfBonsToPrint();
        }
        return 0;
    }
}

