/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus;

import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.optimus.nativeImpl.Payment;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class TangoDrv
extends AbstractCashRegister {
    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "";
        for (EcrSale sale : sales) {
            double nrPortii = sale.getQuantity();
            double ppu = sale.getPpuDupaDiscount();
            double value = nrPortii * ppu;
            String priceString = this.getPrice(this.onlineDecimalPlaces, ppu);
            String prodName = this.getString(18, sale.getProduct());
            String portiiString = this.getPrice(3, nrPortii);
            String valueString = this.getPrice(this.onlineDecimalPlaces, value);
            String codTva = sale.getCodTva();
            char c1 = 'A';
            if (codTva.length() > 0) {
                c1 = codTva.charAt(0);
            }
            String commandText = "q;1;" + prodName + ";" + c1 + ";" + priceString + ";" + portiiString + ";" + valueString + ";;";
            items = items + commandText;
            items = items + "\n";
        }
        String totalString = this.getPrice(this.onlineDecimalPlaces, total);
        items = items + "q;4;" + totalString + this.buildTotal(plati);
        this.pt.addToQueue(items);
    }

    private String buildTotal(Vector payments) {
        double cash = 0.0;
        double check = 0.0;
        double creditcard = 0.0;
        double cupon = 0.0;
        double credit = 0.0;
        if (payments != null && payments.size() > 0) {
            for (int i = 0; i < payments.size(); ++i) {
                EcrPlata plata = (EcrPlata)payments.get(i);
                String ecrMap = plata.getEcrMapping();
                double value = plata.getSuma();
                Payment.TYPE type = null;
                try {
                    type = Payment.TYPE.valueOf(ecrMap);
                    if (type == Payment.TYPE.CASH) {
                        cash += value;
                        continue;
                    }
                    if (type == Payment.TYPE.CHECK) {
                        check += value;
                        continue;
                    }
                    if (type == Payment.TYPE.CC) {
                        creditcard += value;
                        continue;
                    }
                    if (type == Payment.TYPE.COUPON) {
                        cupon += value;
                        continue;
                    }
                    if (type != Payment.TYPE.CARD) continue;
                    credit += value;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Logger.logException(this, (Exception)e);
                }
            }
        }
        String s = ";" + this.getPrice(this.onlineDecimalPlaces, cash) + ";" + this.getPrice(this.onlineDecimalPlaces, check) + ";" + this.getPrice(this.onlineDecimalPlaces, creditcard) + ";" + this.getPrice(this.onlineDecimalPlaces, cupon) + ";" + this.getPrice(this.onlineDecimalPlaces, credit) + ";";
        return s;
    }

    private String getString(int totalDigits, String toConvert) {
        if (toConvert.length() > totalDigits) {
            return toConvert.substring(0, totalDigits);
        }
        if (toConvert.length() < totalDigits) {
            String result = toConvert;
            return result;
        }
        return toConvert;
    }

    private String getPrice(int decimalPlaces, double toConvert) {
        if (Utils.isValueZero(toConvert)) {
            return "";
        }
        long correctForm = FloatUtils.convertToLong(toConvert, decimalPlaces);
        return "" + correctForm;
    }

    @Override
    public void forceTotal() {
    }
}

