/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import org.mortbay.jetty.Server;
import org.mortbay.util.InetAddrPort;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.optimus.Generic;
import ro.atreides.ecr.optimus.nativeImpl.Bon;
import ro.atreides.ecr.optimus.nativeImpl.Produs;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.web.WebServerInterface;

public class Test {
    public static void testurl() throws Exception {
        String inputLine;
        Logger.getInstance(6, "protocol.log");
        EcrLogic logic = EcrLogic.getInstance(new String[]{"-ecrType", "optimus.Generic"}, false, null);
        final Server s = new Server();
        s.addListener(new InetAddrPort(8080));
        logic.getEcr().setWebserver(new WebServerInterface(){

            @Override
            public Object prepareWebServer(int port) {
                return s;
            }
        });
        s.start();
        String address = "http://localhost:8080/ecrPrint/all?xml=";
        String xml = FileUtils.readFileToString("test.xml");
        System.out.println("xml = " + xml);
        String tmp = URLEncoder.encode(xml, "UTF-8");
        URL url = new URL(address + tmp);
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((inputLine = in.readLine()) != null) {
            System.out.println(inputLine);
        }
        in.close();
    }

    public static void test() {
        Logger.getInstance(6, "protocol.log");
        EcrLogic logic = EcrLogic.getInstance(new String[]{"-ecrType", "optimus.Generic"}, false, null);
        Random r = new Random();
        String[] names = new String[]{"Cola", "Pepsi", "Paine", "Cascaval"};
        int max_products = 3;
        int nr_of_bons = 100;
        double total = 0.0;
        for (int i = 0; i < nr_of_bons; ++i) {
            Bon b = new Bon();
            int n = r.nextInt(max_products) + 1;
            for (int j = 0; j < n; ++j) {
                String name = names[r.nextInt(names.length)];
                double price = (float)(r.nextInt(20) + 1) + r.nextFloat();
                double quantity = r.nextInt(10) + 1;
                Produs p = new Produs(name, price, quantity, 'A');
                b.add(p);
                total += p.getPrice() * p.getQuantity();
            }
            ((Generic)logic.getEcr()).processBon(b);
        }
        System.out.println("total = " + total);
    }

    public static void main(String[] args) throws Exception {
    }
}

