/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus.nativeImpl;

import java.util.Arrays;
import java.util.Vector;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.optimus.nativeImpl.Checksum16;
import ro.atreides.ecr.optimus.nativeImpl.Message;
import ro.atreides.ecr.optimus.nativeImpl.Payment;
import ro.atreides.ecr.optimus.nativeImpl.Types;
import ro.atreides.utils.Utils;

public class MessageFactory {
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte NAK = 21;
    public static final byte ACK = 6;
    public static final byte ERROR = 64;
    public static byte[] START = new byte[]{2, 83, 113, 49, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 3, 48, 48, 54, 68};
    private Checksum16 checksum = new Checksum16();

    public byte[] buildSale(String name, double price, double quantity, char codTva, double value) {
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 49;
        if (name.length() > 18) {
            name = name.substring(0, 18);
        }
        System.arraycopy(name.getBytes(), 0, data, 4, name.length());
        data[22] = (byte)codTva;
        String p = Utils.getString2DecimalsNoTrunc(price).replace(".", "");
        System.arraycopy(p.getBytes(), 0, data, 33 - p.length(), p.length());
        String q = Utils.getString3DecimalsNoTrunc(quantity).replace(".", "");
        System.arraycopy(q.getBytes(), 0, data, 43 - q.length(), q.length());
        String valueS = Utils.getString2DecimalsNoTrunc(value).replace(".", "");
        System.arraycopy(valueS.getBytes(), 0, data, 53 - valueS.length(), valueS.length());
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public byte[] buildTotal(double total, Vector payments) {
        double cash = 0.0;
        double check = 0.0;
        double creditcard = 0.0;
        double cupon = 0.0;
        double credit = 0.0;
        if (payments != null && payments.size() > 0) {
            for (int i = 0; i < payments.size(); ++i) {
                Payment p = (Payment)payments.get(i);
                Payment.TYPE type = p.getType();
                double value = p.getValue();
                if (type == Payment.TYPE.CASH) {
                    cash += value;
                    continue;
                }
                if (type == Payment.TYPE.CHECK) {
                    check += value;
                    continue;
                }
                if (type == Payment.TYPE.CC) {
                    creditcard += value;
                    continue;
                }
                if (type == Payment.TYPE.COUPON) {
                    cupon += value;
                    continue;
                }
                if (type != Payment.TYPE.CARD) continue;
                credit += value;
            }
        }
        return this.buildTotal(total, cash, check, creditcard, cupon, credit);
    }

    public byte[] buildTotal(double total, double cash, double check, double creditcard, double cupon, double credit) {
        if (total > cash + check + creditcard + cupon + credit) {
            cash += total - cash - check - creditcard - cupon - credit;
        }
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 52;
        String t = Utils.getString2DecimalsNoTrunc(total).replace(".", "");
        System.arraycopy(t.getBytes(), 0, data, 14 - t.length(), t.length());
        t = Utils.getString2DecimalsNoTrunc(cash).replace(".", "");
        System.arraycopy(t.getBytes(), 0, data, 24 - t.length(), t.length());
        if (check > 0.0) {
            t = Utils.getString2DecimalsNoTrunc(check).replace(".", "");
            System.arraycopy(t.getBytes(), 0, data, 34 - t.length(), t.length());
        }
        if (creditcard > 0.0) {
            t = Utils.getString2DecimalsNoTrunc(creditcard).replace(".", "");
            System.arraycopy(t.getBytes(), 0, data, 44 - t.length(), t.length());
        }
        if (cupon > 0.0) {
            t = Utils.getString2DecimalsNoTrunc(cupon).replace(".", "");
            System.arraycopy(t.getBytes(), 0, data, 54 - t.length(), t.length());
        }
        if (credit > 0.0) {
            t = Utils.getString2DecimalsNoTrunc(credit).replace(".", "");
            System.arraycopy(t.getBytes(), 0, data, 64 - t.length(), t.length());
        }
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public byte[] buildAnulare() {
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 51;
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public byte[] buildAdaos(double p) {
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 57;
        String t = Utils.getString2DecimalsNoTrunc(p).replace(".", "");
        System.arraycopy(t.getBytes(), 0, data, 14 - t.length(), t.length());
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public byte[] buildAdaosTotal(double p) {
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 65;
        String t = Utils.getString2DecimalsNoTrunc(p).replace(".", "");
        System.arraycopy(t.getBytes(), 0, data, 14 - t.length(), t.length());
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public byte[] buildDiscount(double p) {
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 53;
        String t = Utils.getString2DecimalsNoTrunc(p).replace(".", "");
        System.arraycopy(t.getBytes(), 0, data, 14 - t.length(), t.length());
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public byte[] buildDiscountTotal(double p) {
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 54;
        String t = Utils.getString2DecimalsNoTrunc(p).replace(".", "");
        System.arraycopy(t.getBytes(), 0, data, 14 - t.length(), t.length());
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public byte[] buildComment(String c) {
        byte[] data = new byte[69];
        Arrays.fill(data, (byte)32);
        data[0] = 2;
        data[1] = 68;
        data[2] = 113;
        data[3] = 69;
        if (c.length() > 18) {
            c = c.substring(0, 18);
        }
        System.arraycopy(c.getBytes(), 0, data, 4, c.length());
        data[data.length - 5] = 3;
        this.setCrc(data);
        return data;
    }

    public void setCrc(byte[] b) {
        this.checksum.reset();
        this.checksum.update(b, 1, b.length - 3);
        byte[] crc = this.checksum.getBytes();
        b[b.length - 4] = (byte)BinaryUtils.firstHexDigitAsString(crc[0]).charAt(0);
        b[b.length - 3] = (byte)BinaryUtils.secondHexDigitAsString(crc[0]).charAt(0);
        b[b.length - 2] = (byte)BinaryUtils.firstHexDigitAsString(crc[1]).charAt(0);
        b[b.length - 1] = (byte)BinaryUtils.secondHexDigitAsString(crc[1]).charAt(0);
    }

    public static Message buildAck() {
        Message m = new Message();
        m.setType(Types.ACK);
        return m;
    }

    public static Message buildNack() {
        Message m = new Message();
        m.setType(Types.NACK);
        return m;
    }

    public static Message buildTransmisionEnd() {
        Message m = new Message();
        m.setType(Types.END);
        return m;
    }

    public static Message buildError() {
        Message m = new Message();
        m.setType(Types.ERROR);
        return m;
    }

    public static Message buildEnquire() {
        Message m = new Message();
        m.setType(Types.ENQUIRE);
        return m;
    }

    public static Message buildPacked(byte[] data) {
        Message m = new Message();
        m.setType(Types.PACKED);
        m.setData(data);
        return m;
    }
}

