/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus.nativeImpl;

import java.io.IOException;
import java.io.InputStream;
import purejavacomm.SerialPort;
import ro.atreides.ecr.SerialReaderImplSingleThread;
import ro.atreides.ecr.optimus.nativeImpl.Message;
import ro.atreides.ecr.optimus.nativeImpl.MessageFactory;

public class Reader
extends SerialReaderImplSingleThread {
    private static final int IDLE = 0;
    private static final int SEARCHING_END = 1;
    private static final int SEARCHING_CRC1 = 2;
    private static final int SEARCHING_CRC2 = 3;
    private static final int SEARCHING_CRC3 = 4;
    private static final int SEARCHING_CRC4 = 5;
    int state = 0;
    private byte[] buffer = new byte[1024];
    private int index = 0;

    public Reader(InputStream input, SerialPort serial) {
        super(input, serial);
    }

    @Override
    protected void dataArrived(byte[] data, int offset, int len) {
        block16: for (int i = offset; i < len; ++i) {
            byte b = data[i];
            switch (this.state) {
                case 0: {
                    switch (b) {
                        case 6: {
                            this.addMessage(MessageFactory.buildAck());
                            break;
                        }
                        case 21: {
                            this.addMessage(MessageFactory.buildNack());
                            break;
                        }
                        case 4: {
                            this.addMessage(MessageFactory.buildTransmisionEnd());
                            break;
                        }
                        case 64: {
                            this.addMessage(MessageFactory.buildError());
                            break;
                        }
                        case 5: {
                            this.addMessage(MessageFactory.buildEnquire());
                            break;
                        }
                        case 2: {
                            this.buffer[this.index++] = b;
                            this.state = 1;
                        }
                    }
                    continue block16;
                }
                case 1: {
                    this.buffer[this.index++] = b;
                    if (b != 3) continue block16;
                    this.state = 2;
                    continue block16;
                }
                case 2: {
                    this.buffer[this.index++] = b;
                    this.state = 3;
                    continue block16;
                }
                case 3: {
                    this.buffer[this.index++] = b;
                    this.state = 4;
                    continue block16;
                }
                case 4: {
                    this.buffer[this.index++] = b;
                    this.state = 5;
                    continue block16;
                }
                case 5: {
                    this.buffer[this.index++] = b;
                    byte[] tmp = new byte[this.index];
                    System.arraycopy(this.buffer, 0, tmp, 0, this.index);
                    this.addMessage(MessageFactory.buildPacked(tmp));
                    this.state = 0;
                    this.index = 0;
                }
            }
        }
    }

    @Override
    public Message read(int timeout) throws IOException {
        Message m = (Message)super.read(timeout);
        if (m == null) {
            m = new Message();
        }
        return m;
    }
}

