/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.orgtech;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private void regserv() throws RuntimeException, IOException {
        String cmd = this.systemPrefix + "vsu.exe /RegServ";
        Process onlineProcess = Runtime.getRuntime().exec(cmd, null, new File(this.onlineDirectory));
        try {
            if (onlineProcess.waitFor() != 0) {
                throw new RuntimeException("Could not register server");
            }
        }
        catch (InterruptedException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void unload() throws RuntimeException, IOException {
        String cmd = this.systemPrefix + "vsu.exe /unload";
        Process onlineProcess = Runtime.getRuntime().exec(cmd, null, new File(this.onlineDirectory));
        try {
            if (onlineProcess.waitFor() != 0) {
                throw new RuntimeException("Could not unload server");
            }
        }
        catch (InterruptedException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void connect() throws RuntimeException, IOException {
        String cmd = this.systemPrefix + "vsu.exe /connect /n1 /u1";
        Process onlineProcess = Runtime.getRuntime().exec(cmd, null, new File(this.onlineDirectory));
        try {
            onlineProcess.waitFor();
            if (onlineProcess.waitFor() != 0) {
                throw new RuntimeException("Could not connect to cash register");
            }
        }
        catch (InterruptedException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "";
        Iterator iter = sales.iterator();
        long ratio = 1L;
        for (int i = 0; i < this.onlineDecimalPlaces; ++i) {
            ratio *= 10L;
        }
        while (iter.hasNext()) {
            EcrSale sale = (EcrSale)iter.next();
            int cod = sale.getCod();
            String price = "";
            long printPrice = (long)((double)ratio * sale.getPpuDupaDiscount());
            price = Utils.getString2DecimalsNoTrunc(printPrice);
            double nrPortii = sale.getQuantity();
            String commandText = "S;" + cod + ";" + sale.getProduct() + ";" + price + ";" + Utils.getString3Decimals(nrPortii) + ";" + sale.getDepartament() + ";" + Generic.getGrupa(sale) + ";" + sale.getCodTva() + ";;";
            items = items + commandText;
            items = items + "\n";
        }
        long totalLong = (long)((double)ratio * total);
        String totalS = Utils.getString2DecimalsNoTrunc(totalLong);
        items = items + "T;;" + totalS + ";;\n";
        this.pt.addToQueue(items);
    }

    @Override
    public void finishInitialize() {
        try {
            Logger.logDebug(this, "Unload ecr");
            this.unload();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Logger.logDebug(this, "Regserv ecr");
            this.regserv();
            Logger.logDebug(this, "Connect ecr");
            this.connect();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void introduNumerar(double suma) {
        String s = "I;1;" + Utils.getString2Decimals(suma) + ";";
        this.pt.addToQueue(s);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void forceTotal() {
    }
}

