/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.total;

import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private boolean discountGlobal;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
    }

    @Override
    public void printBonFiscal(Vector<EcrSale> sales, double total, Vector<EcrPlata> plati, TipPlata cashDefault, Vector<String> commentsq, String orderIdentifier, int idOrder) {
        String items = "KARAT\n";
        for (EcrSale ecrSale : sales) {
            double nrPortii = ecrSale.getQuantity();
            double ppu = this.discountGlobal ? ecrSale.getPpuOriginal() : ecrSale.getPpuDupaDiscount();
            String priceString = EcrUtils.getPrice(8, this.onlineDecimalPlaces, ppu);
            String prodName = this.getString(16, ecrSale.getProduct()).toUpperCase();
            String portiiString = EcrUtils.getPrice(9, 3, nrPortii);
            String commandText = "*" + prodName + "        " + priceString + this.onlineDecimalPlaces + portiiString + ecrSale.getCodTva();
            String dep = "" + ecrSale.getDepartament();
            commandText = !Validators.correctString(dep) ? commandText + "00" : commandText + dep + "0";
            items = items + commandText;
            items = items + "\n";
            if (!this.discountGlobal) continue;
            String tip = "";
            double pretOrig = ecrSale.getPpuOriginal();
            double ppuDupaDiscount = ecrSale.getPpuDupaDiscount();
            double diff = pretOrig - ppuDupaDiscount;
            if (pretOrig > ppuDupaDiscount) {
                tip = "-";
            } else {
                if (!(pretOrig < ppuDupaDiscount)) continue;
                tip = "+";
                diff = -diff;
            }
            long l = FloatUtils.convertToLong(diff, 2);
            String s = Utils.getStringMaxSize(8, l + "", Character.valueOf('0'), true);
            String s1 = tip + s + "2" + ecrSale.getCodTva();
            items = items + s1 + "\n";
        }
        for (String commentLine : commentsq) {
            items = items + "P" + Utils.getStringMaxSize(16, commentLine, null, false) + "\n";
        }
        String closeWithForceTotalLine = "T0000010000  CASH\n";
        if (plati == null || plati.size() == 0) {
            items = items + closeWithForceTotalLine;
        } else {
            double totalPlatit = 0.0;
            if (plati.size() > 1) {
                for (EcrPlata plata : plati) {
                    items = items + "RQ";
                    items = items + Utils.getStringMaxSize(1, plata.getEcrMapping(), null, false);
                    items = items + Utils.getStringMaxSize(6, plata.getTipPlata().toUpperCase(), Character.valueOf(' '), false);
                    items = items + "    ";
                    String number = Utils.getStringMaxSize(8, this.getAsLong(Utils.getString2DecimalsNoTrunc(plata.getSuma())), Character.valueOf('0'), true);
                    items = items + number;
                    items = items + "2";
                    items = items + "\n";
                    totalPlatit += plata.getSuma();
                }
            } else {
                EcrPlata plata = plati.get(0);
                items = items + "T";
                int number = (int)(plata.getSuma() * 1000.0);
                String value = Utils.getStringMaxSize(9, "" + number, Character.valueOf('0'), true);
                items = items + value;
                items = items + plata.getEcrMapping();
                items = items + Utils.getStringMaxSize(6, plata.getTipPlata().toUpperCase(), Character.valueOf(' '), false);
                items = items + "\n";
                totalPlatit += plata.getSuma();
            }
            if (totalPlatit < total || plati.size() > 1) {
                items = items + closeWithForceTotalLine;
            }
        }
        items = items + "END KARAT\n";
        this.pt.addToQueue(items);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void introduNumerar(double suma) {
        String s = "KARAT\n";
        s = s + "RI";
        String number = Utils.getStringMaxSize(8, this.getAsLong(Utils.getString2DecimalsNoTrunc(Math.abs(suma))), Character.valueOf('0'), true);
        if (suma < 0.0) {
            s = s + "-" + number + "2  CASH0\n";
        } else if (suma > 0.0) {
            s = s + "+" + number + "2  CASH0\n";
        } else {
            return;
        }
        s = s + "T0000010000   LEI\n";
        s = s + "END KARAT\n";
        this.pt.addToQueue(s);
    }

    private String getAsLong(String toStrip) {
        return toStrip.replaceAll("[^0-9]", "");
    }

    private String getString(int totalDigits, String toConvert) {
        if (toConvert.length() > totalDigits) {
            return toConvert.substring(0, totalDigits);
        }
        if (toConvert.length() < totalDigits) {
            String result = toConvert;
            for (int i = toConvert.length(); i < totalDigits; ++i) {
                result = result + " ";
            }
            return result;
        }
        return toConvert;
    }

    @Override
    public void forceTotal() {
    }
}

